/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodResolver {
    private final Set<Method> handlerMethods = new LinkedHashSet<Method>();
    private final Set<Method> initBinderMethods = new LinkedHashSet<Method>();
    private final Set<Method> modelAttributeMethods = new LinkedHashSet<Method>();
    private final RequestMapping typeLevelMapping;
    private final boolean sessionAttributesFound;
    private final Set<String> sessionAttributeNames = new HashSet<String>();
    private final Set<Class> sessionAttributeTypes = new HashSet<Class>();
    private final Set<String> actualSessionAttributeNames = Collections.synchronizedSet(new HashSet(4));

    public HandlerMethodResolver(final Class<?> handlerType) {
        ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (method.isAnnotationPresent(RequestMapping.class)) {
                    HandlerMethodResolver.this.handlerMethods.add(ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType));
                } else if (method.isAnnotationPresent(InitBinder.class)) {
                    HandlerMethodResolver.this.initBinderMethods.add(ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType));
                } else if (method.isAnnotationPresent(ModelAttribute.class)) {
                    HandlerMethodResolver.this.modelAttributeMethods.add(ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType));
                }
            }
        });
        this.typeLevelMapping = handlerType.getAnnotation(RequestMapping.class);
        SessionAttributes sessionAttributes = handlerType.getAnnotation(SessionAttributes.class);
        boolean bl = this.sessionAttributesFound = sessionAttributes != null;
        if (this.sessionAttributesFound) {
            this.sessionAttributeNames.addAll(Arrays.asList(sessionAttributes.value()));
            this.sessionAttributeTypes.addAll(Arrays.asList(sessionAttributes.types()));
        }
    }

    public final boolean hasHandlerMethods() {
        return !this.handlerMethods.isEmpty();
    }

    public final Set<Method> getHandlerMethods() {
        return this.handlerMethods;
    }

    public final Set<Method> getInitBinderMethods() {
        return this.initBinderMethods;
    }

    public final Set<Method> getModelAttributeMethods() {
        return this.modelAttributeMethods;
    }

    public boolean hasTypeLevelMapping() {
        return this.typeLevelMapping != null;
    }

    public RequestMapping getTypeLevelMapping() {
        return this.typeLevelMapping;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributesFound;
    }

    public boolean isSessionAttribute(String attrName, Class attrType) {
        if (this.sessionAttributeNames.contains(attrName) || this.sessionAttributeTypes.contains(attrType)) {
            this.actualSessionAttributeNames.add(attrName);
            return true;
        }
        return false;
    }

    public Set<String> getActualSessionAttributeNames() {
        return this.actualSessionAttributeNames;
    }
}

