/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jts.jca;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.jts.jca.TxWorkManager;
import com.arjuna.ats.internal.jta.transaction.jts.jca.WorkSynchronization;
import com.arjuna.ats.internal.jta.transaction.jts.jca.XATerminatorImple;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import com.arjuna.ats.jta.TransactionManager;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.JBossXATerminator;
import org.jboss.util.UnexpectedThrowable;

public class XATerminator
extends XATerminatorImple
implements JBossXATerminator {
    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid, (int)timeout / 1000);
            switch (tx.getStatus()) {
                case 5: 
                case 6: {
                    throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.inactive"), "3");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.completing"), "2");
                }
            }
            TxWorkManager.addWork((Work)work, (Transaction)tx);
            tx.registerSynchronization((Synchronization)new WorkSynchronization((Transaction)tx));
        }
        catch (WorkCompletedException ex) {
            throw ex;
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknown"), "-1");
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            if (!TxWorkManager.getWork((Transaction)tx).equals(work)) {
                throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknownwork"), "-1");
            }
            TransactionManager.transactionManager().resume((Transaction)tx);
        }
        catch (XAException ex) {
            throw new WorkCompletedException((Throwable)ex);
        }
        catch (InvalidTransactionException ex) {
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.inactive"), "3");
        }
        catch (SystemException ex) {
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jts.jca.unknown"), "-1");
        }
    }

    public void endWork(Work work, Xid xid) {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            TransactionManager.transactionManager().suspend();
            TxWorkManager.removeWork((Work)work, (Transaction)tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable((Throwable)ex);
        }
    }

    public void cancelWork(Work work, Xid xid) {
        try {
            SubordinateTransaction tx = SubordinationManager.getTransactionImporter().importTransaction(xid);
            TxWorkManager.removeWork((Work)work, (Transaction)tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable((Throwable)ex);
        }
    }
}

