/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;

public class UnicastStressTest {
    int num_channels = 6;
    int num_threads = 1;
    int num_msgs = 1000;
    int msg_size = 4096;
    String props = null;
    int buddies = 1;
    private JChannel[] channels;
    private RpcDispatcher[] dispatchers;
    private Receiver[] receivers;
    final AtomicInteger msgs_received = new AtomicInteger(0);
    final AtomicLong bytes_received = new AtomicLong(0L);
    final CyclicBarrier start_barrier;
    final CyclicBarrier terminate_barrier;

    public UnicastStressTest(String props, int num_channels, int num_threads, int num_msgs, int msg_size, int buddies) {
        this.props = props;
        this.num_channels = num_channels;
        this.num_threads = num_threads;
        this.num_msgs = num_msgs;
        this.msg_size = msg_size;
        this.buddies = buddies;
        this.start_barrier = new CyclicBarrier(num_channels * num_threads + 1);
        this.terminate_barrier = new CyclicBarrier(num_channels + 1);
        if (buddies > num_channels) {
            throw new IllegalArgumentException("buddies needs to be smaller than number of channels");
        }
    }

    private void start() throws Exception {
        int i;
        this.channels = new JChannel[this.num_channels];
        this.receivers = new Receiver[this.num_channels];
        this.dispatchers = new RpcDispatcher[this.num_channels];
        int num_expected_msgs = this.num_threads * this.num_msgs * this.buddies;
        int num_total_msgs = this.num_channels * this.num_threads * this.num_msgs;
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new JChannel(this.props);
            this.receivers[i] = new Receiver(this.terminate_barrier, this.bytes_received, this.msgs_received, num_expected_msgs, num_total_msgs);
            this.dispatchers[i] = new RpcDispatcher((Channel)this.channels[i], null, null, this.receivers[i]);
            this.channels[i].connect("x");
        }
        for (i = 0; i < this.channels.length; ++i) {
            JChannel channel = this.channels[i];
            View view = channel.getView();
            Vector<Address> members = view.getMembers();
            if (members.size() != this.num_channels) {
                throw new Exception("cluster has not formed correctly, expected " + this.num_channels + " channels, found" + " only " + members.size() + " (view: " + view + ")");
            }
            Vector<Address> tmp = this.pickBuddies(members, channel.getLocalAddress());
            for (int j = 0; j < this.num_threads; ++j) {
                Sender sender = new Sender(this.start_barrier, this.msg_size, this.num_msgs, this.dispatchers[i], channel.getLocalAddress(), tmp);
                sender.start();
            }
        }
        System.out.println("sending " + num_total_msgs + " msgs with " + this.num_threads + " threads over " + this.num_channels + " channels");
        this.start_barrier.await();
        long start = System.currentTimeMillis();
        this.terminate_barrier.await();
        long stop = System.currentTimeMillis();
        for (i = 0; i < this.dispatchers.length; ++i) {
            this.dispatchers[i].stop();
        }
        for (i = this.channels.length - 1; i >= 0; --i) {
            this.channels[i].close();
        }
        this.printStats(stop - start);
    }

    private void printStats(long time) {
        for (int i = 0; i < this.receivers.length; ++i) {
            System.out.println("receiver #" + (i + 1) + ": " + this.receivers[i].getNumReceivedMessages());
        }
        System.out.println("total received messages for " + this.num_channels + " channels: " + this.msgs_received.get());
        System.out.println("total bytes received by " + this.num_channels + " channels: " + Util.printBytes(this.bytes_received.get()));
        System.out.println("time: " + time + " ms");
        double msgs_per_sec = (double)this.msgs_received.get() / ((double)time / 1000.0);
        double throughput = (double)this.bytes_received.get() / ((double)time / 1000.0);
        System.out.println("Message rate: " + msgs_per_sec + " msgs/sec");
        System.out.println("Throughput: " + Util.printBytes(throughput) + " / sec");
    }

    private Vector<Address> pickBuddies(Vector<Address> members, Address local_addr) {
        Vector<Address> retval = new Vector<Address>();
        int index = members.indexOf(local_addr);
        if (index < 0) {
            return null;
        }
        for (int i = index + 1; i <= index + this.buddies; ++i) {
            int real_index = i % members.size();
            Address buddy = members.get(real_index);
            retval.add(buddy);
        }
        return retval;
    }

    public static void main(String[] args) throws Exception {
        int num_channels = 6;
        int num_threads = 10;
        int num_msgs = 10000;
        int msg_size = 4096;
        int buddies = 1;
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-num_channels")) {
                num_channels = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-num_msgs")) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-msg_size")) {
                msg_size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-buddies")) {
                buddies = Integer.parseInt(args[++i]);
                continue;
            }
            UnicastStressTest.help();
            return;
        }
        new UnicastStressTest(props, num_channels, num_threads, num_msgs, msg_size, buddies).start();
    }

    private static void help() {
        System.out.println("UnicastStressTest [-help] [-props <props>] [-num_channels <num>] [-num_threads <threads per channel>] [-num_msgs <number of msgs per thread>] [-msg_size <size in bytes>] [-buddies <num>]");
    }

    private static class Sender
    extends Thread {
        private final CyclicBarrier barrier;
        private final int num_msgs;
        private final int msg_size;
        private final RpcDispatcher disp;
        private final Vector buddies;

        public Sender(CyclicBarrier barrier, int msg_size, int num_msgs, RpcDispatcher disp, Address local_addr, Vector buddies) {
            this.barrier = barrier;
            this.msg_size = msg_size;
            this.num_msgs = num_msgs;
            this.disp = disp;
            this.buddies = buddies;
            this.setName("Sender (" + local_addr + " --> " + buddies + ")");
        }

        @Override
        public void run() {
            byte[] data = new byte[this.msg_size];
            Object[] arg = new Object[]{data};
            Class[] types = new Class[]{byte[].class};
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < this.num_msgs; ++i) {
                this.disp.callRemoteMethods(this.buddies, "receive", arg, types, 6, 5000L, true);
            }
        }
    }

    public static class Receiver {
        final AtomicInteger msgs;
        final AtomicLong bytes;
        final int num_expected_msgs;
        final int num_total_msgs;
        final int print;
        final CyclicBarrier barrier;
        final AtomicInteger num_received_msgs = new AtomicInteger(0);

        public Receiver(CyclicBarrier barrier, AtomicLong bytes, AtomicInteger msgs, int num_expected_msgs, int num_total_msgs) {
            this.barrier = barrier;
            this.bytes = bytes;
            this.msgs = msgs;
            this.num_expected_msgs = num_expected_msgs;
            this.num_total_msgs = num_total_msgs;
            this.print = num_total_msgs / 10;
        }

        public int getNumReceivedMessages() {
            return this.num_received_msgs.get();
        }

        public void receive(byte[] data) {
            this.msgs.incrementAndGet();
            this.bytes.addAndGet(data.length);
            int count = this.num_received_msgs.incrementAndGet();
            if (count % this.print == 0) {
                System.out.println("received " + count + " msgs");
            }
            if ((count = this.num_received_msgs.get()) >= this.num_expected_msgs) {
                try {
                    this.barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

