/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.ByteArrayInputStream;

public class ExposedByteArrayInputStream
extends ByteArrayInputStream {
    public ExposedByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    public ExposedByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public void setData(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.mark = offset;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }
}

