/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    public static final int DEFAULT_ITERATOR_BLOCK_SIZE = 10;
    private int iteratorBlockSize = 10;

    StoredCollection(DataView view) {
        super(view);
    }

    public int getIteratorBlockSize() {
        return this.iteratorBlockSize;
    }

    public void setIteratorBlockSize(int blockSize) {
        if (blockSize < 2) {
            throw new IllegalArgumentException("blockSize is less than two: " + blockSize);
        }
        this.iteratorBlockSize = blockSize;
    }

    final boolean add(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoDupData(key, value, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    BlockIterator blockIterator() {
        return new BlockIterator(this, this.isWriteAllowed(), this.iteratorBlockSize);
    }

    public Iterator iterator() {
        return this.blockIterator();
    }

    public StoredIterator storedIterator() {
        return this.storedIterator(this.isWriteAllowed());
    }

    public StoredIterator storedIterator(boolean writeAllowed) {
        try {
            return new StoredIterator(this, writeAllowed && this.isWriteAllowed(), null);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public StoredIterator iterator(boolean writeAllowed) {
        return this.storedIterator(writeAllowed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        StoredIterator i = this.storedIterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object var4_3 = null;
            i.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            i.close();
            throw throwable;
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        int j = 0;
        StoredIterator i = this.storedIterator();
        try {
            while (j < a.length && i.hasNext()) {
                a[j++] = i.next();
            }
            if (j < a.length) {
                a[j] = null;
            } else if (i.hasNext()) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(a));
                while (i.hasNext()) {
                    list.add(i.next());
                }
                a = list.toArray(a);
            }
            Object var6_5 = null;
            i.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            i.close();
            throw throwable;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection coll) {
        boolean bl;
        Iterator i = this.storedOrExternalIterator(coll);
        try {
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                bl = false;
                Object var5_4 = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            StoredIterator.close(i);
            throw throwable;
        }
        {
            StoredIterator.close(i);
            return bl;
        }
        Object var5_5 = null;
        StoredIterator.close(i);
        return true;
    }

    public boolean addAll(Collection coll) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = this.storedOrExternalIterator(coll);
            boolean changed = false;
            while (i.hasNext()) {
                if (!this.add(i.next())) continue;
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean removeAll(Collection coll) {
        return this.removeAll(coll, true);
    }

    public boolean retainAll(Collection coll) {
        return this.removeAll(coll, false);
    }

    private boolean removeAll(Collection coll, boolean ifExistsInColl) {
        StoredIterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean changed = false;
            i = this.storedIterator();
            while (i.hasNext()) {
                if (ifExistsInColl != coll.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            i.close();
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            if (i != null) {
                i.close();
            }
            throw this.handleException(e, doAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (other instanceof Collection) {
            Collection otherColl = StoredCollection.copyCollection(other);
            StoredIterator i = this.storedIterator();
            try {
                while (i.hasNext()) {
                    if (otherColl.remove(i.next())) continue;
                    boolean bl = false;
                    Object var6_6 = null;
                    i.close();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                i.close();
                throw throwable;
            }
            boolean bl = otherColl.isEmpty();
            Object var6_7 = null;
            i.close();
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        StoredIterator i = this.storedIterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            ArrayList<Object> arrayList = list;
            Object var5_4 = null;
            i.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        StoredIterator i = this.storedIterator();
        try {
            while (i.hasNext()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append(i.next().toString());
            }
            buf.append(']');
            String string = buf.toString();
            Object var5_4 = null;
            i.close();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            i.close();
            throw throwable;
        }
    }

    public int size() {
        int count = 0;
        boolean countDups = this.iterateDuplicates();
        DataCursor cursor = null;
        try {
            try {
                cursor = new DataCursor(this.view, false, CursorConfig.READ_UNCOMMITTED);
                OperationStatus status = cursor.getFirst(false);
                while (status == OperationStatus.SUCCESS) {
                    count = countDups ? (count += cursor.count()) : ++count;
                    status = cursor.getNextNoDup(false);
                }
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeCursor(cursor);
            throw throwable;
        }
        this.closeCursor(cursor);
        return count;
    }

    public StoredIterator join(StoredContainer[] indices, Object[] indexKeys, JoinConfig joinConfig) {
        try {
            DataView[] indexViews = new DataView[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                indexViews[i] = indices[i].view;
            }
            DataCursor cursor = this.view.join(indexViews, indexKeys, joinConfig);
            return new StoredIterator(this, false, cursor);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    final Object getFirstOrLast(boolean doGetFirst) {
        Object object;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = doGetFirst ? cursor.getFirst(false) : cursor.getLast(false);
            object = status == OperationStatus.SUCCESS ? this.makeIteratorData(null, cursor) : null;
            Object var6_6 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return object;
    }

    Object makeIteratorData(BaseIterator iterator, DataCursor cursor) {
        return this.makeIteratorData(iterator, cursor.getKeyThang(), cursor.getPrimaryKeyThang(), cursor.getValueThang());
    }

    abstract Object makeIteratorData(BaseIterator var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object other) {
        if (other instanceof StoredCollection) {
            return ((StoredCollection)other).toList();
        }
        return new ArrayList((Collection)other);
    }
}

