/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.Set;

public class LatchedLockManager
extends LockManager {
    public LatchedLockManager(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockManager.LockAttemptResult attemptLock(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        LockManager.LockAttemptResult lockAttemptResult;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            lockAttemptResult = this.attemptLockInternal(nodeId, locker, type, nonBlockingRequest, lockTableIndex);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return lockAttemptResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String makeTimeoutMsg(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) throws DatabaseException {
        String string;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            string = this.makeTimeoutMsgInternal(lockOrTxn, locker, nodeId, type, grantType, useLock, timeout, start, now, database);
            Object var19_14 = null;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set releaseAndFindNotifyTargets(long nodeId, Lock lock, Locker locker, boolean removeFromLocker) throws DatabaseException {
        Set set;
        long nid = nodeId;
        if (nid == -1L) {
            nid = lock.getNodeId();
        }
        int lockTableIndex = this.getLockTableIndex(nid);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            set = this.releaseAndFindNotifyTargetsInternal(nodeId, lock, locker, removeFromLocker, lockTableIndex);
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transfer(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferInternal(nodeId, owningLocker, destLocker, demoteToRead, lockTableIndex);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferMultiple(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.transferMultipleInternal(nodeId, owningLocker, destLockers, lockTableIndex);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demote(long nodeId, Locker locker) throws DatabaseException {
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            this.demoteInternal(nodeId, locker, lockTableIndex);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocked(Long nodeId) throws DatabaseException {
        boolean bl;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            bl = this.isLockedInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOwner(Long nodeId, Locker locker, LockType type) throws DatabaseException {
        boolean bl;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            bl = this.isOwnerInternal(nodeId, locker, type, lockTableIndex);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isWaiter(Long nodeId, Locker locker) throws DatabaseException {
        boolean bl;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            bl = this.isWaiterInternal(nodeId, locker, lockTableIndex);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nWaiters(Long nodeId) throws DatabaseException {
        int n;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            n = this.nWaitersInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nOwners(Long nodeId) throws DatabaseException {
        int n;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            n = this.nOwnersInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Locker getWriteOwnerLocker(Long nodeId) throws DatabaseException {
        Locker locker;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            locker = this.getWriteOwnerLockerInternal(nodeId, lockTableIndex);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateOwnership(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb) throws DatabaseException {
        boolean bl;
        int lockTableIndex = this.getLockTableIndex(nodeId);
        Latch latch = this.lockTableLatches[lockTableIndex];
        latch.acquire();
        try {
            bl = this.validateOwnershipInternal(nodeId, locker, type, flushFromWaiters, mb, lockTableIndex);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            latch.release();
            throw throwable;
        }
        latch.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpLockTable(LockStats stats) throws DatabaseException {
        for (int i = 0; i < this.nLockTables; ++i) {
            Object var4_3;
            this.lockTableLatches[i].acquire();
            try {
                this.dumpLockTableInternal(stats, i);
                var4_3 = null;
            }
            catch (Throwable throwable) {
                var4_3 = null;
                this.lockTableLatches[i].release();
                throw throwable;
            }
            this.lockTableLatches[i].release();
        }
    }
}

