/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.raw;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;

public class RawStore {
    private Store store;

    public RawStore(Environment env, String storeName, StoreConfig config) throws DatabaseException {
        this.store = new Store(env, storeName, config, true);
    }

    public PrimaryIndex<Object, RawObject> getPrimaryIndex(String entityClass) throws DatabaseException {
        return this.store.getPrimaryIndex(Object.class, null, RawObject.class, entityClass);
    }

    public SecondaryIndex<Object, Object, RawObject> getSecondaryIndex(String entityClass, String keyName) throws DatabaseException {
        return this.store.getSecondaryIndex(this.getPrimaryIndex(entityClass), entityClass, Object.class, null, keyName);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    public void close() throws DatabaseException {
        this.store.close();
    }
}

