/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerCacheUtil {
    public static WeakReference<Class<?>>[] getSortedWeakReferenceForInterfaces(Class<?>[] ifaces) {
        if (ifaces == null) {
            return null;
        }
        WeakReference[] interfaces = new WeakReference[ifaces.length];
        for (int i = 0; i < ifaces.length; ++i) {
            interfaces[i] = new WeakReference(ifaces[i]);
        }
        Arrays.sort(interfaces, Alphabetical.singleton);
        return interfaces;
    }

    public static boolean compareClassRefs(WeakReference<Class<?>> my, WeakReference<Class<?>> other) {
        Class myClass = (Class)my.get();
        Class otherClass = (Class)other.get();
        if (myClass == null || otherClass == null) {
            return false;
        }
        return myClass.equals(otherClass);
    }

    public static boolean compareInterfaceRefs(WeakReference<Class<?>>[] my, WeakReference<Class<?>>[] other) {
        if (my == null && other != null || my == null && other != null) {
            return false;
        }
        if (my != null && other != null) {
            if (my.length != other.length) {
                return false;
            }
            for (int i = 0; i < my.length; ++i) {
                Class otherIf;
                Class myIf = (Class)my[i].get();
                if (myIf.equals(otherIf = (Class)other[i].get())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Alphabetical
    implements Comparator<WeakReference<Class<?>>> {
        static Alphabetical singleton = new Alphabetical();

        Alphabetical() {
        }

        @Override
        public int compare(WeakReference<Class<?>> o1, WeakReference<Class<?>> o2) {
            String name1 = ((Class)o1.get()).getName();
            String name2 = ((Class)o2.get()).getName();
            return name1.compareTo(name2);
        }
    }
}

