/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.function.AnsiTrimEmulationFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    public SQLServerDialect() {
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000, "varbinary($l)");
        this.registerFunction("second", new SQLFunctionTemplate(Hibernate.INTEGER, "datepart(second, ?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(Hibernate.INTEGER, "datepart(minute, ?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(Hibernate.INTEGER, "datepart(hour, ?1)"));
        this.registerFunction("locate", new StandardSQLFunction("charindex", Hibernate.INTEGER));
        this.registerFunction("extract", new SQLFunctionTemplate(Hibernate.INTEGER, "datepart(?1, ?3)"));
        this.registerFunction("mod", new SQLFunctionTemplate(Hibernate.INTEGER, "?1 % ?2"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "datalength(?1) * 8"));
        this.registerFunction("trim", new AnsiTrimEmulationFunction());
        this.registerKeyword("top");
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    @Override
    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(querySelect.length() + 8).append(querySelect).insert(SQLServerDialect.getAfterSelectInsertPoint(querySelect), " top " + limit).toString();
    }

    @Override
    public String appendIdentitySelectToInsert(String insertSQL) {
        return insertSQL + " select scope_identity()";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public String appendLockHint(LockMode mode, String tableName) {
        if (mode.greaterThan(LockMode.READ)) {
            return tableName + " with (updlock, rowlock)";
        }
        return tableName;
    }

    @Override
    public String getSelectGUIDString() {
        return "select newid()";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }
}

