/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.util.TimedCachePolicy;
import org.jboss.virtual.plugins.cache.CachePolicyVFSCache;
import org.jboss.virtual.spi.VFSContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedVFSCache
extends CachePolicyVFSCache<TimedCachePolicy> {
    private Integer defaultLifetime;
    private Boolean threadSafe;
    private Integer resolution;
    private String info;

    public TimedVFSCache() {
    }

    public TimedVFSCache(Integer defaultLifetime) {
        this(defaultLifetime, null, null);
    }

    public TimedVFSCache(Integer defaultLifetime, Boolean threadSafe, Integer resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        this.resolution = resolution;
    }

    public TimedVFSCache(Map<Object, Object> properties) {
        super(properties);
    }

    @Override
    public Iterable<VFSContext> getCachedContexts() {
        TimedCachePolicy tcp = (TimedCachePolicy)this.getPolicy();
        List keys = tcp.getValidKeys();
        if (keys != null && !keys.isEmpty()) {
            TreeMap contexts = new TreeMap();
            for (Object key : keys) {
                VFSContext context = (VFSContext)tcp.peek(key);
                if (context == null) continue;
                contexts.put(key, context);
            }
            return contexts.values();
        }
        return Collections.emptySet();
    }

    @Override
    protected TimedCachePolicy createCachePolicy() {
        if (this.defaultLifetime == null) {
            this.defaultLifetime = TimedVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.lifetime", null, true));
        }
        if (this.threadSafe == null) {
            this.threadSafe = Boolean.valueOf(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.threadSafe", Boolean.TRUE, true).toString());
        }
        if (this.resolution == null) {
            this.resolution = TimedVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.TimedPolicyCaching.resolution", null, true));
        }
        this.log.debug((Object)("Creating timed cache policy, lifetime: " + this.defaultLifetime + ", threadSafe: " + this.threadSafe + ", resolution: " + this.resolution));
        TimedCachePolicy tcp = this.defaultLifetime == null ? new TimedCachePolicy() : (this.resolution != null ? new TimedCachePolicy(this.defaultLifetime.intValue(), this.threadSafe.booleanValue(), this.resolution.intValue()) : new TimedCachePolicy(this.defaultLifetime.intValue()));
        this.info = this.getCacheName() + "{lifetime=" + tcp.getDefaultLifetime() + ", resolution=" + tcp.getResolution() + "}";
        return tcp;
    }

    protected String getCacheName() {
        return "TimedVFSCache";
    }

    public void setDefaultLifetime(Integer defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void setThreadSafe(Boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public String toString() {
        return this.info;
    }

    @Override
    protected Object wrapContext(VFSContext context) {
        return new VFSContextWrapper(((TimedCachePolicy)this.getPolicy()).getDefaultLifetime(), context);
    }

    private class VFSContextWrapper
    implements TimedCachePolicy.TimedEntry {
        private long expirationTime;
        private VFSContext context;

        VFSContextWrapper(long lifetime, VFSContext value) {
            this.expirationTime = 1000L * lifetime;
            this.context = value;
        }

        public void init(long now) {
            this.expirationTime += now;
        }

        public boolean isCurrent(long now) {
            return this.expirationTime > now;
        }

        public boolean refresh() {
            return false;
        }

        public void destroy() {
            try {
                this.context.cleanup();
            }
            catch (Exception e) {
                TimedVFSCache.this.log.debug((Object)("Error cleaning up: " + e));
            }
        }

        public Object getValue() {
            return this.context;
        }
    }
}

