/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import java.util.HashSet;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;

public class SecurityContext {
    protected static ThreadLocal currentDomain = new ThreadLocal();

    public static ThreadLocal getCurrentDomain() {
        return currentDomain;
    }

    public static Principal getCallerPrincipal() {
        return SecurityActions.getCallerPrincipal();
    }

    public static Principal getCurrentPrincipal() {
        return SecurityActions.getPrincipal();
    }

    public static boolean isCallerInRole(String roleName) {
        return SecurityContext.isInRole(SecurityContext.getCallerPrincipal(), roleName);
    }

    public static boolean isCurrentInRole(String roleName) {
        return SecurityContext.isInRole(SecurityContext.getCurrentPrincipal(), roleName);
    }

    private static boolean isInRole(Principal principal, String roleName) {
        RealmMapping rm = (RealmMapping)currentDomain.get();
        if (rm == null) {
            return false;
        }
        HashSet<SimplePrincipal> set = new HashSet<SimplePrincipal>();
        set.add(new SimplePrincipal(roleName));
        if (principal instanceof RunAsIdentity) {
            return ((RunAsIdentity)principal).doesUserHaveRole(set);
        }
        return rm.doesUserHaveRole(principal, set);
    }
}

