/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.logging.Logger;

public class PojoCacheManagerLocator {
    private static final Logger log = Logger.getLogger(PojoCacheManagerLocator.class);
    private static PojoCacheManagerLocator sharedInstance = new PojoCacheManagerLocator();
    public static final String STANDARD_JNDI_NAME = "java:CacheManager";
    private PojoCacheManager registeredManager;

    public static PojoCacheManagerLocator getCacheManagerLocator() {
        return sharedInstance;
    }

    protected static void setSharedInstance(PojoCacheManagerLocator shared) {
        if (shared == null) {
            throw new IllegalArgumentException("shared cannot be null");
        }
        sharedInstance = shared;
    }

    protected PojoCacheManagerLocator() {
    }

    public PojoCacheManager getCacheManager(Hashtable jndiProperties) {
        PojoCacheManager manager = this.registeredManager;
        if (manager == null) {
            try {
                manager = this.findInJndi(jndiProperties);
            }
            catch (NamingException e) {
                log.error((Object)"Problem finding CacheManager in JNDI", (Throwable)e);
            }
        }
        if (manager == null) {
            throw new IllegalStateException("CacheManager not found");
        }
        return manager;
    }

    public void registerCacheManager(PojoCacheManager manager) {
        if (manager != null) {
            if (this.registeredManager != null && manager != this.registeredManager) {
                throw new IllegalStateException("CacheManager already registered");
            }
            this.registeredManager = manager;
        }
    }

    public PojoCacheManager getDirectlyRegisteredManager() {
        return this.registeredManager;
    }

    public void deregisterCacheManager() {
        this.registeredManager = null;
    }

    protected PojoCacheManager findInJndi(Hashtable jndiProperties) throws NamingException {
        PojoCacheManager result = null;
        try {
            InitialContext ctx = new InitialContext(jndiProperties);
            Object mgr = ctx.lookup(STANDARD_JNDI_NAME);
            if (mgr instanceof PojoCacheManager) {
                result = (PojoCacheManager)mgr;
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return result;
    }
}

