/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins.action;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccessControllerContextAction<S extends ControllerContext, T extends ControllerContext>
implements ControllerContextAction {
    protected abstract boolean validateContext(ControllerContext var1);

    protected abstract S simpleContextCast(ControllerContext var1);

    protected abstract T fullContextCast(ControllerContext var1);

    @Override
    public void install(final ControllerContext context) throws Throwable {
        if (System.getSecurityManager() == null || !this.validateContext(context)) {
            this.simpleInstallAction(this.simpleContextCast(context));
        } else {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        AccessControllerContextAction.this.secureInstallAction(AccessControllerContextAction.this.fullContextCast(context));
                        return null;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    protected abstract void simpleInstallAction(S var1) throws Throwable;

    protected abstract void secureInstallAction(T var1) throws Throwable;

    @Override
    public void uninstall(final ControllerContext context) {
        if (System.getSecurityManager() == null || !this.validateContext(context)) {
            this.simpleUninstallAction(this.simpleContextCast(context));
        } else {
            PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AccessControllerContextAction.this.secureUninstallAction(AccessControllerContextAction.this.fullContextCast(context));
                    return null;
                }
            };
            AccessController.doPrivileged(action);
        }
    }

    protected abstract void simpleUninstallAction(S var1);

    protected abstract void secureUninstallAction(T var1);
}

