/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.utils;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class SocketProcessId
implements Process {
    private final int _thePort;
    private ServerSocket _theSocket;
    private static final int _defaultPort = 0;

    public SocketProcessId() {
        Integer port = Utility.lookupBoundedIntegerProperty(arjPropertyManager.propertyManager, "com.arjuna.ats.internal.arjuna.utils.SocketProcessIdPort", 0, "com.arjuna.ats.internal.arjuna.utils.SocketProcessId_1", 0, 65535);
        Integer maxPorts = Utility.lookupBoundedIntegerProperty(arjPropertyManager.propertyManager, "com.arjuna.ats.internal.arjuna.utils.SocketProcessIdMaxPorts", 1, "com.arjuna.ats.internal.arjuna.utils.SocketProcessId_3", 0, 65535);
        int maxPort = maxPorts <= 1 ? port : (65535 - maxPorts < port ? 65535 : port + maxPorts);
        do {
            this._theSocket = SocketProcessId.createSocket(port);
        } while (this._theSocket == null && (port = Integer.valueOf(port + 1)) < maxPort);
        int n = this._thePort = this._theSocket == null ? -1 : this._theSocket.getLocalPort();
        if (this._thePort == -1) {
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.utils.SocketProcessId_2"));
        }
    }

    public int getpid() {
        return this._thePort;
    }

    private static ServerSocket createSocket(int port) {
        try {
            return new ServerSocket(port, 0, InetAddress.getByName(null));
        }
        catch (IOException e) {
            return null;
        }
    }
}

