/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.ChildOA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import com.arjuna.orbportability.exceptions.FatalError;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import com.arjuna.orbportability.internal.utils.PostSetLoader;
import com.arjuna.orbportability.internal.utils.PreInitLoader;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.oa.Attribute;
import com.arjuna.orbportability.oa.PostShutdown;
import com.arjuna.orbportability.oa.PreShutdown;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.Servant;

public abstract class OA {
    com.arjuna.orbportability.oa.core.OA _oa = null;
    ORB _associatedORB = null;
    protected String _defaultAdapterName = null;
    protected String _oaName = null;
    protected Hashtable _preOAShutdown = new Hashtable();
    protected Hashtable _postOAShutdown = new Hashtable();
    protected Hashtable _preOAInitProperty = new Hashtable();
    protected Hashtable _postOAInitProperty = new Hashtable();
    private static HashMap _orbToOAMap = new HashMap();

    public synchronized void init() throws SystemException {
    }

    public synchronized void initPOA() throws InvalidName, SystemException {
        this.initPOA(null);
    }

    public ORB getAssociatedORB() {
        return this._associatedORB;
    }

    public void setPOA(POA p) throws SystemException {
        if (!this._oa.initialised()) {
            this._oa.rootPoa(p);
            this.performPostSet(this._oaName);
        }
    }

    protected void performPreInit(String oaName) {
        PreInitLoader preInit = new PreInitLoader(PreInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb"), this);
        preInit = new PreInitLoader(PreInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName()), this);
        preInit = new PreInitLoader(PreInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName(), oaName), this);
        preInit = null;
    }

    protected void performPostSet(String oaName) {
        new PostSetLoader(PostSetLoader.generateOAPropertyName("com.arjuna.orbportability.orb"), this);
        new PostSetLoader(PostSetLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName()), this);
        new PreInitLoader(PostSetLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName(), oaName), this);
    }

    protected void performPostInit(String oaName) {
        PostInitLoader postInit = new PostInitLoader(PostInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb"), this);
        postInit = new PostInitLoader(PostInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName()), this);
        postInit = new PostInitLoader(PostInitLoader.generateOAPropertyName("com.arjuna.orbportability.orb", this._associatedORB.getName(), oaName), this);
        postInit = null;
    }

    public synchronized void initPOA(String[] args) throws InvalidName, SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::initPOA (String[])");
        }
        if (!this._oa.initialised()) {
            if (this._associatedORB._orb.initialised()) {
                this.performPreInit(this._oaName);
                this.parseProperties(args, true);
                try {
                    this._oa.init();
                }
                catch (Exception e) {
                    if (opLogger.loggerI18N.isWarnEnabled()) {
                        opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.caughtexception", new java.lang.Object[]{"OA.initPOA", e.toString()});
                    }
                    throw new FatalError(e.toString());
                }
                this.parseProperties(args, false);
                this.performPostInit(this._oaName);
            } else {
                if (opLogger.loggerI18N.isFatalEnabled()) {
                    opLogger.loggerI18N.fatal("com.arjuna.orbportability.OA.uninitialsedorb");
                }
                throw new FatalError(opLogger.logMesg.getString("com.arjuna.orbportability.OA.uninitialsedorb"));
            }
        }
    }

    public synchronized ChildOA createPOA(String adapterName, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy, AdapterInactive {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::createPOA (" + adapterName + " )");
        }
        if (!this._oa.initialised()) {
            if (opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.oanotinitialised");
            }
            throw new AdapterInactive();
        }
        if (this._defaultAdapterName == null) {
            this._defaultAdapterName = adapterName;
        }
        this.performPreInit(adapterName);
        this._oa.createPOA(adapterName, policies);
        ChildOA newChildOA = new ChildOA(this._associatedORB, adapterName, this._oa.poa(adapterName));
        this.performPostInit(adapterName);
        return newChildOA;
    }

    public void initOA() throws InvalidName, SystemException {
        this.initOA(null);
    }

    public void initOA(String[] args) throws InvalidName, SystemException {
        this.initPOA(args);
    }

    public synchronized boolean addAttribute(Attribute p) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::addAttribute (" + p + ")");
        }
        if (this._oa.initialised() || p == null) {
            return false;
        }
        if (p.postOAInit()) {
            this._postOAInitProperty.put(p, p);
        } else {
            this._preOAInitProperty.put(p, p);
        }
        return true;
    }

    public abstract void destroy() throws SystemException;

    public synchronized POA rootPoa() {
        return this._oa.rootPoa();
    }

    public synchronized POA poa(String adapterName) {
        return this._oa.poa(adapterName);
    }

    public synchronized boolean setPoa(String adapterName, POA thePOA) {
        if (adapterName != null) {
            this._oa.poa(adapterName, thePOA);
            return true;
        }
        return false;
    }

    public synchronized void addPreShutdown(PreShutdown c) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::addPreShutdown (" + c + ")");
        }
        this._preOAShutdown.put(c, c);
    }

    public synchronized void addPostShutdown(PostShutdown c) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::addPostShutdown (" + c + ")");
        }
        this._postOAShutdown.put(c, c);
    }

    public abstract Object corbaReference(Servant var1);

    public Object corbaReference(Servant obj, POA poa) {
        try {
            return poa.servant_to_reference(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public abstract boolean objectIsReady(Servant var1, byte[] var2) throws SystemException;

    public abstract boolean objectIsReady(Servant var1) throws SystemException;

    public abstract boolean shutdownObject(Object var1);

    public abstract boolean shutdownObject(Servant var1);

    public void run(String name) throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::run (" + name + ")");
        }
        this._oa.run(name);
    }

    public void run() throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::run ()");
        }
        this._oa.run();
    }

    private final void parseProperties(String[] params, boolean preInit) {
        Hashtable work;
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::parseProperties (String[], " + preInit + ")");
        }
        Hashtable hashtable = work = preInit ? this._preOAInitProperty : this._postOAInitProperty;
        if (!work.isEmpty()) {
            Enumeration elements = work.elements();
            while (elements.hasMoreElements()) {
                Attribute p = (Attribute)elements.nextElement();
                if (p == null) continue;
                if (opLogger.logger.isDebugEnabled()) {
                    opLogger.logger.debug(16L, 4L, 1L, "Attribute " + p + " initialising.");
                }
                p.initialise(params);
                p = null;
            }
        }
    }

    OA(ORB orb, String oaName) {
        this._associatedORB = orb;
        this._oaName = oaName;
        this._oa = new com.arjuna.orbportability.oa.core.OA(this._associatedORB._orb);
    }

    OA(ORB orb, String oaName, POA oa) {
        this._associatedORB = orb;
        this._oaName = oaName;
        this._oa = new com.arjuna.orbportability.oa.core.OA(this._associatedORB._orb);
        this._oa.rootPoa(oa);
    }

    public static synchronized RootOA getRootOA(ORB associatedORB) {
        RootOA oa = (RootOA)_orbToOAMap.get(associatedORB);
        if (oa == null) {
            oa = new RootOA(associatedORB);
            _orbToOAMap.put(associatedORB, oa);
        }
        return oa;
    }
}

