/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.vfs.spi.util;

import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;

public class ServiceLoader<S>
implements Iterable<S> {
    private final Class<S> serviceClass;
    private final ClassLoader loader;
    private Iterator<S> serviceIterator;

    public static <S> ServiceLoader<S> load(Class<S> serviceClass) {
        return ServiceLoader.load(serviceClass, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoader<S>(service, loader);
    }

    private ServiceLoader(Class<S> serviceClass, ClassLoader loader) {
        this.serviceClass = serviceClass;
        this.loader = loader;
        this.reload();
    }

    @Override
    public Iterator<S> iterator() {
        return this.serviceIterator;
    }

    public void reload() {
        this.serviceIterator = ServiceRegistry.lookupProviders(this.serviceClass, this.loader);
    }
}

