/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.test.visitor.TypeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesVisitorImpl
implements TypeVisitor {
    private static Logger log = Logger.getLogger(PropertiesVisitorImpl.class);
    private HashMap<Class, Properties> typeProperties = new HashMap();
    private HashMap<String, Properties> methodProperties = new HashMap();
    private HashMap<String, Properties> fieldProperties = new HashMap();

    public HashMap<Class, Properties> getTypeProperties() {
        return this.typeProperties;
    }

    public HashMap<String, Properties> getMethodProperties() {
        return this.methodProperties;
    }

    public HashMap<String, Properties> getFieldProperties() {
        return this.fieldProperties;
    }

    @Override
    public void visitClass(Class type) {
        String className = type.getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String name = className + ".properties";
        this.loadProperties(type, type, name, this.typeProperties);
    }

    @Override
    public void visitInterfaces(Class[] ifaces) {
        for (int n = 0; n < ifaces.length; ++n) {
            Class i = ifaces[n];
            this.visitClass(i);
        }
    }

    @Override
    public void visitMethods(Method[] methods) {
        for (int n = 0; n < methods.length; ++n) {
            Method m = methods[n];
            String name = m.getName();
            Class<?> type = m.getDeclaringClass();
            this.loadProperties(type, name, name, this.methodProperties);
        }
    }

    @Override
    public void visitFields(Field[] fields) {
        for (int n = 0; n < fields.length; ++n) {
            Field f = fields[n];
            String name = f.getName();
            Class<?> type = f.getDeclaringClass();
            this.loadProperties(type, name, name, this.fieldProperties);
        }
    }

    protected <T> void loadProperties(Class type, T key, String name, HashMap<T, Properties> map) {
        URL res = type.getResource(name);
        if (res != null) {
            Properties props = map.get(key);
            if (props == null) {
                props = new Properties();
                map.put(key, props);
            }
            try {
                InputStream is = res.openStream();
                props.load(is);
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)("Failed to load properties for name: " + name), (Throwable)e);
            }
            catch (NullPointerException e) {
                log.warn((Object)("Failed to load properties for name: " + name), (Throwable)e);
            }
        }
    }
}

