/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.EncodingUtil;

public class URI
implements Cloneable,
Comparable,
Serializable {
    static final long serialVersionUID = 604752400577948726L;
    protected int hash = 0;
    protected char[] _uri = null;
    protected String protocolCharset = null;
    protected static String defaultProtocolCharset;
    protected static String defaultDocumentCharset;
    protected static String defaultDocumentCharsetByLocale;
    protected static String defaultDocumentCharsetByPlatform;
    protected char[] _scheme = null;
    protected char[] _opaque = null;
    protected char[] _authority = null;
    protected char[] _userinfo = null;
    protected char[] _host = null;
    protected int _port = -1;
    protected char[] _path = null;
    protected char[] _query = null;
    protected char[] _fragment = null;
    protected static final char[] rootPath;
    protected static final BitSet percent;
    protected static final BitSet digit;
    protected static final BitSet alpha;
    protected static final BitSet alphanum;
    protected static final BitSet hex;
    protected static final BitSet escaped;
    protected static final BitSet mark;
    protected static final BitSet unreserved;
    protected static final BitSet reserved;
    protected static final BitSet uric;
    protected static final BitSet fragment;
    protected static final BitSet query;
    protected static final BitSet pchar;
    protected static final BitSet param;
    protected static final BitSet segment;
    protected static final BitSet path_segments;
    protected static final BitSet abs_path;
    protected static final BitSet uric_no_slash;
    protected static final BitSet opaque_part;
    protected static final BitSet path;
    protected static final BitSet port;
    protected static final BitSet IPv4address;
    protected static final BitSet IPv6address;
    protected static final BitSet IPv6reference;
    protected static final BitSet toplabel;
    protected static final BitSet domainlabel;
    protected static final BitSet hostname;
    protected static final BitSet host;
    protected static final BitSet hostport;
    protected static final BitSet userinfo;
    public static final BitSet within_userinfo;
    protected static final BitSet server;
    protected static final BitSet reg_name;
    protected static final BitSet authority;
    protected static final BitSet scheme;
    protected static final BitSet rel_segment;
    protected static final BitSet rel_path;
    protected static final BitSet net_path;
    protected static final BitSet hier_part;
    protected static final BitSet relativeURI;
    protected static final BitSet absoluteURI;
    protected static final BitSet URI_reference;
    public static final BitSet control;
    public static final BitSet space;
    public static final BitSet delims;
    public static final BitSet unwise;
    public static final BitSet disallowed_rel_path;
    public static final BitSet disallowed_opaque_part;
    public static final BitSet allowed_authority;
    public static final BitSet allowed_opaque_part;
    public static final BitSet allowed_reg_name;
    public static final BitSet allowed_userinfo;
    public static final BitSet allowed_within_userinfo;
    public static final BitSet allowed_IPv6reference;
    public static final BitSet allowed_host;
    public static final BitSet allowed_within_authority;
    public static final BitSet allowed_abs_path;
    public static final BitSet allowed_rel_path;
    public static final BitSet allowed_within_path;
    public static final BitSet allowed_query;
    public static final BitSet allowed_within_query;
    public static final BitSet allowed_fragment;
    protected boolean _is_hier_part;
    protected boolean _is_opaque_part;
    protected boolean _is_net_path;
    protected boolean _is_abs_path;
    protected boolean _is_rel_path;
    protected boolean _is_reg_name;
    protected boolean _is_server;
    protected boolean _is_hostname;
    protected boolean _is_IPv4address;
    protected boolean _is_IPv6reference;

    protected URI() {
    }

    public URI(String string, boolean bl, String string2) throws URIException, NullPointerException {
        this.protocolCharset = string2;
        this.parseUriReference(string, bl);
    }

    public URI(String string, boolean bl) throws URIException, NullPointerException {
        this.parseUriReference(string, bl);
    }

    public URI(char[] cArray, String string) throws URIException, NullPointerException {
        this.protocolCharset = string;
        this.parseUriReference(new String(cArray), true);
    }

    public URI(char[] cArray) throws URIException, NullPointerException {
        this.parseUriReference(new String(cArray), true);
    }

    public URI(String string, String string2) throws URIException {
        this.protocolCharset = string2;
        this.parseUriReference(string, false);
    }

    public URI(String string) throws URIException {
        this.parseUriReference(string, false);
    }

    public URI(String string, String string2, String string3) throws URIException {
        if (string == null) {
            throw new URIException(1, "scheme required");
        }
        char[] cArray = string.toLowerCase().toCharArray();
        if (!this.validate(cArray, scheme)) {
            throw new URIException(1, "incorrect scheme");
        }
        this._scheme = cArray;
        this._opaque = URI.encode(string2, allowed_opaque_part, this.getProtocolCharset());
        this._is_opaque_part = true;
        this._fragment = string3 == null ? null : string3.toCharArray();
        this.setURI();
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        if (string2 != null) {
            stringBuffer.append("//");
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            if (!(string == null && string2 == null || string3.startsWith("/"))) {
                throw new URIException(1, "abs_path requested");
            }
            stringBuffer.append(string3);
        }
        if (string4 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string4);
        }
        if (string5 != null) {
            stringBuffer.append('#');
            stringBuffer.append(string5);
        }
        this.parseUriReference(stringBuffer.toString(), false);
    }

    public URI(String string, String string2, String string3, int n) throws URIException {
        this(string, string2, string3, n, null, null, null);
    }

    public URI(String string, String string2, String string3, int n, String string4) throws URIException {
        this(string, string2, string3, n, string4, null, null);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5) throws URIException {
        this(string, string2, string3, n, string4, string5, null);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URIException {
        this(string, string3 == null ? null : (string2 != null ? string2 + '@' : "") + string3 + (n != -1 ? ":" + n : ""), string4, string5, string6);
    }

    public URI(String string, String string2, String string3, String string4) throws URIException {
        this(string, string2, string3, null, string4);
    }

    public URI(URI uRI, String string) throws URIException {
        this(uRI, new URI(string));
    }

    public URI(URI uRI, String string, boolean bl) throws URIException {
        this(uRI, new URI(string, bl));
    }

    public URI(URI uRI, URI uRI2) throws URIException {
        if (uRI._scheme == null) {
            throw new URIException(1, "base URI required");
        }
        if (uRI._scheme != null) {
            this._scheme = uRI._scheme;
            this._authority = uRI._authority;
            this._is_net_path = uRI._is_net_path;
        }
        if (uRI._is_opaque_part || uRI2._is_opaque_part) {
            this._scheme = uRI._scheme;
            this._is_opaque_part = uRI._is_opaque_part || uRI2._is_opaque_part;
            this._opaque = uRI2._opaque;
            this._fragment = uRI2._fragment;
            this.setURI();
            return;
        }
        boolean bl = Arrays.equals(uRI._scheme, uRI2._scheme);
        if (!(uRI2._scheme == null || bl && uRI2._authority == null)) {
            this._scheme = uRI2._scheme;
            this._is_net_path = uRI2._is_net_path;
            this._authority = uRI2._authority;
            if (uRI2._is_server) {
                this._is_server = uRI2._is_server;
                this._userinfo = uRI2._userinfo;
                this._host = uRI2._host;
                this._port = uRI2._port;
            } else if (uRI2._is_reg_name) {
                this._is_reg_name = uRI2._is_reg_name;
            }
            this._is_abs_path = uRI2._is_abs_path;
            this._is_rel_path = uRI2._is_rel_path;
            this._path = uRI2._path;
        } else if (uRI._authority != null && uRI2._scheme == null) {
            this._is_net_path = uRI._is_net_path;
            this._authority = uRI._authority;
            if (uRI._is_server) {
                this._is_server = uRI._is_server;
                this._userinfo = uRI._userinfo;
                this._host = uRI._host;
                this._port = uRI._port;
            } else if (uRI._is_reg_name) {
                this._is_reg_name = uRI._is_reg_name;
            }
        }
        if (uRI2._authority != null) {
            this._is_net_path = uRI2._is_net_path;
            this._authority = uRI2._authority;
            if (uRI2._is_server) {
                this._is_server = uRI2._is_server;
                this._userinfo = uRI2._userinfo;
                this._host = uRI2._host;
                this._port = uRI2._port;
            } else if (uRI2._is_reg_name) {
                this._is_reg_name = uRI2._is_reg_name;
            }
            this._is_abs_path = uRI2._is_abs_path;
            this._is_rel_path = uRI2._is_rel_path;
            this._path = uRI2._path;
        }
        if (uRI2._authority == null && (uRI2._scheme == null || bl)) {
            if ((uRI2._path == null || uRI2._path.length == 0) && uRI2._query == null) {
                this._path = uRI._path;
                this._query = uRI._query;
            } else {
                this._path = this.resolvePath(uRI._path, uRI2._path);
            }
        }
        if (uRI2._query != null) {
            this._query = uRI2._query;
        }
        if (uRI2._fragment != null) {
            this._fragment = uRI2._fragment;
        }
        this.setURI();
        this.parseUriReference(new String(this._uri), true);
    }

    protected static char[] encode(String string, BitSet bitSet, String string2) throws URIException {
        if (string == null) {
            throw new IllegalArgumentException("Original string may not be null");
        }
        if (bitSet == null) {
            throw new IllegalArgumentException("Allowed bitset may not be null");
        }
        byte[] byArray = URLCodec.encodeUrl((BitSet)bitSet, (byte[])EncodingUtil.getBytes(string, string2));
        return EncodingUtil.getAsciiString(byArray).toCharArray();
    }

    protected static String decode(char[] cArray, String string) throws URIException {
        if (cArray == null) {
            throw new IllegalArgumentException("Component array of chars may not be null");
        }
        return URI.decode(new String(cArray), string);
    }

    protected static String decode(String string, String string2) throws URIException {
        if (string == null) {
            throw new IllegalArgumentException("Component array of chars may not be null");
        }
        byte[] byArray = null;
        try {
            byArray = URLCodec.decodeUrl((byte[])EncodingUtil.getAsciiBytes(string));
        }
        catch (DecoderException decoderException) {
            throw new URIException(decoderException.getMessage());
        }
        return EncodingUtil.getString(byArray, string2);
    }

    protected boolean prevalidate(String string, BitSet bitSet) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!bitSet.get(cArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean validate(char[] cArray, BitSet bitSet) {
        return this.validate(cArray, 0, -1, bitSet);
    }

    protected boolean validate(char[] cArray, int n, int n2, BitSet bitSet) {
        if (n2 == -1) {
            n2 = cArray.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            if (bitSet.get(cArray[i])) continue;
            return false;
        }
        return true;
    }

    protected void parseUriReference(String string, boolean bl) throws URIException {
        Object object;
        int n;
        char[] cArray;
        char[] cArray2;
        if (string == null) {
            throw new URIException("URI-Reference required");
        }
        String string2 = string.trim();
        int n2 = string2.length();
        if (n2 > 0 && this.validate(cArray2 = new char[]{string2.charAt(0)}, delims) && n2 >= 2 && this.validate(cArray = new char[]{string2.charAt(n2 - 1)}, delims)) {
            string2 = string2.substring(1, n2 - 1);
            n2 -= 2;
        }
        int n3 = 0;
        boolean bl2 = false;
        int n4 = string2.indexOf(58);
        int n5 = string2.indexOf(47);
        if (n4 <= 0 && !string2.startsWith("//") || n5 >= 0 && n5 < n4) {
            bl2 = true;
        }
        if ((n = this.indexFirstOf(string2, bl2 ? "/?#" : ":/?#", n3)) == -1) {
            n = 0;
        }
        if (n > 0 && n < n2 && string2.charAt(n) == ':') {
            object = string2.substring(0, n).toLowerCase().toCharArray();
            if (!this.validate((char[])object, scheme)) {
                throw new URIException("incorrect scheme");
            }
            this._scheme = object;
            n3 = ++n;
        }
        this._is_hier_part = false;
        this._is_rel_path = false;
        this._is_abs_path = false;
        this._is_net_path = false;
        if (0 <= n && n < n2 && string2.charAt(n) == '/') {
            this._is_hier_part = true;
            if (n + 2 < n2 && string2.charAt(n + 1) == '/' && !bl2) {
                int n6 = this.indexFirstOf(string2, "/?#", n + 2);
                if (n6 == -1) {
                    n6 = string2.substring(n + 2).length() == 0 ? n + 2 : string2.length();
                }
                this.parseAuthority(string2.substring(n + 2, n6), bl);
                n3 = n = n6;
                this._is_net_path = true;
            }
            if (n3 == n) {
                this._is_abs_path = true;
            }
        }
        if (n3 < n2) {
            int n7 = this.indexFirstOf(string2, "?#", n3);
            if (n7 == -1) {
                n7 = string2.length();
            }
            if (!this._is_abs_path) {
                if (!bl && this.prevalidate(string2.substring(n3, n7), disallowed_rel_path) || bl && this.validate(string2.substring(n3, n7).toCharArray(), rel_path)) {
                    this._is_rel_path = true;
                } else if (!bl && this.prevalidate(string2.substring(n3, n7), disallowed_opaque_part) || bl && this.validate(string2.substring(n3, n7).toCharArray(), opaque_part)) {
                    this._is_opaque_part = true;
                } else {
                    this._path = null;
                }
            }
            String string3 = string2.substring(n3, n7);
            if (bl) {
                this.setRawPath(string3.toCharArray());
            } else {
                this.setPath(string3);
            }
            n = n7;
        }
        object = this.getProtocolCharset();
        if (0 <= n && n + 1 < n2 && string2.charAt(n) == '?') {
            int n8 = string2.indexOf(35, n + 1);
            if (n8 == -1) {
                n8 = string2.length();
            }
            if (bl) {
                this._query = string2.substring(n + 1, n8).toCharArray();
                if (!this.validate(this._query, uric)) {
                    throw new URIException("Invalid query");
                }
            } else {
                this._query = URI.encode(string2.substring(n + 1, n8), allowed_query, (String)object);
            }
            n = n8;
        }
        if (0 <= n && n + 1 <= n2 && string2.charAt(n) == '#') {
            this._fragment = n + 1 == n2 ? "".toCharArray() : (bl ? string2.substring(n + 1).toCharArray() : URI.encode(string2.substring(n + 1), allowed_fragment, (String)object));
        }
        this.setURI();
    }

    protected int indexFirstOf(String string, String string2) {
        return this.indexFirstOf(string, string2, -1);
    }

    protected int indexFirstOf(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        if (string2 == null || string2.length() == 0) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            return -1;
        }
        int n2 = string.length();
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n3 = string.indexOf(cArray[i], n);
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2 == string.length() ? -1 : n2;
    }

    protected int indexFirstOf(char[] cArray, char c) {
        return this.indexFirstOf(cArray, c, 0);
    }

    protected int indexFirstOf(char[] cArray, char c, int n) {
        if (cArray == null || cArray.length == 0) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        } else if (n > cArray.length) {
            return -1;
        }
        for (int i = n; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    protected void parseAuthority(String string, boolean bl) throws URIException {
        this._is_IPv6reference = false;
        this._is_IPv4address = false;
        this._is_hostname = false;
        this._is_server = false;
        this._is_reg_name = false;
        String string2 = this.getProtocolCharset();
        boolean bl2 = true;
        int n = 0;
        int n2 = string.indexOf(64);
        if (n2 != -1) {
            this._userinfo = bl ? string.substring(0, n2).toCharArray() : URI.encode(string.substring(0, n2), allowed_userinfo, string2);
            n = n2 + 1;
        }
        if ((n2 = string.indexOf(91, n)) >= n) {
            n2 = string.indexOf(93, n);
            if (n2 == -1) {
                throw new URIException(1, "IPv6reference");
            }
            this._host = bl ? string.substring(n, n2).toCharArray() : URI.encode(string.substring(n, ++n2), allowed_IPv6reference, string2);
            this._is_IPv6reference = true;
        } else {
            n2 = string.indexOf(58, n);
            if (n2 == -1) {
                n2 = string.length();
                bl2 = false;
            }
            this._host = string.substring(n, n2).toCharArray();
            if (this.validate(this._host, IPv4address)) {
                this._is_IPv4address = true;
            } else if (this.validate(this._host, hostname)) {
                this._is_hostname = true;
            } else {
                this._is_reg_name = true;
            }
        }
        if (this._is_reg_name) {
            this._is_IPv6reference = false;
            this._is_IPv4address = false;
            this._is_hostname = false;
            this._is_server = false;
            if (bl) {
                this._authority = string.toCharArray();
                if (!this.validate(this._authority, reg_name)) {
                    throw new URIException("Invalid authority");
                }
            } else {
                this._authority = URI.encode(string, allowed_reg_name, string2);
            }
        } else {
            if (string.length() - 1 > n2 && bl2 && string.charAt(n2) == ':') {
                n = n2 + 1;
                try {
                    this._port = Integer.parseInt(string.substring(n));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new URIException(1, "invalid port number");
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this._userinfo != null) {
                stringBuffer.append(this._userinfo);
                stringBuffer.append('@');
            }
            if (this._host != null) {
                stringBuffer.append(this._host);
                if (this._port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this._port);
                }
            }
            this._authority = stringBuffer.toString().toCharArray();
            this._is_server = true;
        }
    }

    protected void setURI() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._scheme != null) {
            stringBuffer.append(this._scheme);
            stringBuffer.append(':');
        }
        if (this._is_net_path) {
            stringBuffer.append("//");
            if (this._authority != null) {
                stringBuffer.append(this._authority);
            }
        }
        if (this._opaque != null && this._is_opaque_part) {
            stringBuffer.append(this._opaque);
        } else if (this._path != null && this._path.length != 0) {
            stringBuffer.append(this._path);
        }
        if (this._query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this._query);
        }
        this._uri = stringBuffer.toString().toCharArray();
        this.hash = 0;
    }

    public boolean isAbsoluteURI() {
        return this._scheme != null;
    }

    public boolean isRelativeURI() {
        return this._scheme == null;
    }

    public boolean isHierPart() {
        return this._is_hier_part;
    }

    public boolean isOpaquePart() {
        return this._is_opaque_part;
    }

    public boolean isNetPath() {
        return this._is_net_path || this._authority != null;
    }

    public boolean isAbsPath() {
        return this._is_abs_path;
    }

    public boolean isRelPath() {
        return this._is_rel_path;
    }

    public boolean hasAuthority() {
        return this._authority != null || this._is_net_path;
    }

    public boolean isRegName() {
        return this._is_reg_name;
    }

    public boolean isServer() {
        return this._is_server;
    }

    public boolean hasUserinfo() {
        return this._userinfo != null;
    }

    public boolean isHostname() {
        return this._is_hostname;
    }

    public boolean isIPv4address() {
        return this._is_IPv4address;
    }

    public boolean isIPv6reference() {
        return this._is_IPv6reference;
    }

    public boolean hasQuery() {
        return this._query != null;
    }

    public boolean hasFragment() {
        return this._fragment != null;
    }

    public static void setDefaultProtocolCharset(String string) throws DefaultCharsetChanged {
        defaultProtocolCharset = string;
        throw new DefaultCharsetChanged(1, "the default protocol charset changed");
    }

    public static String getDefaultProtocolCharset() {
        return defaultProtocolCharset;
    }

    public String getProtocolCharset() {
        return this.protocolCharset != null ? this.protocolCharset : defaultProtocolCharset;
    }

    public static void setDefaultDocumentCharset(String string) throws DefaultCharsetChanged {
        defaultDocumentCharset = string;
        throw new DefaultCharsetChanged(2, "the default document charset changed");
    }

    public static String getDefaultDocumentCharset() {
        return defaultDocumentCharset;
    }

    public static String getDefaultDocumentCharsetByLocale() {
        return defaultDocumentCharsetByLocale;
    }

    public static String getDefaultDocumentCharsetByPlatform() {
        return defaultDocumentCharsetByPlatform;
    }

    public char[] getRawScheme() {
        return this._scheme;
    }

    public String getScheme() {
        return this._scheme == null ? null : new String(this._scheme);
    }

    public void setRawAuthority(char[] cArray) throws URIException, NullPointerException {
        this.parseAuthority(new String(cArray), true);
        this.setURI();
    }

    public void setEscapedAuthority(String string) throws URIException {
        this.parseAuthority(string, true);
        this.setURI();
    }

    public char[] getRawAuthority() {
        return this._authority;
    }

    public String getEscapedAuthority() {
        return this._authority == null ? null : new String(this._authority);
    }

    public String getAuthority() throws URIException {
        return this._authority == null ? null : URI.decode(this._authority, this.getProtocolCharset());
    }

    public char[] getRawUserinfo() {
        return this._userinfo;
    }

    public String getEscapedUserinfo() {
        return this._userinfo == null ? null : new String(this._userinfo);
    }

    public String getUserinfo() throws URIException {
        return this._userinfo == null ? null : URI.decode(this._userinfo, this.getProtocolCharset());
    }

    public char[] getRawHost() {
        return this._host;
    }

    public String getHost() throws URIException {
        if (this._host != null) {
            return URI.decode(this._host, this.getProtocolCharset());
        }
        return null;
    }

    public int getPort() {
        return this._port;
    }

    public void setRawPath(char[] cArray) throws URIException {
        if (cArray == null || cArray.length == 0) {
            this._opaque = cArray;
            this._path = cArray;
            this.setURI();
            return;
        }
        cArray = this.removeFragmentIdentifier(cArray);
        if (this._is_net_path || this._is_abs_path) {
            if (cArray[0] != '/') {
                throw new URIException(1, "not absolute path");
            }
            if (!this.validate(cArray, abs_path)) {
                throw new URIException(3, "escaped absolute path not valid");
            }
            this._path = cArray;
        } else if (this._is_rel_path) {
            int n = this.indexFirstOf(cArray, '/');
            if (n == 0) {
                throw new URIException(1, "incorrect path");
            }
            if (n > 0 && !this.validate(cArray, 0, n - 1, rel_segment) && !this.validate(cArray, n, -1, abs_path) || n < 0 && !this.validate(cArray, 0, -1, rel_segment)) {
                throw new URIException(3, "escaped relative path not valid");
            }
            this._path = cArray;
        } else if (this._is_opaque_part) {
            if (!uric_no_slash.get(cArray[0]) && !this.validate(cArray, 1, -1, uric)) {
                throw new URIException(3, "escaped opaque part not valid");
            }
            this._opaque = cArray;
        } else {
            throw new URIException(1, "incorrect path");
        }
        this.setURI();
    }

    public void setEscapedPath(String string) throws URIException {
        if (string == null) {
            this._opaque = null;
            this._path = null;
            this.setURI();
            return;
        }
        this.setRawPath(string.toCharArray());
    }

    public void setPath(String string) throws URIException {
        if (string == null || string.length() == 0) {
            this._opaque = string == null ? null : string.toCharArray();
            this._path = this._opaque;
            this.setURI();
            return;
        }
        String string2 = this.getProtocolCharset();
        if (this._is_net_path || this._is_abs_path) {
            this._path = URI.encode(string, allowed_abs_path, string2);
        } else if (this._is_rel_path) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = string.indexOf(47);
            if (n == 0) {
                throw new URIException(1, "incorrect relative path");
            }
            if (n > 0) {
                stringBuffer.append(URI.encode(string.substring(0, n), allowed_rel_path, string2));
                stringBuffer.append(URI.encode(string.substring(n), allowed_abs_path, string2));
            } else {
                stringBuffer.append(URI.encode(string, allowed_rel_path, string2));
            }
            this._path = stringBuffer.toString().toCharArray();
        } else if (this._is_opaque_part) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.insert(0, URI.encode(string.substring(0, 1), uric_no_slash, string2));
            stringBuffer.insert(1, URI.encode(string.substring(1), uric, string2));
            this._opaque = stringBuffer.toString().toCharArray();
        } else {
            throw new URIException(1, "incorrect path");
        }
        this.setURI();
    }

    protected char[] resolvePath(char[] cArray, char[] cArray2) throws URIException {
        String string;
        String string2 = string = cArray == null ? "" : new String(cArray);
        if (cArray2 == null || cArray2.length == 0) {
            return this.normalize(cArray);
        }
        if (cArray2[0] == '/') {
            return this.normalize(cArray2);
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            cArray = string.substring(0, n + 1).toCharArray();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + cArray2.length);
        stringBuffer.append(n != -1 ? string.substring(0, n + 1) : "/");
        stringBuffer.append(cArray2);
        return this.normalize(stringBuffer.toString().toCharArray());
    }

    protected char[] getRawCurrentHierPath(char[] cArray) throws URIException {
        if (this._is_opaque_part) {
            throw new URIException(1, "no hierarchy level");
        }
        if (cArray == null) {
            throw new URIException(1, "empty path");
        }
        String string = new String(cArray);
        int n = string.indexOf(47);
        int n2 = string.lastIndexOf(47);
        if (n2 == 0) {
            return rootPath;
        }
        if (n != n2 && n2 != -1) {
            return string.substring(0, n2).toCharArray();
        }
        return cArray;
    }

    public char[] getRawCurrentHierPath() throws URIException {
        return this._path == null ? null : this.getRawCurrentHierPath(this._path);
    }

    public String getEscapedCurrentHierPath() throws URIException {
        char[] cArray = this.getRawCurrentHierPath();
        return cArray == null ? null : new String(cArray);
    }

    public String getCurrentHierPath() throws URIException {
        char[] cArray = this.getRawCurrentHierPath();
        return cArray == null ? null : URI.decode(cArray, this.getProtocolCharset());
    }

    public char[] getRawAboveHierPath() throws URIException {
        char[] cArray = this.getRawCurrentHierPath();
        return cArray == null ? null : this.getRawCurrentHierPath(cArray);
    }

    public String getEscapedAboveHierPath() throws URIException {
        char[] cArray = this.getRawAboveHierPath();
        return cArray == null ? null : new String(cArray);
    }

    public String getAboveHierPath() throws URIException {
        char[] cArray = this.getRawAboveHierPath();
        return cArray == null ? null : URI.decode(cArray, this.getProtocolCharset());
    }

    public char[] getRawPath() {
        return this._is_opaque_part ? this._opaque : this._path;
    }

    public String getEscapedPath() {
        char[] cArray = this.getRawPath();
        return cArray == null ? null : new String(cArray);
    }

    public String getPath() throws URIException {
        char[] cArray = this.getRawPath();
        return cArray == null ? null : URI.decode(cArray, this.getProtocolCharset());
    }

    public char[] getRawName() {
        int n;
        if (this._path == null) {
            return null;
        }
        int n2 = 0;
        for (n = this._path.length - 1; n >= 0; --n) {
            if (this._path[n] != '/') continue;
            n2 = n + 1;
            break;
        }
        n = this._path.length - n2;
        char[] cArray = new char[n];
        System.arraycopy(this._path, n2, cArray, 0, n);
        return cArray;
    }

    public String getEscapedName() {
        char[] cArray = this.getRawName();
        return cArray == null ? null : new String(cArray);
    }

    public String getName() throws URIException {
        char[] cArray = this.getRawName();
        return cArray == null ? null : URI.decode(this.getRawName(), this.getProtocolCharset());
    }

    public char[] getRawPathQuery() {
        if (this._path == null && this._query == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._path != null) {
            stringBuffer.append(this._path);
        }
        if (this._query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this._query);
        }
        return stringBuffer.toString().toCharArray();
    }

    public String getEscapedPathQuery() {
        char[] cArray = this.getRawPathQuery();
        return cArray == null ? null : new String(cArray);
    }

    public String getPathQuery() throws URIException {
        char[] cArray = this.getRawPathQuery();
        return cArray == null ? null : URI.decode(cArray, this.getProtocolCharset());
    }

    public void setRawQuery(char[] cArray) throws URIException {
        if (cArray == null || cArray.length == 0) {
            this._query = cArray;
            this.setURI();
            return;
        }
        if (!this.validate(cArray = this.removeFragmentIdentifier(cArray), query)) {
            throw new URIException(3, "escaped query not valid");
        }
        this._query = cArray;
        this.setURI();
    }

    public void setEscapedQuery(String string) throws URIException {
        if (string == null) {
            this._query = null;
            this.setURI();
            return;
        }
        this.setRawQuery(string.toCharArray());
    }

    public void setQuery(String string) throws URIException {
        if (string == null || string.length() == 0) {
            this._query = string == null ? null : string.toCharArray();
            this.setURI();
            return;
        }
        this.setRawQuery(URI.encode(string, allowed_query, this.getProtocolCharset()));
    }

    public char[] getRawQuery() {
        return this._query;
    }

    public String getEscapedQuery() {
        return this._query == null ? null : new String(this._query);
    }

    public String getQuery() throws URIException {
        return this._query == null ? null : URI.decode(this._query, this.getProtocolCharset());
    }

    public void setRawFragment(char[] cArray) throws URIException {
        if (cArray == null || cArray.length == 0) {
            this._fragment = cArray;
            this.hash = 0;
            return;
        }
        if (!this.validate(cArray, fragment)) {
            throw new URIException(3, "escaped fragment not valid");
        }
        this._fragment = cArray;
        this.hash = 0;
    }

    public void setEscapedFragment(String string) throws URIException {
        if (string == null) {
            this._fragment = null;
            this.hash = 0;
            return;
        }
        this.setRawFragment(string.toCharArray());
    }

    public void setFragment(String string) throws URIException {
        if (string == null || string.length() == 0) {
            this._fragment = string == null ? null : string.toCharArray();
            this.hash = 0;
            return;
        }
        this._fragment = URI.encode(string, allowed_fragment, this.getProtocolCharset());
        this.hash = 0;
    }

    public char[] getRawFragment() {
        return this._fragment;
    }

    public String getEscapedFragment() {
        return this._fragment == null ? null : new String(this._fragment);
    }

    public String getFragment() throws URIException {
        return this._fragment == null ? null : URI.decode(this._fragment, this.getProtocolCharset());
    }

    protected char[] removeFragmentIdentifier(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = new String(cArray).indexOf(35);
        if (n != -1) {
            cArray = new String(cArray).substring(0, n).toCharArray();
        }
        return cArray;
    }

    protected char[] normalize(char[] cArray) throws URIException {
        int n;
        if (cArray == null) {
            return null;
        }
        String string = new String(cArray);
        if (string.startsWith("./")) {
            string = string.substring(1);
        } else if (string.startsWith("../")) {
            string = string.substring(2);
        } else if (string.startsWith("..")) {
            string = string.substring(2);
        }
        int n2 = -1;
        while ((n2 = string.indexOf("/./")) != -1) {
            string = string.substring(0, n2) + string.substring(n2 + 2);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        int n3 = 0;
        while ((n2 = string.indexOf("/../", n3)) != -1) {
            n = string.lastIndexOf(47, n2 - 1);
            if (n >= 0) {
                string = string.substring(0, n) + string.substring(n2 + 3);
                continue;
            }
            n3 = n2 + 3;
        }
        if (string.endsWith("/..") && (n = string.lastIndexOf(47, string.length() - 4)) >= 0) {
            string = string.substring(0, n + 1);
        }
        while ((n2 = string.indexOf("/../")) != -1 && (n = string.lastIndexOf(47, n2 - 1)) < 0) {
            string = string.substring(n2 + 3);
        }
        if (string.endsWith("/..") && (n = string.lastIndexOf(47, string.length() - 4)) < 0) {
            string = "/";
        }
        return string.toCharArray();
    }

    public void normalize() throws URIException {
        if (this.isAbsPath()) {
            this._path = this.normalize(this._path);
            this.setURI();
        }
    }

    protected boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == null && cArray2 == null) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (!this.equals(this._scheme, uRI._scheme)) {
            return false;
        }
        if (!this.equals(this._opaque, uRI._opaque)) {
            return false;
        }
        if (!this.equals(this._authority, uRI._authority)) {
            return false;
        }
        if (!this.equals(this._path, uRI._path)) {
            return false;
        }
        if (!this.equals(this._query, uRI._query)) {
            return false;
        }
        return this.equals(this._fragment, uRI._fragment);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n;
            int n2;
            char[] cArray = this._uri;
            if (cArray != null) {
                n2 = cArray.length;
                for (n = 0; n < n2; ++n) {
                    this.hash = 31 * this.hash + cArray[n];
                }
            }
            if ((cArray = this._fragment) != null) {
                n2 = cArray.length;
                for (n = 0; n < n2; ++n) {
                    this.hash = 31 * this.hash + cArray[n];
                }
            }
        }
        return this.hash;
    }

    public int compareTo(Object object) throws ClassCastException {
        URI uRI = (URI)object;
        if (!this.equals(this._authority, uRI.getRawAuthority())) {
            return -1;
        }
        return this.toString().compareTo(uRI.toString());
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        URI uRI = (URI)super.clone();
        uRI._uri = this._uri;
        uRI._scheme = this._scheme;
        uRI._opaque = this._opaque;
        uRI._authority = this._authority;
        uRI._userinfo = this._userinfo;
        uRI._host = this._host;
        uRI._port = this._port;
        uRI._path = this._path;
        uRI._query = this._query;
        uRI._fragment = this._fragment;
        uRI.protocolCharset = this.protocolCharset;
        uRI._is_hier_part = this._is_hier_part;
        uRI._is_opaque_part = this._is_opaque_part;
        uRI._is_net_path = this._is_net_path;
        uRI._is_abs_path = this._is_abs_path;
        uRI._is_rel_path = this._is_rel_path;
        uRI._is_reg_name = this._is_reg_name;
        uRI._is_server = this._is_server;
        uRI._is_hostname = this._is_hostname;
        uRI._is_IPv4address = this._is_IPv4address;
        uRI._is_IPv6reference = this._is_IPv6reference;
        return uRI;
    }

    public char[] getRawURI() {
        return this._uri;
    }

    public String getEscapedURI() {
        return this._uri == null ? null : new String(this._uri);
    }

    public String getURI() throws URIException {
        return this._uri == null ? null : URI.decode(this._uri, this.getProtocolCharset());
    }

    public char[] getRawURIReference() {
        if (this._fragment == null) {
            return this._uri;
        }
        if (this._uri == null) {
            return this._fragment;
        }
        String string = new String(this._uri) + "#" + new String(this._fragment);
        return string.toCharArray();
    }

    public String getEscapedURIReference() {
        char[] cArray = this.getRawURIReference();
        return cArray == null ? null : new String(cArray);
    }

    public String getURIReference() throws URIException {
        char[] cArray = this.getRawURIReference();
        return cArray == null ? null : URI.decode(cArray, this.getProtocolCharset());
    }

    public String toString() {
        return this.getEscapedURI();
    }

    static {
        int n;
        defaultProtocolCharset = "UTF-8";
        defaultDocumentCharset = null;
        defaultDocumentCharsetByLocale = null;
        defaultDocumentCharsetByPlatform = null;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            defaultDocumentCharset = defaultDocumentCharsetByLocale = LocaleToCharsetMap.getCharset(locale);
        }
        try {
            defaultDocumentCharsetByPlatform = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (defaultDocumentCharset == null) {
            defaultDocumentCharset = defaultDocumentCharsetByPlatform;
        }
        rootPath = new char[]{'/'};
        percent = new BitSet(256);
        percent.set(37);
        digit = new BitSet(256);
        for (n = 48; n <= 57; ++n) {
            digit.set(n);
        }
        alpha = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            alpha.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            alpha.set(n);
        }
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        alphanum.or(digit);
        hex = new BitSet(256);
        hex.or(digit);
        for (n = 97; n <= 102; ++n) {
            hex.set(n);
        }
        for (n = 65; n <= 70; ++n) {
            hex.set(n);
        }
        escaped = new BitSet(256);
        escaped.or(percent);
        escaped.or(hex);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        fragment = uric;
        query = uric;
        pchar = new BitSet(256);
        pchar.or(unreserved);
        pchar.or(escaped);
        pchar.set(58);
        pchar.set(64);
        pchar.set(38);
        pchar.set(61);
        pchar.set(43);
        pchar.set(36);
        pchar.set(44);
        param = pchar;
        segment = new BitSet(256);
        segment.or(pchar);
        segment.set(59);
        segment.or(param);
        path_segments = new BitSet(256);
        path_segments.set(47);
        path_segments.or(segment);
        abs_path = new BitSet(256);
        abs_path.set(47);
        abs_path.or(path_segments);
        uric_no_slash = new BitSet(256);
        uric_no_slash.or(unreserved);
        uric_no_slash.or(escaped);
        uric_no_slash.set(59);
        uric_no_slash.set(63);
        uric_no_slash.set(59);
        uric_no_slash.set(64);
        uric_no_slash.set(38);
        uric_no_slash.set(61);
        uric_no_slash.set(43);
        uric_no_slash.set(36);
        uric_no_slash.set(44);
        opaque_part = new BitSet(256);
        opaque_part.or(uric_no_slash);
        opaque_part.or(uric);
        path = new BitSet(256);
        path.or(abs_path);
        path.or(opaque_part);
        port = digit;
        IPv4address = new BitSet(256);
        IPv4address.or(digit);
        IPv4address.set(46);
        IPv6address = new BitSet(256);
        IPv6address.or(hex);
        IPv6address.set(58);
        IPv6address.or(IPv4address);
        IPv6reference = new BitSet(256);
        IPv6reference.set(91);
        IPv6reference.or(IPv6address);
        IPv6reference.set(93);
        toplabel = new BitSet(256);
        toplabel.or(alphanum);
        toplabel.set(45);
        domainlabel = toplabel;
        hostname = new BitSet(256);
        hostname.or(toplabel);
        hostname.set(46);
        host = new BitSet(256);
        host.or(hostname);
        host.or(IPv6reference);
        hostport = new BitSet(256);
        hostport.or(host);
        hostport.set(58);
        hostport.or(port);
        userinfo = new BitSet(256);
        userinfo.or(unreserved);
        userinfo.or(escaped);
        userinfo.set(59);
        userinfo.set(58);
        userinfo.set(38);
        userinfo.set(61);
        userinfo.set(43);
        userinfo.set(36);
        userinfo.set(44);
        within_userinfo = new BitSet(256);
        within_userinfo.or(userinfo);
        within_userinfo.clear(59);
        within_userinfo.clear(58);
        within_userinfo.clear(64);
        within_userinfo.clear(63);
        within_userinfo.clear(47);
        server = new BitSet(256);
        server.or(userinfo);
        server.set(64);
        server.or(hostport);
        reg_name = new BitSet(256);
        reg_name.or(unreserved);
        reg_name.or(escaped);
        reg_name.set(36);
        reg_name.set(44);
        reg_name.set(59);
        reg_name.set(58);
        reg_name.set(64);
        reg_name.set(38);
        reg_name.set(61);
        reg_name.set(43);
        authority = new BitSet(256);
        authority.or(server);
        authority.or(reg_name);
        scheme = new BitSet(256);
        scheme.or(alpha);
        scheme.or(digit);
        scheme.set(43);
        scheme.set(45);
        scheme.set(46);
        rel_segment = new BitSet(256);
        rel_segment.or(unreserved);
        rel_segment.or(escaped);
        rel_segment.set(59);
        rel_segment.set(64);
        rel_segment.set(38);
        rel_segment.set(61);
        rel_segment.set(43);
        rel_segment.set(36);
        rel_segment.set(44);
        rel_path = new BitSet(256);
        rel_path.or(rel_segment);
        rel_path.or(abs_path);
        net_path = new BitSet(256);
        net_path.set(47);
        net_path.or(authority);
        net_path.or(abs_path);
        hier_part = new BitSet(256);
        hier_part.or(net_path);
        hier_part.or(abs_path);
        hier_part.or(query);
        relativeURI = new BitSet(256);
        relativeURI.or(net_path);
        relativeURI.or(abs_path);
        relativeURI.or(rel_path);
        relativeURI.or(query);
        absoluteURI = new BitSet(256);
        absoluteURI.or(scheme);
        absoluteURI.set(58);
        absoluteURI.or(hier_part);
        absoluteURI.or(opaque_part);
        URI_reference = new BitSet(256);
        URI_reference.or(absoluteURI);
        URI_reference.or(relativeURI);
        URI_reference.set(35);
        URI_reference.or(fragment);
        control = new BitSet(256);
        for (n = 0; n <= 31; ++n) {
            control.set(n);
        }
        control.set(127);
        space = new BitSet(256);
        space.set(32);
        delims = new BitSet(256);
        delims.set(60);
        delims.set(62);
        delims.set(35);
        delims.set(37);
        delims.set(34);
        unwise = new BitSet(256);
        unwise.set(123);
        unwise.set(125);
        unwise.set(124);
        unwise.set(92);
        unwise.set(94);
        unwise.set(91);
        unwise.set(93);
        unwise.set(96);
        disallowed_rel_path = new BitSet(256);
        disallowed_rel_path.or(uric);
        disallowed_rel_path.andNot(rel_path);
        disallowed_opaque_part = new BitSet(256);
        disallowed_opaque_part.or(uric);
        disallowed_opaque_part.andNot(opaque_part);
        allowed_authority = new BitSet(256);
        allowed_authority.or(authority);
        allowed_authority.clear(37);
        allowed_opaque_part = new BitSet(256);
        allowed_opaque_part.or(opaque_part);
        allowed_opaque_part.clear(37);
        allowed_reg_name = new BitSet(256);
        allowed_reg_name.or(reg_name);
        allowed_reg_name.clear(37);
        allowed_userinfo = new BitSet(256);
        allowed_userinfo.or(userinfo);
        allowed_userinfo.clear(37);
        allowed_within_userinfo = new BitSet(256);
        allowed_within_userinfo.or(within_userinfo);
        allowed_within_userinfo.clear(37);
        allowed_IPv6reference = new BitSet(256);
        allowed_IPv6reference.or(IPv6reference);
        allowed_IPv6reference.clear(91);
        allowed_IPv6reference.clear(93);
        allowed_host = new BitSet(256);
        allowed_host.or(hostname);
        allowed_host.or(allowed_IPv6reference);
        allowed_within_authority = new BitSet(256);
        allowed_within_authority.or(server);
        allowed_within_authority.or(reg_name);
        allowed_within_authority.clear(59);
        allowed_within_authority.clear(58);
        allowed_within_authority.clear(64);
        allowed_within_authority.clear(63);
        allowed_within_authority.clear(47);
        allowed_abs_path = new BitSet(256);
        allowed_abs_path.or(abs_path);
        allowed_abs_path.andNot(percent);
        allowed_abs_path.clear(43);
        allowed_rel_path = new BitSet(256);
        allowed_rel_path.or(rel_path);
        allowed_rel_path.clear(37);
        allowed_rel_path.clear(43);
        allowed_within_path = new BitSet(256);
        allowed_within_path.or(abs_path);
        allowed_within_path.clear(47);
        allowed_within_path.clear(59);
        allowed_within_path.clear(61);
        allowed_within_path.clear(63);
        allowed_query = new BitSet(256);
        allowed_query.or(uric);
        allowed_query.clear(37);
        allowed_within_query = new BitSet(256);
        allowed_within_query.or(allowed_query);
        allowed_within_query.andNot(reserved);
        allowed_fragment = new BitSet(256);
        allowed_fragment.or(uric);
        allowed_fragment.clear(37);
    }

    public static class LocaleToCharsetMap {
        private static final Hashtable LOCALE_TO_CHARSET_MAP = new Hashtable();

        public static String getCharset(Locale locale) {
            String string = (String)LOCALE_TO_CHARSET_MAP.get(locale.toString());
            if (string != null) {
                return string;
            }
            string = (String)LOCALE_TO_CHARSET_MAP.get(locale.getLanguage());
            return string;
        }

        static {
            LOCALE_TO_CHARSET_MAP.put("ar", "ISO-8859-6");
            LOCALE_TO_CHARSET_MAP.put("be", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("bg", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("ca", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("cs", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("da", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("de", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("el", "ISO-8859-7");
            LOCALE_TO_CHARSET_MAP.put("en", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("es", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("et", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("fi", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("fr", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("hr", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("hu", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("is", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("it", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("iw", "ISO-8859-8");
            LOCALE_TO_CHARSET_MAP.put("ja", "Shift_JIS");
            LOCALE_TO_CHARSET_MAP.put("ko", "EUC-KR");
            LOCALE_TO_CHARSET_MAP.put("lt", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("lv", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("mk", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("nl", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("no", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("pl", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("pt", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("ro", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("ru", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("sh", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("sk", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("sl", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("sq", "ISO-8859-2");
            LOCALE_TO_CHARSET_MAP.put("sr", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("sv", "ISO-8859-1");
            LOCALE_TO_CHARSET_MAP.put("tr", "ISO-8859-9");
            LOCALE_TO_CHARSET_MAP.put("uk", "ISO-8859-5");
            LOCALE_TO_CHARSET_MAP.put("zh", "GB2312");
            LOCALE_TO_CHARSET_MAP.put("zh_TW", "Big5");
        }
    }

    public static class DefaultCharsetChanged
    extends RuntimeException {
        public static final int UNKNOWN = 0;
        public static final int PROTOCOL_CHARSET = 1;
        public static final int DOCUMENT_CHARSET = 2;
        private int reasonCode;
        private String reason;

        public DefaultCharsetChanged(int n, String string) {
            super(string);
            this.reason = string;
            this.reasonCode = n;
        }

        public int getReasonCode() {
            return this.reasonCode;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

