/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.LinkedList;
import org.hornetq.utils.LinkedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedListImpl<E>
implements LinkedList<E> {
    private static final Logger log = Logger.getLogger(LinkedListImpl.class);
    private static final int INITIAL_ITERATOR_ARRAY_SIZE = 10;
    private Node<E> head = new Node<Object>(null);
    private Node<E> tail = null;
    private int size;
    private volatile Iterator[] iters = this.createIteratorArray(10);
    private int numIters;
    private int nextIndex;

    @Override
    public void addHead(E e) {
        Node<E> node = new Node<E>(e);
        node.next = this.head.next;
        node.prev = this.head;
        this.head.next = node;
        if (this.size == 0) {
            this.tail = node;
        }
        ++this.size;
    }

    @Override
    public void addTail(E e) {
        if (this.size == 0) {
            this.addHead(e);
        } else {
            Node<E> node = new Node<E>(e);
            node.prev = this.tail;
            this.tail.next = node;
            this.tail = node;
            ++this.size;
        }
    }

    @Override
    public E poll() {
        Node ret = this.head.next;
        if (ret != null) {
            this.removeAfter(this.head);
            return ret.val;
        }
        return null;
    }

    @Override
    public void clear() {
        this.head.next = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public LinkedListIterator<E> iterator() {
        return new Iterator();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("LinkedListImpl [ ");
        Node<E> node = this.head;
        while (node != null) {
            str.append(node.toString());
            if (node.next != null) {
                str.append(", ");
            }
            node = node.next;
        }
        return str.toString();
    }

    public int numIters() {
        return this.numIters;
    }

    private Iterator[] createIteratorArray(int size) {
        return (Iterator[])Array.newInstance(Iterator.class, size);
    }

    private void removeAfter(Node<E> node) {
        Node toRemove = node.next;
        node.next = toRemove.next;
        if (toRemove.next != null) {
            toRemove.next.prev = node;
        }
        if (toRemove == this.tail) {
            this.tail = node;
        }
        --this.size;
        if (toRemove.iterCount != 0) {
            this.nudgeIterators(toRemove);
        }
        toRemove.prev = null;
        toRemove.next = null;
    }

    private synchronized void nudgeIterators(Node<E> node) {
        for (int i = 0; i < this.numIters; ++i) {
            Iterator iter = this.iters[i];
            if (iter == null) continue;
            iter.nudged(node);
        }
    }

    private synchronized void addIter(Iterator iter) {
        if (this.numIters == this.iters.length) {
            this.resize(2 * this.numIters);
        }
        this.iters[this.nextIndex++] = iter;
        ++this.numIters;
    }

    private synchronized void resize(int newSize) {
        Iterator[] newIters = this.createIteratorArray(newSize);
        System.arraycopy(this.iters, 0, newIters, 0, this.numIters);
        this.iters = newIters;
    }

    private synchronized void removeIter(Iterator iter) {
        for (int i = 0; i < this.numIters; ++i) {
            if (iter != this.iters[i]) continue;
            this.iters[i] = null;
            if (i != this.numIters - 1) {
                System.arraycopy(this.iters, i + 1, this.iters, i, this.numIters - i - 1);
            }
            --this.numIters;
            if (this.numIters >= 10 && this.numIters == this.iters.length / 2) {
                this.resize(this.numIters);
            }
            --this.nextIndex;
            return;
        }
        throw new IllegalStateException("Cannot find iter to remove");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iterator
    implements LinkedListIterator<E> {
        Node<E> last;
        Node<E> current;
        boolean repeat;

        Iterator() {
            this.current = ((LinkedListImpl)LinkedListImpl.this).head.next;
            if (this.current != null) {
                ++this.current.iterCount;
            }
            LinkedListImpl.this.addIter(this);
        }

        @Override
        public void repeat() {
            this.repeat = true;
        }

        @Override
        public boolean hasNext() {
            Node e = this.getNode();
            if (e != null && (e != this.last || this.repeat)) {
                return true;
            }
            return this.canAdvance();
        }

        @Override
        public E next() {
            Node e = this.getNode();
            if (this.repeat) {
                this.repeat = false;
                if (e != null) {
                    return e.val;
                }
                if (this.canAdvance()) {
                    this.advance();
                    e = this.getNode();
                    return e.val;
                }
                throw new NoSuchElementException();
            }
            if (e == null || e == this.last) {
                if (this.canAdvance()) {
                    this.advance();
                    e = this.getNode();
                } else {
                    throw new NoSuchElementException();
                }
            }
            this.last = e;
            this.repeat = false;
            return e.val;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            LinkedListImpl.this.removeAfter(this.current.prev);
            this.last = null;
        }

        @Override
        public void close() {
            LinkedListImpl.this.removeIter(this);
        }

        public void nudged(Node<E> node) {
            if (this.current == node) {
                if (this.canAdvance()) {
                    this.advance();
                } else if (this.current.prev != LinkedListImpl.this.head) {
                    --this.current.iterCount;
                    this.current = this.current.prev;
                    ++this.current.iterCount;
                } else {
                    this.current = null;
                }
            }
        }

        private Node<E> getNode() {
            if (this.current == null) {
                this.current = ((LinkedListImpl)LinkedListImpl.this).head.next;
                if (this.current != null) {
                    ++this.current.iterCount;
                }
            }
            if (this.current != null) {
                return this.current;
            }
            return null;
        }

        private boolean canAdvance() {
            if (this.current == null) {
                this.current = ((LinkedListImpl)LinkedListImpl.this).head.next;
                if (this.current != null) {
                    ++this.current.iterCount;
                }
            }
            return this.current != null && this.current.next != null;
        }

        private void advance() {
            if (this.current == null || this.current.next == null) {
                throw new NoSuchElementException();
            }
            --this.current.iterCount;
            this.current = this.current.next;
            ++this.current.iterCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<E> {
        Node<E> next;
        Node<E> prev;
        final E val;
        int iterCount;

        Node(E e) {
            this.val = e;
        }

        public String toString() {
            return "Node, value = " + this.val;
        }
    }
}

