/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.logging.Logger;

public class Topology
implements Serializable {
    private static final long serialVersionUID = -9037171688692471371L;
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private static final Logger log = Logger.getLogger(Topology.class);
    private Executor executor = null;
    private volatile Object owner;
    private final Map<String, TopologyMember> topology = new ConcurrentHashMap<String, TopologyMember>();
    private final transient Map<String, Long> mapDelete = new ConcurrentHashMap<String, Long>();

    public Topology(Object owner) {
        this.owner = owner;
        if (log.isTraceEnabled()) {
            log.trace("Topology@" + Integer.toHexString(System.identityHashCode(this)) + " CREATE", new Exception("trace"));
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(this + "::Adding topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(this + "::Removing topology listener " + listener, new Exception("Trace"));
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsLive(String nodeId, TopologyMember memberInput) {
        Topology topology = this;
        synchronized (topology) {
            if (log.isDebugEnabled()) {
                log.debug(this + "::node " + nodeId + "=" + memberInput);
            }
            memberInput.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, memberInput);
            this.sendMemberUp(memberInput.getUniqueEventID(), nodeId, memberInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyMember updateBackup(String nodeId, TopologyMember memberInput) {
        if (log.isTraceEnabled()) {
            log.trace(this + "::updateBackup::" + nodeId + ", memberInput=" + memberInput);
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMember currentMember = this.getMember(nodeId);
            if (currentMember == null) {
                log.debug("There's no live to be updated on backup update, node=" + nodeId + " memberInput=" + memberInput, new Exception("trace"));
                currentMember = memberInput;
                this.topology.put(nodeId, currentMember);
            }
            TopologyMember newMember = new TopologyMember(currentMember.getA(), memberInput.getB());
            newMember.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, newMember);
            this.sendMemberUp(newMember.getUniqueEventID(), nodeId, newMember);
            return newMember;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMember memberInput) {
        Long deleteTme = this.mapDelete.get(nodeId);
        if (deleteTme != null && uniqueEventID < deleteTme) {
            log.debug("Update uniqueEvent=" + uniqueEventID + ", nodeId=" + nodeId + ", memberInput=" + memberInput + " being rejected as there was a delete done after that");
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMember currentMember = this.topology.get(nodeId);
            if (currentMember == null) {
                if (log.isDebugEnabled()) {
                    log.debug(this + "::NewMemeberAdd nodeId=" + nodeId + " member = " + memberInput, new Exception("trace"));
                }
                memberInput.setUniqueEventID(uniqueEventID);
                this.topology.put(nodeId, memberInput);
                this.sendMemberUp(uniqueEventID, nodeId, memberInput);
                return true;
            }
            if (uniqueEventID > currentMember.getUniqueEventID()) {
                TopologyMember newMember = new TopologyMember(memberInput.getA(), memberInput.getB());
                if (newMember.getA() == null && currentMember.getA() != null) {
                    newMember.setA(currentMember.getA());
                }
                if (newMember.getB() == null && currentMember.getB() != null) {
                    newMember.setB(currentMember.getB());
                }
                if (log.isDebugEnabled()) {
                    log.debug(this + "::updated currentMember=nodeID=" + nodeId + ", currentMember=" + currentMember + ", memberInput=" + memberInput + "newMember=" + newMember, new Exception("trace"));
                }
                newMember.setUniqueEventID(uniqueEventID);
                this.topology.remove(nodeId);
                this.topology.put(nodeId, newMember);
                this.sendMemberUp(uniqueEventID, nodeId, newMember);
                return true;
            }
            return false;
        }
    }

    private void sendMemberUp(final long uniqueEventID, final String nodeId, final TopologyMember memberToSend) {
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        if (log.isTraceEnabled()) {
            log.trace(this + "::prepare to send " + nodeId + " to " + copy.size() + " elements");
        }
        if (copy.size() > 0) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (log.isTraceEnabled()) {
                            log.trace(Topology.this + " informing " + listener + " about node up = " + nodeId + " connector = " + memberToSend.getConnector());
                        }
                        try {
                            listener.nodeUP(uniqueEventID, nodeId, memberToSend.getConnector(), false);
                        }
                        catch (Throwable e) {
                            log.warn(e.getMessage(), e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ClusterTopologyListener> copyListeners() {
        ArrayList<ClusterTopologyListener> listenersCopy;
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<ClusterTopologyListener>(this.topologyListeners);
        }
        return listenersCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(final long uniqueEventID, final String nodeId) {
        TopologyMember member;
        Topology topology = this;
        synchronized (topology) {
            member = this.topology.get(nodeId);
            if (member != null) {
                if (member.getUniqueEventID() > uniqueEventID) {
                    log.debug("The removeMember was issued before the node " + nodeId + " was started, ignoring call");
                    member = null;
                } else {
                    this.mapDelete.put(nodeId, uniqueEventID);
                    member = this.topology.remove(nodeId);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("removeMember " + this + " removing nodeID=" + nodeId + ", result=" + member + ", size = " + this.topology.size(), new Exception("trace"));
        }
        if (member != null) {
            final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (log.isTraceEnabled()) {
                            log.trace(this + " informing " + listener + " about node down = " + nodeId);
                        }
                        try {
                            listener.nodeDown(uniqueEventID, nodeId);
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage(), e);
                        }
                    }
                }
            });
        }
        return member != null;
    }

    protected void execute(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public void sendMember(final String nodeID) {
        final TopologyMember member = this.getMember(nodeID);
        final ArrayList<ClusterTopologyListener> copy = this.copyListeners();
        this.execute(new Runnable(){

            @Override
            public void run() {
                for (ClusterTopologyListener listener : copy) {
                    if (log.isDebugEnabled()) {
                        log.debug("Informing client listener " + listener + " about itself node " + nodeID + " with connector=" + member.getConnector());
                    }
                    listener.nodeUP(member.getUniqueEventID(), nodeID, member.getConnector(), false);
                }
            }
        });
    }

    public synchronized void sendTopology(final ClusterTopologyListener listener) {
        if (log.isDebugEnabled()) {
            log.debug(this + " is sending topology to " + listener);
        }
        this.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap copy;
                int count = 0;
                Topology topology = Topology.this;
                synchronized (topology) {
                    copy = new HashMap(Topology.this.topology);
                }
                for (Map.Entry entry : copy.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug(Topology.this + " sending " + (String)entry.getKey() + " / " + ((TopologyMember)entry.getValue()).getConnector() + " to " + listener);
                    }
                    listener.nodeUP(((TopologyMember)entry.getValue()).getUniqueEventID(), (String)entry.getKey(), ((TopologyMember)entry.getValue()).getConnector(), ++count == copy.size());
                }
            }
        });
    }

    public synchronized TopologyMember getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public synchronized boolean isEmpty() {
        return this.topology.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TopologyMember> getMembers() {
        ArrayList<TopologyMember> members;
        Topology topology = this;
        synchronized (topology) {
            members = new ArrayList<TopologyMember>(this.topology.values());
        }
        return members;
    }

    public synchronized int nodes() {
        int count = 0;
        for (TopologyMember member : this.topology.values()) {
            if (member.getA() != null) {
                ++count;
            }
            if (member.getB() == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized String describe() {
        return this.describe("");
    }

    public synchronized String describe(String text) {
        String desc = text + "topology on " + this + ":\n";
        for (Map.Entry<String, TopologyMember> entry : new HashMap<String, TopologyMember>(this.topology).entrySet()) {
            desc = desc + "\t" + entry.getKey() + " => " + entry.getValue() + "\n";
        }
        desc = desc + "\tnodes=" + this.nodes() + "\t" + "members=" + this.members();
        if (this.topology.isEmpty()) {
            desc = desc + "\tEmpty";
        }
        return desc;
    }

    public int members() {
        return this.topology.size();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TransportConfiguration getBackupForConnector(TransportConfiguration connectorConfiguration) {
        for (TopologyMember member : this.topology.values()) {
            if (member.getA() == null || !member.getA().equals(connectorConfiguration)) continue;
            return member.getB();
        }
        return null;
    }

    public String toString() {
        if (this.owner == null) {
            return "Topology@" + Integer.toHexString(System.identityHashCode(this));
        }
        return "Topology@" + Integer.toHexString(System.identityHashCode(this)) + "[owner=" + this.owner + "]";
    }
}

