/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.utils.ExecutorFactory;

public class PrintPages {
    public static void main(String[] arg) {
        if (arg.length != 2) {
            System.err.println("Usage: PrintPages <page foler> <journal folder>");
            System.exit(-1);
        }
        try {
            SimpleString[] stores;
            Pair<Map<Long, Set<PagePosition>>, Set<Long>> cursorACKs = PrintPages.loadCursorACKs(arg[1]);
            Set<Long> pgTXs = cursorACKs.getB();
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1);
            final ExecutorService executor = Executors.newFixedThreadPool(10);
            ExecutorFactory execfactory = new ExecutorFactory(){

                @Override
                public Executor getExecutor() {
                    return executor;
                }
            };
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO(arg[0], 1000L, scheduled, execfactory, false, null);
            HierarchicalObjectRepository<AddressSettings> addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
            addressSettingsRepository.setDefault(new AddressSettings());
            NullStorageManager sm = new NullStorageManager();
            PagingManagerImpl manager = new PagingManagerImpl(pageStoreFactory, sm, addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                System.out.println("####################################################################################################");
                System.out.println("Exploring store " + store);
                PagingStore pgStore = manager.getPageStore(store);
                int pgid = (int)pgStore.getFirstPage();
                for (int pg = 0; pg < pgStore.getNumberOfPages(); ++pg) {
                    System.out.println("*******   Page " + pgid);
                    Page page = pgStore.createPage(pgid);
                    page.open();
                    List<PagedMessage> msgs = page.read(sm);
                    page.close();
                    int msgID = 0;
                    for (PagedMessage msg : msgs) {
                        msg.initMessage(sm);
                        System.out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ", msg=" + msg.getMessage());
                        System.out.print(",Queues = ");
                        long[] q = msg.getQueueIDs();
                        for (int i = 0; i < q.length; ++i) {
                            System.out.print(q[i]);
                            PagePositionImpl posCheck = new PagePositionImpl(pgid, msgID);
                            boolean acked = false;
                            Set<PagePosition> positions = cursorACKs.getA().get(q[i]);
                            if (positions != null) {
                                acked = positions.contains(posCheck);
                            }
                            if (acked) {
                                System.out.print(" (ACK)");
                            }
                            if (i + 1 >= q.length) continue;
                            System.out.print(",");
                        }
                        if (msg.getTransactionID() >= 0L && !pgTXs.contains(msg.getTransactionID())) {
                            System.out.print(", **PG_TX_NOT_FOUND**");
                        }
                        System.out.println();
                        ++msgID;
                    }
                    ++pgid;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Pair<Map<Long, Set<PagePosition>>, Set<Long>> loadCursorACKs(String journalLocation) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(journalLocation, null);
        ConfigurationImpl defaultValues = new ConfigurationImpl();
        JournalImpl messagesJournal = new JournalImpl(defaultValues.getJournalFileSize(), defaultValues.getJournalMinFiles(), 0, 0, messagesFF, "hornetq-data", "hq", 1);
        messagesJournal.start();
        ArrayList<RecordInfo> records = new ArrayList<RecordInfo>();
        ArrayList<PreparedTransactionInfo> txs = new ArrayList<PreparedTransactionInfo>();
        messagesJournal.load(records, txs, null, false);
        HashMap<Long, HashSet<PagePosition>> cursorRecords = new HashMap<Long, HashSet<PagePosition>>();
        HashSet<Long> pgTXs = new HashSet<Long>();
        for (RecordInfo record : records) {
            byte[] data = record.data;
            HornetQBuffer buff = HornetQBuffers.wrappedBuffer(data);
            if (record.userRecordType == 39) {
                JournalStorageManager.CursorAckRecordEncoding encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buff);
                HashSet<PagePosition> set = (HashSet<PagePosition>)cursorRecords.get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    cursorRecords.put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (record.userRecordType != 35) continue;
            if (record.isUpdate) {
                JournalStorageManager.PageUpdateTXEncoding pageUpdate = new JournalStorageManager.PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                pgTXs.add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(record.id);
            pgTXs.add(pageTransactionInfo.getTransactionID());
        }
        return new Pair<Map<Long, Set<PagePosition>>, Set<Long>>(cursorRecords, pgTXs);
    }
}

