/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.util.Locale;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.richfaces.validator.ObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator
extends ObjectValidator {
    private volatile ValidatorFactory validatorFactory = null;

    BeanValidator() {
        ValidatorFactory.class.getName();
    }

    @Override
    protected String[] validate(Object base, String property, Object value, Locale locale, Set<String> profiles) {
        return this.extractMessages(this.getValidator(locale).validateProperty(base, property, (Class[])this.getGroups(profiles)));
    }

    @Override
    public String[] validateGraph(FacesContext context, Object value, Set<String> profiles) {
        Class[] groups = this.getGroups(profiles);
        Set violations = this.getValidator(this.calculateLocale(context)).validate(value, groups);
        String[] messages = this.extractMessages(violations);
        return messages;
    }

    private Class<?>[] getGroups(Set<String> profiles) {
        Class[] groups = null;
        if (null != profiles) {
            groups = new Class[profiles.size()];
            int i = 0;
            for (String group : profiles) {
                try {
                    groups[i] = Class.forName(group, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    try {
                        groups[i] = Class.forName(group);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new FacesException("Bean validation group not found " + group, (Throwable)e1);
                    }
                }
                ++i;
            }
        }
        return groups;
    }

    private String[] extractMessages(Set<ConstraintViolation<Object>> violations) {
        String[] messages = null;
        if (null != violations && violations.size() > 0) {
            messages = new String[violations.size()];
            int i = 0;
            for (ConstraintViolation<Object> constraintViolation : violations) {
                messages[i++] = constraintViolation.getMessage();
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Validator getValidator(Locale locale) {
        this.validatorFactory = null;
        if (null == this.validatorFactory) {
            BeanValidator beanValidator = this;
            synchronized (beanValidator) {
                if (null == this.validatorFactory) {
                    try {
                        this.validatorFactory = Validation.buildDefaultValidatorFactory();
                    }
                    catch (ValidationException e) {
                        throw new FacesException("Could not build a default Bean Validator factory", (Throwable)e);
                    }
                }
            }
        }
        ValidatorContext validatorContext = this.validatorFactory.usingContext();
        JsfMessageInterpolator jsfMessageInterpolator = new JsfMessageInterpolator(locale, this.validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
        Validator beanValidator = validatorContext.getValidator();
        return beanValidator;
    }

    private static class JsfMessageInterpolator
    implements MessageInterpolator {
        private Locale locale;
        private MessageInterpolator delegate;

        public JsfMessageInterpolator(Locale locale, MessageInterpolator delegate) {
            this.locale = locale;
            this.delegate = delegate;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            return this.delegate.interpolate(messageTemplate, context, this.locale);
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(messageTemplate, context, locale);
        }
    }
}

