/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.hibernate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.types.Parameter;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.hibernate.FactoryClassSubTask;
import xdoclet.modules.hibernate.HibernateProperties;
import xdoclet.modules.hibernate.HibernateSubTask;
import xdoclet.modules.hibernate.JBossServiceSubTask;
import xdoclet.modules.hibernate.XDocletModulesHibernateMessages;
import xdoclet.tagshandler.ClassTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XMethod;

public class HibernateTagsHandler
extends XDocletTagSupport {
    private LinkedList columnPrefixes = new LinkedList();
    private String currentTag;
    private String currentMappingElement;
    private Parameter currentJndiParameter;
    private Parameter currentOtherParameter;
    private Parameter currentOtherMapping;

    public String getFileName() throws XDocletException {
        return HibernateTagsHandler.getCurrentClass().getQualifiedName().replace('.', '/');
    }

    public JBossServiceSubTask getJBossServiceSubTask() {
        return (JBossServiceSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(JBossServiceSubTask.class));
    }

    public FactoryClassSubTask getFactoryClassSubTask() {
        return (FactoryClassSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(FactoryClassSubTask.class));
    }

    public HibernateProperties getHibernateProperties() throws XDocletException {
        try {
            return (HibernateProperties)DocletContext.getInstance().getActiveSubTask();
        }
        catch (ClassCastException e) {
            throw new XDocletException((Exception)e, "May occur if attribute is used with incorrect subtask.");
        }
    }

    public XMethod getIdMethod() throws XDocletException {
        XClass clazz = HibernateTagsHandler.getCurrentClass();
        for (XMethod method : clazz.getMethods(true)) {
            if (!method.getDoc().hasTag("hibernate.id")) continue;
            return method;
        }
        return null;
    }

    public String getCurrentTag(Properties attributes) {
        return this.currentTag;
    }

    public String getCurrentMappingElement(Properties attributes) {
        return this.currentMappingElement;
    }

    public void setCurrentTag(String template, Properties attributes) throws XDocletException {
        this.currentTag = attributes.getProperty("name");
        this.currentMappingElement = attributes.getProperty("mappingElement");
        this.generate(template);
        this.currentTag = null;
        this.currentMappingElement = null;
    }

    public void setColumnPrefix(String template, Properties attributes) throws XDocletException {
        String columnPrefix = attributes.getProperty("prefix", "");
        this.columnPrefixes.addLast(columnPrefix);
        this.generate(template);
        this.columnPrefixes.removeLast();
    }

    public String roleAttribute(Properties attributes) {
        return "1.1".equals(this.getHibernateSubTask().getVersion()) ? "role" : "name";
    }

    public String serviceClassName(Properties attributes) {
        if ("1.1".equals(this.getHibernateSubTask().getVersion())) {
            return "cirrus.hibernate.jmx.HibernateService";
        }
        return "net.sf.hibernate.jmx.HibernateService";
    }

    public void ifCurrentMappingElementIsnt(String template, Properties attributes) throws XDocletException {
        String element = attributes.getProperty("mappingElement");
        if (this.currentMappingElement == null || element == null || !this.currentMappingElement.equals(element)) {
            this.generate(template);
        }
    }

    public void ifHasCompositeId(String template, Properties attributes) throws XDocletException {
        this.hasCompositeId_Impl(template, true);
    }

    public void ifHasPrimitiveId(String template, Properties attributes) throws XDocletException {
        this.hasCompositeId_Impl(template, false);
    }

    public String serviceName() throws XDocletException {
        return this.getJBossServiceSubTask().getServiceName();
    }

    public String jndiName() throws XDocletException {
        return this.getHibernateProperties().getJndiName();
    }

    public void ifUseJndiFactory(String template, Properties attributes) throws XDocletException {
        if (this.getFactoryClassSubTask().isUseJndiFactory()) {
            this.generate(template);
        }
    }

    public void ifNotUseJndiFactory(String template, Properties attributes) throws XDocletException {
        if (!this.getFactoryClassSubTask().isUseJndiFactory()) {
            this.generate(template);
        }
    }

    public void ifHasJndiName(String template, Properties attributes) throws XDocletException {
        if (this.jndiName() != null) {
            this.generate(template);
        }
    }

    public void ifGeneratePropertyCache(String template, Properties attributes) throws XDocletException {
        if (this.dialect() != null && this.driver() != null && this.jdbcUrl() != null && this.userName() != null && this.password() != null) {
            this.generate(template);
        }
        if (this.dialect() != null && this.jndiName() != null) {
            this.generate(template);
        }
    }

    public void ifNotHasJndiName(String template, Properties attributes) throws XDocletException {
        if (this.jndiName() == null) {
            this.generate(template);
        }
    }

    public String dialect() throws XDocletException {
        return this.getHibernateProperties().getDialect();
    }

    public String dataSource() throws XDocletException {
        return this.getHibernateProperties().getDataSource();
    }

    public String driver() throws XDocletException {
        return this.getHibernateProperties().getDriver();
    }

    public String jdbcUrl() throws XDocletException {
        return this.getHibernateProperties().getJdbcUrl();
    }

    public String userName() throws XDocletException {
        return this.getHibernateProperties().getUserName();
    }

    public String password() throws XDocletException {
        return this.getHibernateProperties().getPassword();
    }

    public String poolSize() throws XDocletException {
        return this.getHibernateProperties().getPoolSize();
    }

    public String factoryClass() throws XDocletException {
        return this.getFactoryClassSubTask().getFactoryClass();
    }

    public String mappingList() throws XDocletException {
        StringBuffer sb = new StringBuffer();
        Collection classes = ClassTagsHandler.getAllClasses();
        for (XClass clazz : classes) {
            if (!clazz.getDoc().hasTag("hibernate.class", false)) continue;
            String mappingName = this.getHibernateSubTask().getMappingURL(clazz);
            sb.append(mappingName);
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public void logMapping(Properties attributes) throws XDocletException {
        System.out.println("   " + HibernateTagsHandler.getCurrentClass().getQualifiedName());
    }

    public void forAllPersistentClasses(String template, Properties attributes) throws XDocletException {
        Collection classes = ClassTagsHandler.getAllClasses();
        for (XClass clazz : classes) {
            if (!clazz.getDoc().hasTag("hibernate.class", false)) continue;
            HibernateTagsHandler.pushCurrentClass((XClass)clazz);
            this.generate(template);
            HibernateTagsHandler.popCurrentClass();
        }
    }

    public void forAllJndiProperties(String template, Properties attributes) throws XDocletException {
        Collection properties = this.getHibernateProperties().getJndiProperties();
        for (Parameter this.currentJndiParameter : properties) {
            this.generate(template);
            this.currentJndiParameter = null;
        }
    }

    public void forAllOtherProperties(String template, Properties attributes) throws XDocletException {
        Collection properties = this.getHibernateProperties().getOtherProperties();
        for (Parameter this.currentOtherParameter : properties) {
            this.generate(template);
            this.currentOtherParameter = null;
        }
    }

    public void forAllOtherMappings(String template, Properties attributes) throws XDocletException {
        Collection properties = this.getHibernateProperties().getOtherMappings();
        for (Parameter this.currentOtherMapping : properties) {
            this.generate(template);
            this.currentOtherMapping = null;
        }
    }

    public String jndiParameterName() {
        return this.currentJndiParameter.getName();
    }

    public String jndiParameterValue() {
        return this.currentJndiParameter.getValue();
    }

    public String otherParameterName() {
        return this.currentOtherParameter.getName();
    }

    public String otherParameterValue() {
        return this.currentOtherParameter.getValue();
    }

    public String otherMappingName() {
        return this.currentOtherMapping.getName();
    }

    public String otherMappingValue() {
        return this.currentOtherMapping.getValue();
    }

    public void forAllSubclasses(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(HibernateTagsHandler.class, (String)"forAllSubclasses");
        try {
            String typeName = HibernateTagsHandler.getCurrentClass().getQualifiedName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("typeName=" + typeName));
            }
            Collection classes = HibernateTagsHandler.getXJavaDoc().getSourceClasses();
            for (XClass clazz : classes) {
                log.debug((Object)("clazz=" + clazz));
                if (DocletSupport.isDocletGenerated((XClass)clazz)) {
                    log.debug((Object)"isDocletGenerated");
                    continue;
                }
                if (clazz.getSuperclass() != null && clazz.getSuperclass().getQualifiedName().equals(typeName)) {
                    log.debug((Object)"is a subclass");
                    XClass current = HibernateTagsHandler.getCurrentClass();
                    HibernateTagsHandler.pushCurrentClass((XClass)clazz);
                    this.generate(template);
                    HibernateTagsHandler.popCurrentClass();
                    if (HibernateTagsHandler.getCurrentClass() == current) continue;
                    HibernateTagsHandler.setCurrentClass((XClass)current);
                    continue;
                }
                log.debug((Object)"is not a subclass");
            }
        }
        catch (Exception e) {
            log.error((Object)"exception occurred", (Throwable)e);
        }
    }

    public String computeColumnName(Properties attributes) {
        StringBuffer buf = new StringBuffer();
        for (String columnPrefix : this.columnPrefixes) {
            if (columnPrefix == null || columnPrefix.length() <= 0) continue;
            buf.append(columnPrefix);
        }
        buf.append(attributes.getProperty("base"));
        return buf.toString();
    }

    void hasCompositeId_Impl(String template, boolean composite) throws XDocletException {
        boolean isPrimitive;
        XClass oldClass = HibernateTagsHandler.getCurrentClass();
        XMethod method = this.getIdMethod();
        if (method == null) {
            throw new XDocletException(Translator.getString(XDocletModulesHibernateMessages.class, (String)"NO_ID_PROPERTY", (String[])new String[]{HibernateTagsHandler.getCurrentClass().getQualifiedName()}));
        }
        boolean isUserType = false;
        String typeStr = method.getDoc().getTagAttributeValue("hibernate.id", "type");
        if (typeStr != null) {
            XClass typeClass = HibernateTagsHandler.getXJavaDoc().getXClass(typeStr);
            if (typeClass != null) {
                isUserType = typeClass.isA("cirrus.hibernate.UserType") || typeClass.isA("net.sf.hibernate.UserType");
            }
        } else {
            typeStr = method.getReturnType().getType().getQualifiedName();
        }
        boolean bl = isPrimitive = TypeTagsHandler.isPrimitiveType((String)typeStr) || "java.lang.Byte".equals(typeStr) || "java.lang.Double".equals(typeStr) || "java.lang.Float".equals(typeStr) || "java.lang.Integer".equals(typeStr) || "java.lang.Long".equals(typeStr) || "java.lang.Short".equals(typeStr) || "java.lang.String".equals(typeStr) || "java.math.BigDecimal".equals(typeStr) || "java.math.BigInteger".equals(typeStr) || isUserType;
        if (isPrimitive && !composite) {
            HibernateTagsHandler.setCurrentMethod((XMethod)method);
            this.generate(template);
        }
        if (composite && !isPrimitive) {
            XClass returnType = method.getReturnType().getType();
            if (returnType.isA("java.io.Serializable") && !returnType.isAbstract() && !"java.lang.Object".equals(returnType.getMethod("equals(java.lang.Object)", true).getContainingClass().getQualifiedName())) {
                HibernateTagsHandler.setCurrentMethod((XMethod)method);
                this.generate(template);
            } else {
                throw new XDocletException(Translator.getString(XDocletModulesHibernateMessages.class, (String)"WRONG_COMPOSITE_ID", (String[])new String[]{returnType.getQualifiedName()}));
            }
        }
        if (HibernateTagsHandler.getCurrentClass() != oldClass) {
            HibernateTagsHandler.setCurrentClass((XClass)oldClass);
        }
    }

    private HibernateSubTask getHibernateSubTask() {
        return (HibernateSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(HibernateSubTask.class));
    }
}

