/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl.expressive;

import java.util.List;
import java.util.Locale;
import org.richfaces.model.ExtendedFilterField;
import org.richfaces.model.FilterField;
import org.richfaces.model.filter.Filter;
import org.richfaces.model.impl.expressive.JavaBeanWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedBeanFilter
implements Filter<JavaBeanWrapper> {
    private final List<FilterField> filterFields;
    private Locale currentLocale;

    public WrappedBeanFilter(List<FilterField> filterFields) {
        this(filterFields, null);
    }

    public WrappedBeanFilter(List<FilterField> filterFields, Locale locale) {
        this.filterFields = filterFields;
        this.currentLocale = locale != null ? locale : Locale.getDefault();
    }

    public boolean accept(JavaBeanWrapper wrapper) {
        for (FilterField filterField : this.filterFields) {
            Object property;
            if (filterField instanceof ExtendedFilterField) {
                property = wrapper.getProperty(filterField.getExpression().getExpressionString());
                String filterValue = ((ExtendedFilterField)filterField).getFilterValue();
                if (filterValue == null || (filterValue = filterValue.trim().toUpperCase(this.currentLocale)).length() <= 0 || property != null && property.toString().trim().toUpperCase(this.currentLocale).startsWith(filterValue)) continue;
                return false;
            }
            property = wrapper.getProperty(filterField.getExpression().getExpressionString());
            if (((Boolean)property).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

