/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.recovery;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.xa.XAResource;
import org.jboss.jms.client.ClientAOPStackLoader;
import org.jboss.jms.client.JBossConnectionFactory;
import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.server.recovery.MessagingXAResourceWrapper2;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class ClusteredMessagingXAResourceRecovery
implements XAResourceRecovery {
    private boolean trace = log.isTraceEnabled();
    private static final Logger log = Logger.getLogger(ClusteredMessagingXAResourceRecovery.class);
    private String providerAdaptorName;
    private String username;
    private String password;
    private Queue<XAResource> resources = null;
    private Iterator<XAResource> iterator = null;
    private ConnectionFactoryDelegate factoryDelegate;

    public ClusteredMessagingXAResourceRecovery() {
        if (this.trace) {
            log.trace((Object)"Constructing BridgeXAResourceRecovery2");
        }
    }

    public boolean initialise(String config) {
        StringTokenizer tok;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " intialise: " + config));
        }
        if (!(tok = new StringTokenizer(config, ",")).hasMoreTokens()) {
            throw new IllegalArgumentException("Must specify provider adaptor name in config");
        }
        this.providerAdaptorName = tok.nextToken();
        if (tok.hasMoreTokens()) {
            this.username = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                throw new IllegalArgumentException("If username is specified, password must be specified too");
            }
            this.password = tok.nextToken();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " initialised"));
        }
        return true;
    }

    public boolean hasMoreResources() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " hasMoreResources"));
        }
        if (this.iterator == null) {
            this.shutdownResources();
            this.updateResources();
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        this.iterator = null;
        return false;
    }

    public XAResource getXAResource() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " getXAResource"));
        }
        return this.iterator.next();
    }

    protected void finalize() {
        this.shutdownResources();
    }

    private void shutdownResources() {
        if (this.resources == null) {
            return;
        }
        for (XAResource res : this.resources) {
            ((MessagingXAResourceWrapper2)res).close();
        }
        this.resources = null;
        this.iterator = null;
    }

    private void updateResources() {
        block15: {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " updating Resources"));
            }
            this.resources = new LinkedList<XAResource>();
            try {
                if (this.factoryDelegate == null) {
                    JBossConnectionFactory factory = this.getConnectionFactory();
                    this.factoryDelegate = factory.getDelegate();
                    try {
                        ClientAOPStackLoader.getInstance().load(this.factoryDelegate);
                    }
                    catch (Exception e) {
                        String msg = "Failed to download and/or install client side AOP stack";
                        log.error((Object)"Failed to download and/or install client side AOP stack", (Throwable)e);
                        throw new RuntimeException("Failed to download and/or install client side AOP stack", e);
                    }
                }
                if (this.factoryDelegate instanceof ClientClusteredConnectionFactoryDelegate) {
                    ClientConnectionFactoryDelegate[] delegates;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(this + " getting XAResources from the cluster"));
                    }
                    ClientClusteredConnectionFactoryDelegate clusteredFactoryDelegate = (ClientClusteredConnectionFactoryDelegate)this.factoryDelegate;
                    for (ClientConnectionFactoryDelegate del : delegates = clusteredFactoryDelegate.getDelegates()) {
                        try {
                            CreateConnectionResult result = del.createConnectionDelegate(this.username, this.password, -1);
                            MessagingXAResourceWrapper2 res = new MessagingXAResourceWrapper2(result.getDelegate(), del.getServerID());
                            this.resources.add(res);
                        }
                        catch (Throwable e) {
                            log.error((Object)("Failed to create resource for node " + del.getServerID()), e);
                        }
                    }
                    break block15;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " getting XAResources from single node"));
                }
                ClientConnectionDelegate delegate = null;
                try {
                    CreateConnectionResult result = this.factoryDelegate.createConnectionDelegate(this.username, this.password, -1);
                    delegate = result.getDelegate();
                    MessagingXAResourceWrapper2 res = new MessagingXAResourceWrapper2(delegate, delegate.getServerID());
                    this.resources.add(res);
                }
                catch (Throwable e) {
                    log.error((Object)("Failed to create resource using factory " + this.factoryDelegate), e);
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to get connection factory.", (Throwable)e);
            }
        }
        this.iterator = this.resources.iterator();
        if (this.resources.isEmpty()) {
            this.factoryDelegate = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JBossConnectionFactory getConnectionFactory() throws Exception {
        JBossConnectionFactory jBossConnectionFactory;
        Context ctx;
        JMSProviderAdapter adapter;
        String connectionFactoryRef;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " look up CF via provider " + this.providerAdaptorName));
        }
        if ((connectionFactoryRef = (adapter = (JMSProviderAdapter)(ctx = new InitialContext()).lookup(this.providerAdaptorName)).getFactoryRef()) == null) {
            throw new IllegalStateException("Provider '" + this.providerAdaptorName + "' has no FactoryRef");
        }
        ctx = adapter.getInitialContext();
        try {
            JBossConnectionFactory factory;
            jBossConnectionFactory = factory = (JBossConnectionFactory)Util.lookup((Context)ctx, (String)connectionFactoryRef, JBossConnectionFactory.class);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        return jBossConnectionFactory;
    }
}

