/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.exception.MessagingXAException;
import org.jboss.jms.tx.LocalTx;
import org.jboss.jms.tx.MessagingXid;
import org.jboss.jms.tx.ResourceManager;
import org.jboss.logging.Logger;

public class MessagingXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(MessagingXAResource.class);
    private boolean trace = log.isTraceEnabled();
    private ResourceManager rm;
    private SessionState sessionState;
    private ConnectionDelegate connection;
    private boolean preventJoining;

    public MessagingXAResource(ResourceManager rm, SessionState sessionState) {
        this.rm = rm;
        this.sessionState = sessionState;
        this.connection = (ConnectionDelegate)((Object)sessionState.getParent().getDelegate());
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 600;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        boolean same;
        if (this.preventJoining) {
            return false;
        }
        if (!(xaResource instanceof MessagingXAResource)) {
            return false;
        }
        boolean bl = same = ((MessagingXAResource)xaResource).rm.getServerID() == this.rm.getServerID() && ((MessagingXAResource)xaResource).rm.getTransactions() == this.rm.getTransactions();
        if (this.trace) {
            log.trace((Object)("Calling isSameRM, result is " + same + " " + ((MessagingXAResource)xaResource).rm.getServerID() + " " + this.rm.getServerID()));
        }
        return same;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " starting " + xid + ", flags: " + flags));
        }
        if (!(xid instanceof MessagingXid)) {
            xid = new MessagingXid(xid);
        }
        boolean convertTx = false;
        Object currentXid = this.sessionState.getCurrentTxId();
        if (currentXid == null) {
            throw new MessagingXAException(-7, "Current xid is not set");
        }
        if (this.sessionState.getCurrentTxId() instanceof LocalTx) {
            convertTx = true;
            if (this.trace) {
                log.trace((Object)"Converting local tx into global tx branch");
            }
        }
        MessagingXAResource messagingXAResource = this;
        synchronized (messagingXAResource) {
            switch (flags) {
                case 0: {
                    if (convertTx) {
                        this.setCurrentTransactionId(this.rm.convertTx((LocalTx)this.sessionState.getCurrentTxId(), xid));
                        break;
                    }
                    this.setCurrentTransactionId(this.rm.startTx(xid));
                    break;
                }
                case 0x200000: {
                    if (convertTx) {
                        this.setCurrentTransactionId(this.rm.convertOnJoinTx((LocalTx)this.sessionState.getCurrentTxId(), xid));
                        break;
                    }
                    this.setCurrentTransactionId(this.rm.joinTx(xid));
                    break;
                }
                case 0x8000000: {
                    if (convertTx) {
                        this.setCurrentTransactionId(this.rm.convertOnJoinTx((LocalTx)this.sessionState.getCurrentTxId(), xid));
                        break;
                    }
                    this.setCurrentTransactionId(this.rm.resumeTx(xid));
                    break;
                }
                default: {
                    throw new MessagingXAException(-6, "Invalid flags: " + flags);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " ending " + xid + ", flags: " + flags));
        }
        if (!(xid instanceof MessagingXid)) {
            xid = new MessagingXid(xid);
        }
        MessagingXAResource messagingXAResource = this;
        synchronized (messagingXAResource) {
            this.unsetCurrentTransactionId(xid);
            switch (flags) {
                case 0x2000000: {
                    this.rm.suspendTx(xid);
                    break;
                }
                case 0x20000000: {
                    this.rm.endTx(xid, false);
                    break;
                }
                case 0x4000000: {
                    this.rm.endTx(xid, true);
                    break;
                }
                default: {
                    throw new MessagingXAException(-6, "Invalid flags: " + flags);
                }
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " preparing " + xid));
        }
        if (!(xid instanceof MessagingXid)) {
            xid = new MessagingXid(xid);
        }
        return this.rm.prepare(xid, this.connection);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " committing " + xid + (onePhase ? " (one phase)" : " (two phase)")));
        }
        if (!(xid instanceof MessagingXid)) {
            xid = new MessagingXid(xid);
        }
        this.rm.commit(xid, onePhase, this.connection);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " rolling back " + xid));
        }
        if (!(xid instanceof MessagingXid)) {
            xid = new MessagingXid(xid);
        }
        this.rm.rollback(xid, this.connection);
    }

    public void forget(Xid xid) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " forgetting " + xid + " (currently an NOOP)"));
        }
    }

    public Xid[] recover(int flags) throws XAException {
        if (this.trace) {
            log.trace((Object)(this + " recovering, flags: " + flags));
        }
        Xid[] xids = this.rm.recover(flags, this.connection);
        if (this.trace) {
            log.trace((Object)("Recovered txs: " + xids));
        }
        return xids;
    }

    public String toString() {
        return "MessagingXAResource[" + this.sessionState.getDelegate().getID() + "]";
    }

    public void setPreventJoining(boolean preventJoining) {
        this.preventJoining = preventJoining;
    }

    private void setCurrentTransactionId(Object xid) {
        if (this.trace) {
            log.trace((Object)(this + " setting current xid to " + xid + ",  previous " + this.sessionState.getCurrentTxId()));
        }
        this.sessionState.setCurrentTxId(xid);
    }

    private void unsetCurrentTransactionId(Object xid) {
        if (xid == null) {
            throw new IllegalArgumentException("xid must be not null");
        }
        if (this.trace) {
            log.trace((Object)(this + " unsetting current xid " + xid + ",  previous " + this.sessionState.getCurrentTxId()));
        }
        if (xid.equals(this.sessionState.getCurrentTxId())) {
            this.sessionState.setCurrentTxId(this.rm.createLocalTx());
        }
    }
}

