/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.delegate.ConnectionEndpoint;
import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class ConnectionCreateSessionDelegateRequest2
extends RequestSupport {
    private boolean transacted;
    private int acknowledgmentMode;
    private boolean xa;
    private boolean isCC;

    public ConnectionCreateSessionDelegateRequest2() {
    }

    public ConnectionCreateSessionDelegateRequest2(String objectId, byte version, boolean transacted, int ackMode, boolean xa, boolean isCC) {
        super(objectId, 208, version);
        this.transacted = transacted;
        this.acknowledgmentMode = ackMode;
        this.xa = xa;
        this.isCC = isCC;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.transacted = is.readBoolean();
        this.acknowledgmentMode = is.readInt();
        this.xa = is.readBoolean();
        this.isCC = is.readBoolean();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new ConnectionCreateSessionDelegateResponse((ClientSessionDelegate)endpoint.createSessionDelegate(this.transacted, this.acknowledgmentMode, this.xa, this.isCC));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeBoolean(this.transacted);
        os.writeInt(this.acknowledgmentMode);
        os.writeBoolean(this.xa);
        os.writeBoolean(this.isCC);
        os.flush();
    }
}

