#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
# Run configure, make and make install for each package
# $1    package directory
# $2    destination directory
# $@

# Include common code
. "$XB_BUILD_DIR/xb.functions.sh"

runmakefiles_exit_code=0
xb_runmakefiles()
{
    pd="$1"
    dd="$2"
    shift; shift
    if [ ".$1" != . ]; then
        pp=true
    else
        pp=false
    fi
    if [ ! -f "$pd/package.list" ]; then
        return 22
    fi
    if [ ! -d "$dd" ]; then
        return 22
    fi
    xbpathadd LD_RUN_PATH "$XB_BUILD_ROOT$XB_PACKAGE_BASE/$libd"
    xbpathadd LD_LIBRARY_PATH "$XB_BUILD_ROOT$XB_PACKAGE_BASE/$libd"

    # Export paths used for build library detection scripts
    export LD_RUN_PATH
    export LD_LIBRARY_PATH
    if [ ".$XB_BUILD_SYS" = ".macosx" ]; then
        xbpathadd DYLD_LIBRARY_PATH "$XB_BUILD_ROOT$XB_PACKAGE_BASE/$libd"
        export DYLD_LIBRARY_PATH
    fi
    sIFS=$IFS; IFS=$XB_LF
    lines=`$XB_GSED -e 's/^[[:blank:]]*//' \
                -e '/^[[:blank:]]*$/d' \
                -e '/^[#;].*/d' "$pd/package.list"`
    for l in $lines
    do
        IFS=$sIFS
        r=`echo $l | awk '{print $1}'`
        n=`echo $l | awk '{print $2}'`
        b=`echo $l | awk '{print $3}'`
        t=`echo $l | awk '{print $4}'`
        if $pp; then
            sp=true;
            for o
            do
                case "$o" in
                    +* )
                        rm -f "$dd/$n/skip.configure" >/dev/null 2>&1 || true
                        rm -f "$dd/$n/skip.makefiles" >/dev/null 2>&1 || true
                        o="`echo $o | sed 's/^+//'`"
                        ;;
                esac
                if [ "$o" = "$n" ]; then
                    sp=false
                    break
                fi
            done
            if $sp; then
                $XB_VERBOSE "Skiping package build : \`$n'"
                continue
            fi
        fi
        if $xb_build_force; then
            rm -f "$dd/$n/skip.configure" >/dev/null 2>&1 || true
            rm -f "$dd/$n/skip.makefiles" >/dev/null 2>&1 || true
        fi
        if $xb_build_clist; then
            cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"

Component: $n
EOR
            case "$r" in
                C)
                cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"
Rpm CVS branch: $b
Tag: $t
EOR
                ;;
                F)
                cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"
Fedora CVS branch: $b
Tag: $t
EOR
                ;;
                J)
                cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"
JBoss SVN branch: $b
Tag: $t
EOR
                ;;
                B)
                cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"
Brew build: $b-$t
EOR
                ;;
                R)
                cat << EOR >> "$XB_BUILD_ROOT$XB_PACKAGE_BASE/README"
Repository filename: $t
EOR
                ;;
            esac
        fi
        
        bsb_mode=$r
        xboverride "$dd/$n/xbs.configure" $bsb_mode
        runmakefiles_exit_code=$?
        if [ $runmakefiles_exit_code -ne 0 ]; then break ; fi
        touch "$dd/$n/skip.configure"

        xboverride "$dd/$n/xbs.makefile" $bsb_mode
        runmakefiles_exit_code=$?
        if [ $runmakefiles_exit_code -ne 0 ]; then break ; fi
    done
    return $runmakefiles_exit_code
}

xb_runmakefiles $@
exit $?

