/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.container;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.jms.JMSSecurityException;
import org.jboss.jms.server.SecurityStore;
import org.jboss.jms.server.security.CheckType;
import org.jboss.jms.server.security.SecurityMetadata;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityMetadata getSecurityMetadata(final SecurityStore sm, final boolean isQueue, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityMetadata>(){

            @Override
            public SecurityMetadata run() {
                return sm.getSecurityMetadata(isQueue, name);
            }
        });
    }

    static void authenticate(final SecurityStore sm, final String username, final String password) throws JMSSecurityException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    sm.authenticate(username, password);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new JMSSecurityException(pae.toString());
        }
    }

    public static boolean authorize(final SecurityStore sm, final String username, final Set principals, final CheckType checkType) throws JMSSecurityException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return sm.authorize(username, principals, checkType);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new JMSSecurityException(pae.toString());
        }
    }
}

