/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.exc.WstxLazyException;
import com.ctc.wstx.util.ExceptionUtil;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class FilteredEventReader
implements XMLEventReader,
XMLStreamConstants {
    final XMLEventReader mReader;
    final EventFilter mFilter;
    XMLEvent mNextEvent;

    public FilteredEventReader(XMLEventReader r, EventFilter f) {
        this.mReader = r;
        this.mFilter = f;
    }

    @Override
    public void close() throws XMLStreamException {
        this.mReader.close();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.mReader.getElementText();
    }

    @Override
    public Object getProperty(String name) {
        return this.mReader.getProperty(name);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.peek() != null;
        }
        catch (XMLStreamException sex) {
            WstxLazyException.throwLazily(sex);
            return false;
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent evt;
        while ((evt = this.mReader.nextEvent()) != null && !this.mFilter.accept(evt)) {
        }
        return evt;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException sex) {
            ExceptionUtil.throwRuntimeException(sex);
            return null;
        }
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent evt;
        while ((evt = this.mReader.nextTag()) != null && !this.mFilter.accept(evt)) {
        }
        return evt;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent evt;
        while ((evt = this.mReader.peek()) != null && !this.mFilter.accept(evt)) {
            this.mReader.nextEvent();
        }
        return evt;
    }

    @Override
    public void remove() {
        this.mReader.remove();
    }
}

