/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDocumentation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;

public class WSDLInterface
extends Extendable {
    private static final Logger log = Logger.getLogger(WSDLInterface.class);
    private static final long serialVersionUID = 2453454924501233964L;
    private WSDLDefinitions wsdlDefinitions;
    private QName name;
    private QName[] extendList;
    private String styleDefault;
    private Map<QName, WSDLInterfaceOperation> operations = new LinkedHashMap<QName, WSDLInterfaceOperation>();
    private Map<QName, WSDLInterfaceFault> faults = new LinkedHashMap<QName, WSDLInterfaceFault>();
    private WSDLDocumentation documentationElement;

    public WSDLInterface(WSDLDefinitions wsdlDefinitions, QName name) {
        this.wsdlDefinitions = wsdlDefinitions;
        this.name = name;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public QName getName() {
        return this.name;
    }

    public QName[] getExtendList() {
        return this.extendList;
    }

    public void setExtendList(QName[] extendList) {
        this.extendList = extendList;
    }

    public String getStyleDefault() {
        return this.styleDefault;
    }

    public void setStyleDefault(String styleDefault) {
        this.styleDefault = styleDefault;
    }

    public WSDLInterfaceOperation[] getOperations() {
        WSDLInterfaceOperation[] arr = new WSDLInterfaceOperation[this.operations.size()];
        new ArrayList<WSDLInterfaceOperation>(this.operations.values()).toArray(arr);
        return arr;
    }

    public WSDLInterfaceOperation[] getSortedOperations() {
        Object[] arr = new WSDLInterfaceOperation[this.operations.size()];
        new ArrayList<WSDLInterfaceOperation>(this.operations.values()).toArray(arr);
        Arrays.sort(arr);
        return arr;
    }

    public WSDLInterfaceOperation getOperation(QName name) {
        WSDLInterfaceOperation operation = this.operations.get(name);
        return operation;
    }

    public WSDLInterfaceOperation getOperation(String localName) {
        WSDLInterfaceOperation operation = this.operations.get(new QName(this.name.getNamespaceURI(), localName));
        return operation;
    }

    public void addOperation(WSDLInterfaceOperation operation) {
        this.operations.put(operation.getName(), operation);
    }

    public WSDLInterfaceFault[] getFaults() {
        WSDLInterfaceFault[] arr = new WSDLInterfaceFault[this.faults.size()];
        new ArrayList<WSDLInterfaceFault>(this.faults.values()).toArray(arr);
        return arr;
    }

    public WSDLInterfaceFault getFault(QName name) {
        WSDLInterfaceFault fault = this.faults.get(name);
        return fault;
    }

    public WSDLInterfaceFault getFault(String localName) {
        WSDLInterfaceFault fault = this.faults.get(new QName(this.name.getNamespaceURI(), localName));
        return fault;
    }

    public void addFault(WSDLInterfaceFault fault) {
        this.faults.put(fault.getName(), fault);
    }

    public WSDLDocumentation getDocumentationElement() {
        return this.documentationElement;
    }

    public void setDocumentationElement(WSDLDocumentation documentationElement) {
        this.documentationElement = documentationElement;
    }
}

