/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jboss.cache.util.concurrent.locks.LockContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerElementLockContainer<E>
implements LockContainer<E> {
    protected final ConcurrentMap<E, Lock> locks;

    protected PerElementLockContainer(int concurrencyLevel) {
        this.locks = new ConcurrentHashMap<E, Lock>(16, 0.75f, concurrencyLevel);
    }

    protected abstract Lock newLock();

    @Override
    public final Lock getLock(E object) {
        Lock tmp;
        Lock l = (Lock)this.locks.get(object);
        if (l == null) {
            l = this.newLock();
        }
        if ((tmp = this.locks.putIfAbsent(object, l)) != null) {
            l = tmp;
        }
        return l;
    }

    @Override
    public int getNumLocksHeld() {
        return this.locks.size();
    }

    @Override
    public void reset() {
        for (Lock l : this.locks.values()) {
            try {
                l.unlock();
            }
            catch (Exception exception) {}
        }
        this.locks.clear();
    }

    @Override
    public int size() {
        return this.locks.size();
    }

    @Override
    public void acquireLock(E object) {
        while (true) {
            Lock lock = this.getLock(object);
            lock.lock();
            Lock currentLock = this.locks.putIfAbsent(object, lock);
            if (currentLock == null || lock == currentLock) break;
            lock.unlock();
        }
    }

    @Override
    public boolean acquireLock(E object, long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock;
        while ((lock = this.getLock(object)).tryLock(timeout, unit)) {
            Lock currentLock = this.locks.putIfAbsent(object, lock);
            if (currentLock != null && lock != currentLock) {
                lock.unlock();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void releaseLock(E object) {
        Lock l = (Lock)this.locks.remove(object);
        if (l != null) {
            l.unlock();
        }
    }
}

