/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.model.DataVisitor;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.model.selection.ClientSelection;
import org.richfaces.model.selection.Selection;
import org.richfaces.model.selection.SimpleSelection;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.html.HTMLEncodingContributor;
import org.richfaces.renderkit.html.ScrollableDataTableRendererState;
import org.richfaces.renderkit.html.ScrollableDataTableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionRendererContributor
implements RendererContributor,
HTMLEncodingContributor {
    public static final String CLIENT_SELECTION = "clientSelection";

    public static final String getSelectionInputName(FacesContext context, UIScrollableDataTable grid) {
        String id = grid.getBaseClientId(context) + ":s";
        return id;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        final UIScrollableDataTable grid = (UIScrollableDataTable)component;
        if (grid.isSelectionEnabled()) {
            int shiftRowIndex;
            SimpleSelection simpleSelection;
            ExternalContext externalContext = context.getExternalContext();
            Map requestParamMap = externalContext.getRequestParameterMap();
            Application application = context.getApplication();
            String id = SelectionRendererContributor.getSelectionInputName(context, grid);
            String value = (String)requestParamMap.get(id);
            Converter converter = application.createConverter(ClientSelection.class);
            ClientSelection _oldClientSelection = (ClientSelection)grid.getAttributes().get(CLIENT_SELECTION);
            final ClientSelection oldClientSelection = _oldClientSelection == null ? new ClientSelection() : _oldClientSelection;
            final ClientSelection clientSelection = (ClientSelection)converter.getAsObject(context, (UIComponent)grid, value);
            final ScrollableDataTableRendererState state = ScrollableDataTableRendererState.createState(context, grid);
            int clientRowIndex = ScrollableDataTableUtils.getClientRowIndex(grid);
            state.setRowIndex(clientRowIndex);
            SimpleSelection simpleSelection2 = simpleSelection = grid.getSelection() == null ? new SimpleSelection() : (SimpleSelection)grid.getSelection();
            if (clientSelection.isReset() || clientSelection.isSelectAll()) {
                simpleSelection.clear();
                simpleSelection.setSelectAll(clientSelection.isSelectAll());
            }
            try {
                grid.walk(context, new DataVisitor(){

                    public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                        int i = state.getRowIndex();
                        if (SelectionRendererContributor.this.shouldAddToSelection(i, oldClientSelection, clientSelection)) {
                            simpleSelection.addKey(rowKey);
                        } else if (SelectionRendererContributor.this.shouldRemoveFromSelection(i, oldClientSelection, clientSelection)) {
                            simpleSelection.removeKey(rowKey);
                        }
                        if (i == clientSelection.getActiveRowIndex()) {
                            grid.setActiveRowKey(rowKey);
                        }
                        state.nextRow();
                    }
                }, state);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            int oldFirst = grid.getFirst();
            int oldRows = grid.getRows();
            int newFirst = -1;
            int newRows = -1;
            if ("u".equals(clientSelection.getSelectionFlag())) {
                newFirst = grid.getShiftRowIndex();
                newRows = oldFirst - newFirst;
            } else if ("d".equals(clientSelection.getSelectionFlag())) {
                newFirst = oldFirst + oldRows;
                newRows = grid.getShiftRowIndex() - newFirst + 1;
            }
            if (newFirst != -1) {
                grid.setFirst(newFirst);
                grid.setRows(newRows);
                try {
                    grid.walk(context, new DataVisitor(){

                        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                            simpleSelection.addKey(rowKey);
                        }
                    }, null);
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
                grid.setFirst(oldFirst);
                grid.setRows(oldRows);
            }
            grid.setSelection((Selection)simpleSelection);
            ValueExpression selectionBinding = grid.getValueExpression("selection");
            if (selectionBinding != null) {
                selectionBinding.setValue(context.getELContext(), (Object)simpleSelection);
            }
            if ((shiftRowIndex = clientSelection.getShiftRowIndex()) != -1) {
                int rows = grid.getRows();
                if (rows > 0) {
                    grid.setShiftRowIndex(grid.getFirst() + (rows + shiftRowIndex - clientRowIndex) % rows);
                } else {
                    grid.setShiftRowIndex(grid.getFirst() + shiftRowIndex - clientRowIndex);
                }
            }
            ScrollableDataTableRendererState.restoreState(context);
        }
    }

    public Class<?> getAcceptableClass() {
        return UIScrollableDataTable.class;
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public String[] getScriptDependencies() {
        return null;
    }

    public String[] getStyleDependencies() {
        return null;
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent component) {
        UIScrollableDataTable table = (UIScrollableDataTable)component;
        ScriptOptions scriptOptions = new ScriptOptions(component);
        if (table.isSelectionEnabled()) {
            scriptOptions.addOption("selectionInput", (Object)SelectionRendererContributor.getSelectionInputName(context, table));
            Map attributes = component.getAttributes();
            Object attribut = attributes.get("selectedClass");
            if (attribut == null) {
                attribut = "";
            }
            scriptOptions.addOption("selectedClass", attribut);
            attribut = attributes.get("activeClass");
            if (attribut == null) {
                attribut = "";
            }
            scriptOptions.addOption("activeClass", attribut);
            scriptOptions.addOption("selectionMode", (Object)table.getSelectionMode());
        }
        return scriptOptions;
    }

    @Override
    public void encode(FacesContext context, UIComponent component) throws IOException {
        UIScrollableDataTable grid = (UIScrollableDataTable)component;
        if (grid.isSelectionEnabled()) {
            this.encodeSelection(context, grid);
            this.writeSelection(context, grid);
        }
    }

    public boolean shouldAddToSelection(int i, ClientSelection oldSelection, ClientSelection newSelection) {
        return newSelection.isSelectAll() || newSelection.isSelected(i) && (!oldSelection.isSelected(i) || newSelection.isReset());
    }

    public boolean shouldRemoveFromSelection(int i, ClientSelection oldSelection, ClientSelection newSelection) {
        return !newSelection.isReset() && !newSelection.isSelectAll() && !newSelection.isSelected(i) && oldSelection.isSelected(i);
    }

    private void encodeSelection(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.createState(context, grid);
        state.setRowIndex(ScrollableDataTableUtils.getClientRowIndex(grid));
        SimpleSelection gridSelection = grid.getSelection() == null ? new SimpleSelection() : grid.getSelection();
        ClientSelection clientSelection = new ClientSelection();
        grid.walk(context, new DataVisitor((Selection)gridSelection, state, clientSelection, grid){
            final /* synthetic */ Selection val$gridSelection;
            final /* synthetic */ ScrollableDataTableRendererState val$state;
            final /* synthetic */ ClientSelection val$clientSelection;
            final /* synthetic */ UIScrollableDataTable val$grid;
            {
                this.val$gridSelection = selection;
                this.val$state = scrollableDataTableRendererState;
                this.val$clientSelection = clientSelection;
                this.val$grid = uIScrollableDataTable;
            }

            public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                if (this.val$gridSelection.isSelected(rowKey)) {
                    int i = this.val$state.getRowIndex();
                    this.val$clientSelection.addIndex(i);
                }
                if (rowKey.equals(this.val$grid.getActiveRowKey())) {
                    this.val$clientSelection.setActiveRowIndex(this.val$state.getRowIndex());
                }
                this.val$state.nextRow();
            }
        }, state);
        ScrollableDataTableRendererState.restoreState(context);
        grid.getAttributes().put(CLIENT_SELECTION, clientSelection);
    }

    public void writeSelection(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ClientSelection selection;
        Application application = context.getApplication();
        Converter converter = application.createConverter(ClientSelection.class);
        String string = converter.getAsString(context, (UIComponent)grid, (Object)(selection = (ClientSelection)grid.getAttributes().get(CLIENT_SELECTION)));
        if (string == null) {
            string = "";
        }
        int first = grid.getFirst();
        int rows = grid.getRows();
        int shiftRowIndex = grid.getShiftRowIndex();
        String shiftRow = "|.";
        if (shiftRowIndex > 0) {
            shiftRow = shiftRowIndex < first ? "|-" : (shiftRowIndex > first + rows ? "|+" : "|" + (rows + shiftRowIndex - first + ScrollableDataTableUtils.getClientRowIndex(grid)) % rows);
        }
        string = string + selection.getActiveRowIndex() + shiftRow;
        String id = SelectionRendererContributor.getSelectionInputName(context, grid);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)grid);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)string, null);
        writer.endElement("input");
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest()) {
            ajaxContext.addRenderedArea(id);
        }
    }
}

