/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.session;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.session.SessionSubTask;
import xjavadoc.XClass;
import xjavadoc.XMethod;

public class SessionTagsHandler
extends EjbTagsHandler {
    public static String getSessionClassFor(XClass clazz) {
        String fileName = clazz.getContainingPackage().getName();
        String sessionName = MessageFormat.format(SessionTagsHandler.getSessionClassPattern(), SessionTagsHandler.getShortEjbNameFor(clazz));
        if ((fileName = SessionTagsHandler.choosePackage(fileName, null, DocletTask.getSubTaskName(SessionSubTask.class))).length() > 0) {
            fileName = fileName + ".";
        }
        fileName = fileName + sessionName;
        return fileName;
    }

    public static boolean isSession(XClass clazz) {
        return clazz.isA("javax.ejb.SessionBean");
    }

    protected static String getSessionClassPattern() {
        SessionSubTask sessionSubtask = (SessionSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(SessionSubTask.class));
        if (sessionSubtask != null) {
            return sessionSubtask.getSessionClassPattern();
        }
        return "{0}Session";
    }

    public boolean isStatefulSession(XClass clazz) throws XDocletException {
        if (!SessionTagsHandler.isSession(clazz)) {
            return false;
        }
        String value = SessionTagsHandler.getCurrentClass().getDoc().getTagAttributeValue("ejb:bean", "type", false);
        return value != null && value.equals("Stateful");
    }

    public boolean isStatelessSession(XClass clazz) throws XDocletException {
        if (!SessionTagsHandler.isSession(clazz)) {
            return false;
        }
        String value = SessionTagsHandler.getCurrentClass().getDoc().getTagAttributeValue("ejb:bean", "type", false);
        if (value != null) {
            return value.equals("Stateless");
        }
        if (clazz.isA("javax.ejb.SessionSynchronization")) {
            return false;
        }
        List methods = clazz.getMethods();
        boolean hasEmptyCreateMethod = false;
        boolean hasOtherCreateMethods = false;
        for (XMethod method : methods) {
            if (method.getName().equals("ejbCreate") && method.getParameters().size() == 0) {
                hasEmptyCreateMethod = true;
                continue;
            }
            if (!method.getName().startsWith("ejbCreate") || method.getParameters().size() <= 0 || !method.getReturnType().getType().getQualifiedName().equals("void")) continue;
            hasOtherCreateMethods = true;
        }
        return hasEmptyCreateMethod && !hasOtherCreateMethods;
    }

    public String sessionClass() throws XDocletException {
        return SessionTagsHandler.getSessionClassFor(SessionTagsHandler.getCurrentClass());
    }

    public void ifStatelessSession(String template) throws XDocletException {
        if (this.isStatelessSession(SessionTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotStatelessSession(String template) throws XDocletException {
        if (!this.isStatelessSession(SessionTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifStatefulSession(String template) throws XDocletException {
        if (this.isStatefulSession(SessionTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotStatefulSession(String template) throws XDocletException {
        if (!this.isStatefulSession(SessionTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void forAllSessionBeans(String template) throws XDocletException {
        Collection classes = SessionTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            SessionTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)SessionTagsHandler.getCurrentClass()) || !this.hasHavingClassTag(SessionTagsHandler.getCurrentClass()) || !SessionTagsHandler.isSession(SessionTagsHandler.getCurrentClass())) continue;
            this.generate(template);
        }
    }

    public void forAllStatefulSessionBeans(String template) throws XDocletException {
        Collection classes = SessionTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            SessionTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)SessionTagsHandler.getCurrentClass()) || !this.hasHavingClassTag(SessionTagsHandler.getCurrentClass()) || !this.isStatefulSession(SessionTagsHandler.getCurrentClass())) continue;
            this.generate(template);
        }
    }

    public void forAllStatelessSessionBeans(String template) throws XDocletException {
        Collection classes = SessionTagsHandler.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            SessionTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)SessionTagsHandler.getCurrentClass()) || !this.hasHavingClassTag(SessionTagsHandler.getCurrentClass()) || !this.isStatelessSession(SessionTagsHandler.getCurrentClass())) continue;
            this.generate(template);
        }
    }
}

