/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class VerifySuspectTest
extends TestCase {
    IpAddress a1;
    IpAddress a2;
    Vector members;
    View v;
    Simulator s;

    public VerifySuspectTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.a2 = new IpAddress(2222);
        this.members = new Vector();
        this.members.add(this.a1);
        this.members.add(this.a2);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        VERIFY_SUSPECT v = new VERIFY_SUSPECT();
        Properties props = new Properties();
        props.setProperty("bind_addr", "127.0.0.1");
        props.setProperty("timeout", "100");
        v.setProperties(props);
        Protocol[] stack = new Protocol[]{v};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
    }

    public void testVerify() {
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        this.s.receive(new Event(9, this.a2));
        Util.sleep(50L);
        VerifySuspectTest.assertEquals((boolean)r.isSuspected(), (boolean)false);
        Util.sleep(100L);
        VerifySuspectTest.assertEquals((boolean)r.isSuspected(), (boolean)true);
    }

    public void testJGRP1382() {
        Receiver r = new Receiver();
        this.s.setReceiver(r);
        this.s.receive(new Event(9, this.a2));
        Util.sleep(50L);
        this.members.remove(this.a2);
        this.v = new View(this.a1, 2L, this.members);
        Event evt = new Event(6, this.v);
        this.s.send(evt);
        Util.sleep(100L);
        VerifySuspectTest.assertEquals((boolean)r.isSuspected(), (boolean)false);
    }

    public static Test suite() {
        return new TestSuite(VerifySuspectTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VerifySuspectTest.suite());
    }

    static class Receiver
    implements Simulator.Receiver {
        boolean suspected = false;

        Receiver() {
        }

        @Override
        public void receive(Event evt) {
            if (evt.getType() == 9) {
                this.suspected = true;
            }
        }

        boolean isSuspected() {
            return this.suspected;
        }
    }
}

