/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SQLFunction {
    private final Type type;
    private final boolean hasArguments;
    private final boolean hasParenthesesIfNoArgs;
    private final String template;
    private final String[] chunks;
    private final int[] paramIndexes;

    public SQLFunctionTemplate(Type type, String template) {
        this(type, template, true);
    }

    public SQLFunctionTemplate(Type type, String template, boolean hasParenthesesIfNoArgs) {
        int i;
        this.type = type;
        this.template = template;
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        StringBuffer chunk = new StringBuffer(10);
        StringBuffer index = new StringBuffer(2);
        for (i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '?') {
                chunkList.add(chunk.toString());
                chunk.delete(0, chunk.length());
                while (++i < template.length()) {
                    c = template.charAt(i);
                    if (Character.isDigit(c)) {
                        index.append(c);
                        continue;
                    }
                    chunk.append(c);
                    break;
                }
                paramList.add(Integer.valueOf(index.toString()) - 1);
                index.delete(0, index.length());
                continue;
            }
            chunk.append(c);
        }
        if (chunk.length() > 0) {
            chunkList.add(chunk.toString());
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.paramIndexes = new int[paramList.size()];
        for (i = 0; i < this.paramIndexes.length; ++i) {
            this.paramIndexes[i] = (Integer)paramList.get(i);
        }
        this.hasArguments = this.paramIndexes.length > 0;
        this.hasParenthesesIfNoArgs = hasParenthesesIfNoArgs;
    }

    @Override
    public String render(List args, SessionFactoryImplementor factory) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.chunks.length; ++i) {
            if (i < this.paramIndexes.length) {
                Object arg;
                Object v0 = arg = this.paramIndexes[i] < args.size() ? args.get(this.paramIndexes[i]) : null;
                if (arg == null) continue;
                buf.append(this.chunks[i]).append((Object)arg);
                continue;
            }
            buf.append(this.chunks[i]);
        }
        return buf.toString();
    }

    @Override
    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type;
    }

    @Override
    public boolean hasArguments() {
        return this.hasArguments;
    }

    @Override
    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.template;
    }
}

