/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioPipeSinkChannelImpl;
import org.jboss.xnio.nio.NioPipeSourceChannelImpl;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioOneWayPipeConnection
implements Closeable {
    private final NioPipeSourceChannelImpl sourceSide;
    private final NioPipeSinkChannelImpl sinkSide;

    NioOneWayPipeConnection(NioXnio nioXnio, final IoHandler<? super StreamSourceChannel> sourceHandler, final IoHandler<? super StreamSinkChannel> sinkHandler, Executor executor) throws IOException {
        MBean mbean;
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        source.configureBlocking(false);
        sink.configureBlocking(false);
        try {
            mbean = new MBean();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
        Closeable mbeanHandle = nioXnio.registerMBean(mbean);
        final NioPipeSourceChannelImpl sourceSide = new NioPipeSourceChannelImpl(source, sourceHandler, nioXnio, mbeanHandle);
        final NioPipeSinkChannelImpl sinkSide = new NioPipeSinkChannelImpl(sink, sinkHandler, nioXnio, mbean.bytes, mbean.messages, mbeanHandle);
        this.sourceSide = sourceSide;
        this.sinkSide = sinkSide;
        nioXnio.addManaged((Closeable)((Object)sourceSide));
        nioXnio.addManaged((Closeable)((Object)sinkSide));
        executor.execute(new Runnable(){

            public void run() {
                HandlerUtils.handleOpened(sourceHandler, sourceSide);
            }
        });
        executor.execute(new Runnable(){

            public void run() {
                HandlerUtils.handleOpened(sinkHandler, sinkSide);
            }
        });
    }

    public NioPipeSourceChannelImpl getSourceSide() {
        return this.sourceSide;
    }

    public NioPipeSinkChannelImpl getSinkSide() {
        return this.sinkSide;
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)((Object)this.sourceSide));
        IoUtils.safeClose((Closeable)((Object)this.sinkSide));
    }

    private final class MBean
    extends StandardMBean
    implements OneWayPipeConnectionMBean {
        private final AtomicLong bytes;
        private final AtomicLong messages;

        private MBean() throws NotCompliantMBeanException {
            super(OneWayPipeConnectionMBean.class);
            this.bytes = new AtomicLong();
            this.messages = new AtomicLong();
        }

        public long getBytesWritten() {
            return this.bytes.get();
        }

        public long getMessagesWritten() {
            return this.messages.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioOneWayPipeConnection.this);
        }
    }
}

