/*
 * Decompiled with CFR 0.152.
 */
package org.core4j.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.core4j.xml.XComment;
import org.core4j.xml.XContainer;
import org.core4j.xml.XDocumentType;
import org.core4j.xml.XElement;
import org.core4j.xml.XNode;
import org.core4j.xml.XProcessingInstruction;
import org.core4j.xml.XmlFormat;
import org.core4j.xml.XmlNodeType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XDocument
extends XContainer {
    private XElement documentElement;

    public XDocument(XElement documentElement) {
        this.documentElement = documentElement;
        this.add((Object)documentElement);
    }

    private XDocument(Document document) {
        for (Node childNode : XDocument.domNodes(document.getChildNodes())) {
            XNode xchild = XDocument.parseNode(childNode);
            if (xchild instanceof XElement) {
                this.documentElement = (XElement)xchild;
            }
            this.add((Object)xchild);
        }
    }

    @Override
    public String toString() {
        return this.toString(XmlFormat.NOT_INDENTED);
    }

    @Override
    public String toString(XmlFormat format) {
        StringBuilder sb = new StringBuilder();
        for (XNode node : this.nodes()) {
            if (node instanceof XProcessingInstruction || node instanceof XElement || node instanceof XComment || node instanceof XDocumentType) {
                sb.append(node.toString(format));
                continue;
            }
            throw new UnsupportedOperationException("implement " + node);
        }
        return sb.toString();
    }

    @Override
    protected XElement getXElement() {
        return this.documentElement;
    }

    public XElement getRoot() {
        return this.documentElement;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.DOCUMENT;
    }

    public static XDocument parse(String text) {
        return XDocument.load(new StringReader(text));
    }

    public static XDocument loadUtf8(InputStream inputStream) {
        try {
            return XDocument.load(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static XDocument load(Reader reader) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            return new XDocument(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

