/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAResult;
import org.odata4j.producer.jpa.JPAResults;

public class ExecuteJPQLQueryCommand
implements Command {
    private int maxResults;

    public ExecuteJPQLQueryCommand(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public boolean execute(JPAContext context) {
        context.setResult(this.getEntitiesResponse(context));
        return false;
    }

    private JPAResult getEntitiesResponse(JPAContext context) {
        EdmNavigationProperty edmNavProp;
        boolean hasMoreResults;
        String jpql = context.getJPQLQuery();
        Query tq = context.getEntityManager().createQuery(jpql);
        Integer inlineCount = context.getQueryInfo() != null && context.getQueryInfo().inlineCount == InlineCount.ALLPAGES ? Integer.valueOf(tq.getResultList().size()) : null;
        int queryMaxResults = this.maxResults;
        if (context.getQueryInfo() != null && context.getQueryInfo().top != null) {
            if (context.getQueryInfo().top.equals(0)) {
                List<Object> emptyList = Collections.emptyList();
                return JPAResults.entities(emptyList, inlineCount, false);
            }
            if (context.getQueryInfo().top < this.maxResults) {
                queryMaxResults = context.getQueryInfo().top;
            }
        }
        tq = tq.setMaxResults(queryMaxResults + 1);
        if (context.getQueryInfo() != null && context.getQueryInfo().skip != null) {
            tq = tq.setFirstResult(context.getQueryInfo().skip.intValue());
        }
        List results = tq.getResultList();
        if (context.getEdmPropertyBase() instanceof EdmProperty) {
            EdmProperty propInfo = (EdmProperty)context.getEdmPropertyBase();
            if (results.size() != 1) {
                throw new RuntimeException("Expected one and only one result for property, found " + results.size());
            }
            Object value = results.get(0);
            return JPAResults.property(propInfo.getName(), (EdmSimpleType)propInfo.getType(), value);
        }
        boolean bl = context.getQueryInfo() != null && context.getQueryInfo().top != null ? context.getQueryInfo().top > this.maxResults && results.size() > queryMaxResults : (hasMoreResults = results.size() > queryMaxResults);
        if (context.getEdmPropertyBase() instanceof EdmNavigationProperty && ((edmNavProp = (EdmNavigationProperty)context.getEdmPropertyBase()).getToRole().getMultiplicity() == EdmMultiplicity.ONE || edmNavProp.getToRole().getMultiplicity() == EdmMultiplicity.ZERO_TO_ONE)) {
            if (results.size() != 1) {
                throw new RuntimeException("Expected only one entity, found " + results.size());
            }
            return JPAResults.entity(results.get(0));
        }
        return JPAResults.entities(results.subList(0, Math.min(queryMaxResults, results.size())), inlineCount, hasMoreResults);
    }
}

