/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.Quoting;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierNode
implements ParseTreeNode {
    private final List<IdentifierSegment> segments;

    public IdentifierNode(IdentifierSegment ... segments) {
        if (segments.length < 1) {
            throw new IllegalArgumentException();
        }
        this.segments = UnmodifiableArrayList.asCopyOf(segments);
    }

    public IdentifierNode(List<IdentifierSegment> segments) {
        if (segments.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.segments = new UnmodifiableArrayList<IdentifierSegment>(segments.toArray(new IdentifierSegment[segments.size()]));
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public List<IdentifierSegment> getSegmentList() {
        return this.segments;
    }

    @Override
    public ParseRegion getRegion() {
        return IdentifierNode.sumSegmentRegions(this.segments);
    }

    static ParseRegion sumSegmentRegions(final List<? extends IdentifierSegment> segments) {
        return ParseRegion.sum((Iterable<ParseRegion>)new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                return ((IdentifierSegment)segments.get(index)).getRegion();
            }

            @Override
            public int size() {
                return segments.size();
            }
        });
    }

    public IdentifierNode append(IdentifierSegment segment) {
        ArrayList<IdentifierSegment> newSegments = new ArrayList<IdentifierSegment>(this.segments);
        newSegments.add(segment);
        return new IdentifierNode(newSegments);
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        writer.getPrintWriter().print(this);
    }

    public String toString() {
        return IdentifierNode.unparseIdentifierList(this.segments);
    }

    @Override
    public IdentifierNode deepCopy() {
        return this;
    }

    public static IdentifierNode parseIdentifier(String identifier) {
        return new IdentifierNode(IdentifierParser.parseIdentifier(identifier));
    }

    public static IdentifierNode ofNames(String ... names) {
        ArrayList<IdentifierSegment> list = new ArrayList<IdentifierSegment>();
        for (String name : names) {
            list.add(new NameSegment(null, name, Quoting.QUOTED));
        }
        return new IdentifierNode(list);
    }

    static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        IdentifierNode.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Olap4jUtil.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    static String unparseIdentifierList(List<? extends IdentifierSegment> segments) {
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < segments.size(); ++i) {
            IdentifierSegment segment = segments.get(i);
            if (i > 0) {
                buf.append('.');
            }
            segment.toString(buf);
        }
        return buf.toString();
    }
}

