package com.redhat.installer.postinstall;

import org.jboss.as.cli.CliInitializationException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.util.JBossJDBCConstants;
import com.redhat.installer.util.ServerCommandsHelper;

public class DatasourceScriptHelper {
    // ServerCommands to run the commands with
    private static ServerCommands serverCommands;
	private static AutomatedInstallData idata;
	private static AbstractUIProcessHandler mHandler;
	
	private static final String PROPERTIES = "properties";
	private static final String JNDI_NAME = "jndi-name";
    private static final String SCRIPT = "script";
    private static final String NAME = "ds-name";
    private static final String DOMAIN = "is-domain";
	//private static final String defaultProps [] = { "db.driver", "db.url", "db.user", "db.password", "db.jndi_name"};
	
	// general info
	private static String dsScript;
	private static String propertiesFile;
	private static ArgumentParser parser;
	private static boolean hasPropsFile;

	// new additions to allow property usage.
	private static String dsName;
	private static String dsJndiName;
	private static String dsDriver;
	private static String dsConnUrl;
	private static String dsUser;
	private static String dsPassword;
	private static boolean hasDsScript;
	
	/**
	 * This class runs the datasource helpers, for switching the SOA datasources to use the installed JDBC driver.
	 * It is unfortunate that we have to design this class like this
	 * @param handler
	 * @param args
	 * @throws Exception
	 */
	public static boolean run(AbstractUIProcessHandler handler, String[]args) throws Exception{
		idata = AutomatedInstallData.getInstance();
		mHandler = handler;
		parser = new ArgumentParser();
		parser.parse(args);
		
		init();
		
		ServerCommandsHelper.connectContext(handler, serverCommands, 0, 5);
		
		serverCommands.createNewBatch();
		
		if (hasPropsFile && hasDsScript){
			serverCommands.readPropertiesFile(propertiesFile);
		} 		
		
		if (dsScript != null){
			serverCommands.setResolveParameterValues(true);
			serverCommands.runCommandsInFile(dsScript);	
		} else {
			serverCommands.setResolveParameterValues(false);
			serverCommands.installDatasourceUserPwdMinimal(dsName, dsJndiName, dsDriver, dsConnUrl, dsUser, dsPassword);
		}
			
		if (serverCommands.runBatch() != 0){
			if (dsScript != null){
				//ProcessPanelHelper.printToPanel(mHandler, String.format("Datasource script %s failed.",dsScript), true);
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("DatasourceScriptHelper.failure"),dsScript), true);
			} else {
				//ProcessPanelHelper.printToPanel(mHandler, String.format("Adding datasource \"%s\" failed.",dsName), true);
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("DatasourceScriptHelper.noscript.failure"),dsName), true);
			}
			return false;
		} else {
			if (dsScript != null){
			    //ProcessPanelHelper.printToPanel(mHandler, String.format("Datasource script %s ran successfully.",dsScript), false);
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("DatasourceScriptHelper.success"),dsScript), false);
			} else {
                //ProcessPanelHelper.printToPanel(mHandler, String.format("Datasource %s added successfully.",dsName), false);
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("DatasourceScriptHelper.noscript.success"),dsName), false);
			}
		}
		serverCommands.terminateSession();
		return true;
	}
	
	private static void init(){
		hasPropsFile = parser.hasProperty(PROPERTIES);
		hasDsScript = parser.hasProperty(SCRIPT);
		
		if (hasPropsFile && hasDsScript){
			dsScript = parser.getProperty(SCRIPT);
			propertiesFile = parser.getProperty(PROPERTIES);
			completeProperties();
		} else {
			dsConnUrl = idata.getVariable("db.url");
			dsUser = idata.getVariable("db.user");
			dsPassword = idata.getVariable("db.password");
			dsDriver = idata.getVariable("db.driver");
			dsName = parser.getProperty(NAME);
			dsJndiName = parser.getProperty(JNDI_NAME);	
		}
		
		String username = idata.getVariable("postinstall.username");
		char[] password = idata.getVariable("postinstall.password").toCharArray();
		
		serverCommands = null;
		
		int port = ServerManager.getManagementPort();

		try {
			if (parser.hasProperty(DOMAIN)){
				serverCommands = ServerCommands.createLocalDomainUsernameSession(username,  password, port, new String[]{"default","full","full-ha","ha"});
			} else {
				serverCommands = ServerCommands.createLocalStandaloneUsernameSession(username, password, port);
			}
		} catch (CliInitializationException e){
			ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.init.error"), true);	
		}
	}

	/**
	 * Logic for completing the filename goes here. This is hopefully going to be a simple appending of the jdbc.driver.name value if it exists,
	 * otherwise h2. But adding this here is required because it may not be the case, and we have to do some mapping. Update: it is not the case in all cases. we need to have some mapping
	 *
	 * 
	 * TODO: we can make the ProcessPanel.xml.spec entry more clean by having a single param and appending <br/>
	 * a) -${jdbc.driver.name}.properties <br/>
	 * and 
	 * b) -ds.cli <br/>
	 * depending on the use case.
	 */
	private static void completeProperties() {
		if (!propertiesFile.endsWith("properties")) {
			String driverName = idata.getVariable("jdbc.driver.name");
			if (driverName != null) {
				if (driverName.equals(JBossJDBCConstants.ibmJdbcName)) {
					propertiesFile += "db2.properties";
				} else if (driverName.equals(JBossJDBCConstants.microsoftJdbcName)) {
					propertiesFile += "mssql.properties";
				} else if (driverName.equals(JBossJDBCConstants.sybaseJdbcName)) { // sybase
					propertiesFile += "h2.properties";
				} else {
					propertiesFile += driverName + ".properties";
				}
			} else {
				propertiesFile += "h2.properties";
			}
		}
	}
}
