package com.redhat.installer.postinstall;

import java.util.Random;

import org.jboss.as.cli.CliInitializationException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Vault relevant passwords for new SRAMP security requirements
 * 
 * @author thauser
 *
 */
public class VaultSRAMPPasswords {
	
	public static final String DOMAIN = "domain";
	
	public static void run (AbstractUIProcessHandler handler, String [] args){
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		ArgumentParser parser = new ArgumentParser();
		parser.parse(args);
		
		ServerCommands sc = null;
		
		String username = idata.getVariable("postinstall.username");
		char[] password = idata.getVariable("postinstall.password").toCharArray();
		int port = ServerManager.getManagementPort();
		
		try {
			sc = ServerCommands.createSession(username, password, port);
		} catch (CliInitializationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String vaultedSaml = sc.maskPasswordPlain("vault", "saml-keystore.password", idata.getVariable("saml.storepass"));
		String vaultedKeystore = sc.maskPasswordPlain("overlord", "overlord-alias.password", idata.getVariable("saml.storepass"));
		idata.setVariable("vaulted.saml-keystore.password", vaultedSaml);
		System.setProperty("vaulted.saml.keystore.password", "${"+vaultedSaml+"}");
		idata.setVariable("propsFile.vaulted.saml-keystore.password", "${vault:"+vaultedSaml+"}");
		idata.setVariable("vaulted.overlord-alias.password", vaultedKeystore);
		System.setProperty("vaulted.overlord.alias.password", "${"+vaultedKeystore+"}");
		idata.setVariable("propsFile.vaulted.overlord-alias.password", "${vault:"+vaultedKeystore+"}");
		
		// whatever?
		String basePwd = String.valueOf(System.currentTimeMillis());
		String workflowPwd = addRandomChars(basePwd);
		idata.setVariable("workflows.plaintext.password", workflowPwd);
        String vaultedWorkflowPwd = sc.maskPasswordPlain("dtgov","dtgov-workflows.password",workflowPwd);
		idata.setVariable("workflows.vaulted", "${vault:"+vaultedWorkflowPwd+"}");

        String rtgovcPassword = idata.getVariable("rtgov.password");

        if (rtgovcPassword != null){
            String vaultedRtgovcPassword = sc.maskPasswordPlain("rtgov","serverPassword",rtgovcPassword);
            idata.setVariable("vaulted.rtgov.password","${vault:"+vaultedRtgovcPassword+"}");
        }
	}
	
	private static String addRandomChars(String base){
		String finished = base;
		int numRands = 10;
		while (numRands > 0){
			Random rand = new Random();
			int frontOrBack = rand.nextInt(2)+1;
			// return a char code between 33 and 126, for any letter or symbol in ASCII
			char random;
            int randomChar = 0;
			do {
				randomChar = rand.nextInt((122 - 48) + 1) + 48;
			}while ((randomChar > 57 && randomChar < 65) || (randomChar > 90 && randomChar < 97) );

            char character[] = Character.toChars(randomChar);
            random = character[0];
			if (frontOrBack == 1){
				finished = random+finished;
			} else {
				finished+=random;
			}
			numRands--;
		}
		finished+="!1a"; // guarantee reqs are met
		return finished;
	}
}
