How to Use DBTool
=================

Building
--------
Running `mvn clean package` from the root directory of the project will build a jar with dependencies in the target folder, currently named `dbtool-1.0Alpha1-SNAPSHOT-jar-with-dependencies.jar`.

The tool is configured through a properties file. An example file can be found in the etc/ directory below the repository root directory.

Requirements
------------

The tool requires the following to run correctly.

* The home directory of the JBoss server to configure. The tool will look for the OS environment variable JBOSS_HOME if it has not been overidden by system property (see JVM args).
* The properties file with the tool's configuration parameters. DBTool will look for a file called `autorun.properties` in the same directory as the .jar file, again this can be overridden with a system property.
* The directory the JDBC driver of the new datasource is located. The tool will search for the driver in the same directory as the tool .jar file, this can also be overridden with a system property. 

Usage
-----

Usage: `java [jvm args] -jar dbtool.jar`

Possible JVM args:

`-Djboss.home.dir=`
Specify the directory of the jboss server to configure, if this is not set the tool will use environment var JBOSS_HOME, if neither is set the tool exits with an error message.

`-Ddbtool.autorun.file=`
Specifify the script to drive the tool, if not specifified the tool will looks for a file named autorun.properties in the same dir as the tool .jar, if this is not found the tool exits with an error message.

`-Ddbtool.db.driver.dir=`
The directory to look for the new datasource JDBC driver. If this is not set the tool looks in the same directory as the tool .jar and if it doesn't find it quits with an error message.

`-Ddbtool.log.file=`
File to output tool logging to, defaults to dbtool.log in the PWD if not specififed.

`-Ddbtool.log.level=`
The log level to output, possible values are TRACE, DEBUG, INFO, WARN, ERROR - defaults to INFO if not set.

How to Configure autorun.properties
-----------------------------------
By default, you can find example of autorun.properties with all values commented out and documented in ${dbtool-directory}/autorun.properties or you can view it [here](http://pastebin.test.redhat.com/182967).

Examples of Usage
-----------------

###Example #1###

Let's say you have the following environment and requirements:

 * your dbtool jar file is named dbtool.jar
 * you want to migrate to PostgreSQL and you have your JBoss server in /home/user/jboss-eap, which is different from JBOSS_HOME environment variable
 * postgresql driver is in the /opt/db-drivers directory
 * autorun.properties is in the same directory as dbtool.jar file
 * you want to log all logging messages into /tmp/dbtool/dbtool.log
 * you only want to log messages with log level WARN and higher
 * your JBoss server runs at localhost, management port is 9999, management credentials are: username: admin, password: test2@test
 * you want to configure the server in standalone mode
 * you want to configure all datasources
 * your database name is test, hostname is postgres.example.com, port is 5432, username is admin, password is test2@test
 * you want to create initial schema in the database

In this case, you create autorun.properties like this:
[http://pastebin.test.redhat.com/182968](http://pastebin.test.redhat.com/182968)
and you place it in the same directory where your dbtool.jar
Then, running the following command will initiate the migration:

    java -jar dbtool.jar \
        -Djboss.home.dir=/home/user/jboss-eap \
        -Ddbtool.db.driver.dir=/opt/db-drivers \
        -Ddbtool.log.file=/tmp/dbtool/dbtool.log \
        -Ddbtool.log.level=WARN

After some initial steps and creation of the database schema, you will be asked for FSW credentials to initiate S-RAMP seeding process. After that, the configuration should be completed successfully and you should see the following output:

    JBoss SOA Platform Database Configuration Tool
    ------------------------------------------------
    
    
    This tool is used to configure the SOA platform and all its
    constituent components against a new RDBMS.  Deployment scripts
    are currently available for the following databases:
      Oracle RAC,  Microsoft SQL Server,  PostgreSQL  
      Oracle,  IBM DB2,  MySQL  
    
    
    ** Warnings **
      This tool may not work correctly if you have made manual
      changes to the database configuration.
      This tool is only intended to do initial configuration.
      This tool only creates empty initial database tables, it does not migrate data.
      Databases marked (*) are not certified for new installations.
    
    
    Sucessfully backed up existing configuration
    Datasources will be updated to use: 'PostgreSQL'
    Found driver: postgresql-8.4-703.jdbc4.jar
    ----------------------
    Updating Datasources
    ----------------------
    Registering driver: Success
    Updating srampDS: Success
    Updating OverlordRTGov: Success
    Updating jbpmDS: Success
    Updating GadgetServer: Success
    Updating BpelDS: Success
    Exporting schema to: 'jdbc:postgresql://postgres.example.com:5432/test'
    Deploying S-RAMP config...Success
    Reloading server...
    Seeding S-RAMP...
    **********************************************************************
               _____       ______  ___ ___  ________  
              /  ___|      | ___ \/ _ \|  \/  | ___ \  
              \ `--. ______| |_/ / /_\ \ .  . | |_/ /  
               `--. \______|    /|  _  | |\/| |  __/  
              /\__/ /      | |\ \| | | | |  | | |  
              \____/       \_| \_\_| |_|_|  |_|_|  
                                                 
      JBoss S-RAMP Kurt Stam and Eric Wittmann, Licensed under the
      Apache License, V2.0, Copyright 2012
      Locale: en_US
    **********************************************************************
    S-RAMP Username: admin
    S-RAMP Password:
    Successfully connected to S-RAMP endpoint: http://localhost:8080/s-ramp-server
    Successfully uploaded a new ontology to the S-RAMP repository.
    **********************************************************************
    Successfully uploaded a new ontology to the S-RAMP repository.
    **********************************************************************
    S-RAMP shell shutting down...done.
    Seeding S-RAMP succeeded
    
    
    Installation complete.

###Example #2###

Let's say you have the following environment and requirements:

 * your dbtool jar file is named dbtool.jar
 * you want to migrate to Oracle and you have your JBoss server in JBOSS_HOME
 * postgresql driver is in the same directory as dbtool.jar
 * autorun.properties is in the same directory as dbtool.jar file
 * you want to log all logging messages into dbtool.log in the same directory where dbtool.jar is
 * you want to log messages with log level INFO and higher
 * your JBoss server runs at localhost, management port is 9999, management credentials are: username: admin, password: test2@test
 * you want to configure the server in domian mode and only profiles default and full
 * you want to configure only datasources for S-RAMP and BPEL
 * your database name is test, hostname is oracle.example.com, port is 1521, username is admin, password is test2@test
 * you don't want to create initial schema in the database (e.g. because it's already there)

In this case, your autorun.properties looks like this:
[http://pastebin.test.redhat.com/182979](http://pastebin.test.redhat.com/182979)

You run this command:

    java -jar dbtool.jar

And you get this output:

    JBoss SOA Platform Database Configuration Script
    ------------------------------------------------
    
    
    This tool is used to configure the SOA platform and all its
    constituent components against a new RDBMS.  Deployment scripts
    are currently available for the following databases:
      Oracle RAC,  Microsoft SQL Server,  PostgreSQL
      Oracle,  IBM DB2,  MySQL
    
    
    ** Warnings **
      This tool may not work correctly if you have made manual
      changes to the database configuration.
      This tool is only intended to do initial configuration.
      This tool only creates empty initial database tables, it does not migrate data.
      Databases marked (*) are not certified for new installations.
    
    
    Sucessfully backed up existing configuration
    Datasources will be updated to use: 'PostgreSQL'
    Found driver: postgresql-8.4-703.jdbc4.jar
    ----------------------
    Updating Datasources
    ----------------------
    
    
    Updating profile: default
        Registering driver: Success
        Updating srampDS: Success
        Updating BpelDS: Success
    
    
    Updating profile: full
        Registering driver: Success
        Updating srampDS: Success
        Updating BpelDS: Success
    
    
    Installation complete.

You don't have to supply your FSW credentials for S-RAMP seeding because if you set **create.db.schemas** to **no** than the seeding is not run.


































