/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.ClosedCorrelationKeyException;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.DefaultTimeoutMap;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.TimeoutMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor>,
Traceable {
    private static final Log LOG = LogFactory.getLog(AggregateProcessor.class);
    private final Lock lock = new ReentrantLock();
    private final CamelContext camelContext;
    private final Processor processor;
    private final AggregationStrategy aggregationStrategy;
    private final Expression correlationExpression;
    private final ExecutorService executorService;
    private ScheduledExecutorService recoverService;
    private TimeoutMap<String, String> timeoutMap;
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler(this.getClass());
    private AggregationRepository aggregationRepository = new MemoryAggregationRepository();
    private Map<Object, Object> closedCorrelationKeys;
    private Set<String> batchConsumerCorrelationKeys = new LinkedHashSet<String>();
    private final Set<String> inProgressCompleteExchanges = new HashSet<String>();
    private final Map<String, RedeliveryData> redeliveryState = new ConcurrentHashMap<String, RedeliveryData>();
    private Processor deadLetterProcessor;
    private boolean ignoreInvalidCorrelationKeys;
    private Integer closeCorrelationKeyOnCompletion;
    private boolean parallelProcessing;
    private boolean eagerCheckCompletion;
    private Predicate completionPredicate;
    private long completionTimeout;
    private Expression completionTimeoutExpression;
    private long completionInterval;
    private int completionSize;
    private Expression completionSizeExpression;
    private boolean completionFromBatchConsumer;
    private AtomicInteger batchConsumerCounter = new AtomicInteger();
    private boolean discardOnCompletionTimeout;

    public AggregateProcessor(CamelContext camelContext, Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, ExecutorService executorService) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(correlationExpression, "correlationExpression");
        ObjectHelper.notNull(aggregationStrategy, "aggregationStrategy");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.processor = processor;
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
    }

    public String toString() {
        return "AggregateProcessor[to: " + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "aggregate[" + this.correlationExpression + "]";
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        String key = this.correlationExpression.evaluate(exchange, String.class);
        if (ObjectHelper.isEmpty(key)) {
            if (this.isIgnoreInvalidCorrelationKeys()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invalid correlation key. This Exchange will be ignored: " + exchange));
                }
                return;
            }
            throw new CamelExchangeException("Invalid correlation key", exchange);
        }
        if (this.closedCorrelationKeys != null && this.closedCorrelationKeys.containsKey(key)) {
            throw new ClosedCorrelationKeyException(key, exchange);
        }
        this.lock.lock();
        try {
            this.doAggregation(key, exchange);
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private Exchange doAggregation(String key, Exchange exchange) throws CamelExchangeException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onAggregation +++ start +++ with correlation key: " + key));
        }
        Exchange oldExchange = this.aggregationRepository.get(exchange.getContext(), key);
        Exchange newExchange = exchange;
        Integer size = 1;
        if (oldExchange != null) {
            Integer n = size = oldExchange.getProperty("CamelAggregatedSize", 0, Integer.class);
            Integer n2 = size = Integer.valueOf(size + 1);
        }
        String complete = null;
        if (this.isEagerCheckCompletion()) {
            newExchange.setProperty("CamelAggregatedSize", size);
            complete = this.isCompleted(key, newExchange);
            newExchange.removeProperty("CamelAggregatedSize");
        }
        ExchangeHelper.prepareAggregation(oldExchange, newExchange);
        Exchange answer = this.onAggregation(oldExchange, exchange);
        if (answer == null) {
            throw new CamelExchangeException("AggregationStrategy " + this.aggregationStrategy + " returned null which is not allowed", exchange);
        }
        answer.setProperty("CamelAggregatedSize", size);
        if (!this.isEagerCheckCompletion()) {
            complete = this.isCompleted(key, answer);
        }
        if (complete == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("In progress aggregated exchange: " + answer + " with correlation key:" + key));
            }
            this.aggregationRepository.add(exchange.getContext(), key, answer);
        } else if ("consumer".equals(complete)) {
            for (String batchKey : this.batchConsumerCorrelationKeys) {
                Exchange batchAnswer = this.aggregationRepository.get(this.camelContext, batchKey);
                if (batchAnswer == null) {
                    batchAnswer = answer;
                }
                batchAnswer.setProperty("CamelAggregatedCompletedBy", complete);
                this.onCompletion(batchKey, batchAnswer, false);
            }
            this.batchConsumerCorrelationKeys.clear();
        } else {
            answer.setProperty("CamelAggregatedCompletedBy", complete);
            this.onCompletion(key, answer, false);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("onAggregation +++  end  +++ with correlation key: " + key));
        }
        return answer;
    }

    protected String isCompleted(String key, Exchange exchange) {
        Long value;
        int size;
        int size2;
        Integer value2;
        boolean answer;
        if (this.getCompletionPredicate() != null && (answer = this.getCompletionPredicate().matches(exchange))) {
            return "predicate";
        }
        if (this.getCompletionSizeExpression() != null && (value2 = this.getCompletionSizeExpression().evaluate(exchange, Integer.class)) != null && value2 > 0 && (size2 = exchange.getProperty("CamelAggregatedSize", 1, Integer.class).intValue()) >= value2) {
            return "size";
        }
        if (this.getCompletionSize() > 0 && (size = exchange.getProperty("CamelAggregatedSize", 1, Integer.class).intValue()) >= this.getCompletionSize()) {
            return "size";
        }
        boolean timeoutSet = false;
        if (this.getCompletionTimeoutExpression() != null && (value = this.getCompletionTimeoutExpression().evaluate(exchange, Long.class)) != null && value > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Updating correlation key " + key + " to timeout after " + value + " ms. as exchange received: " + exchange));
            }
            this.timeoutMap.put(key, exchange.getExchangeId(), value);
            timeoutSet = true;
        }
        if (!timeoutSet && this.getCompletionTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Updating correlation key " + key + " to timeout after " + this.getCompletionTimeout() + " ms. as exchange received: " + exchange));
            }
            this.timeoutMap.put(key, exchange.getExchangeId(), this.getCompletionTimeout());
        }
        if (this.isCompletionFromBatchConsumer()) {
            this.batchConsumerCorrelationKeys.add(key);
            this.batchConsumerCounter.incrementAndGet();
            size2 = exchange.getProperty("CamelBatchSize", 0, Integer.class);
            if (size2 > 0 && this.batchConsumerCounter.intValue() >= size2) {
                this.batchConsumerCounter.set(0);
                return "consumer";
            }
        }
        return null;
    }

    protected Exchange onAggregation(Exchange oldExchange, Exchange newExchange) {
        return this.aggregationStrategy.aggregate(oldExchange, newExchange);
    }

    protected void onCompletion(String key, Exchange exchange, boolean fromTimeout) {
        exchange.setProperty("CamelAggregatedCorrelationKey", key);
        this.aggregationRepository.remove(exchange.getContext(), key, exchange);
        if (!fromTimeout && this.timeoutMap != null) {
            this.timeoutMap.remove(key);
        }
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.put(key, key);
        }
        if (fromTimeout && this.isDiscardOnCompletionTimeout()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Aggregation for correlation key " + key + " discarding aggregated exchange: " + exchange));
            }
            this.aggregationRepository.confirm(exchange.getContext(), exchange.getExchangeId());
            this.redeliveryState.remove(exchange.getExchangeId());
        } else {
            this.onSubmitCompletion(key, exchange);
        }
    }

    private void onSubmitCompletion(Object key, final Exchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Aggregation complete for correlation key " + key + " sending aggregated exchange: " + exchange));
        }
        this.inProgressCompleteExchanges.add(exchange.getExchangeId());
        this.executorService.submit(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing aggregated exchange: " + exchange));
                }
                exchange.addOnCompletion(new AggregateOnCompletion(exchange.getExchangeId()));
                try {
                    AggregateProcessor.this.processor.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                if (exchange.getException() != null) {
                    AggregateProcessor.this.getExceptionHandler().handleException("Error processing aggregated exchange", exchange, exchange.getException());
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing aggregated exchange: " + exchange + " complete."));
                }
            }
        });
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public boolean isEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public Expression getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(Expression completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public int getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(int completionSize) {
        this.completionSize = completionSize;
    }

    public Expression getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(Expression completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    @Override
    protected void doStart() throws Exception {
        ScheduledExecutorService scheduler;
        RecoverableAggregationRepository recoverable;
        if (this.getCompletionTimeout() <= 0L && this.getCompletionInterval() <= 0L && this.getCompletionSize() <= 0 && this.getCompletionPredicate() == null && !this.isCompletionFromBatchConsumer() && this.getCompletionTimeoutExpression() == null && this.getCompletionSizeExpression() == null) {
            throw new IllegalStateException("At least one of the completions options [completionTimeout, completionInterval, completionSize, completionPredicate, completionFromBatchConsumer] must be set");
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            if (this.getCloseCorrelationKeyOnCompletion() > 0) {
                LOG.info((Object)("Using ClosedCorrelationKeys with a LRUCache with a capacity of " + this.getCloseCorrelationKeyOnCompletion()));
                this.closedCorrelationKeys = new LRUCache<Object, Object>(this.getCloseCorrelationKeyOnCompletion());
            } else {
                LOG.info((Object)"Using ClosedCorrelationKeys with unbounded capacity");
                this.closedCorrelationKeys = new HashMap<Object, Object>();
            }
        }
        ServiceHelper.startServices(this.processor, this.aggregationRepository);
        if (this.aggregationRepository instanceof RecoverableAggregationRepository && (recoverable = (RecoverableAggregationRepository)this.aggregationRepository).isUseRecovery()) {
            long interval = recoverable.getRecoveryIntervalInMillis();
            if (interval <= 0L) {
                throw new IllegalArgumentException("AggregationRepository has recovery enabled and the RecoveryInterval option must be a positive number, was: " + interval);
            }
            this.recoverService = this.camelContext.getExecutorServiceStrategy().newScheduledThreadPool(this, "AggregateRecoverChecker", 1);
            RecoverTask recoverTask = new RecoverTask(recoverable);
            LOG.info((Object)("Using RecoverableAggregationRepository by scheduling recover checker to run every " + interval + " millis."));
            this.recoverService.scheduleWithFixedDelay(recoverTask, 1000L, interval, TimeUnit.MILLISECONDS);
            if (recoverable.getDeadLetterUri() != null) {
                int max = recoverable.getMaximumRedeliveries();
                if (max <= 0) {
                    throw new IllegalArgumentException("Option maximumRedeliveries must be a positive number, was: " + max);
                }
                LOG.info((Object)("After " + max + " failed redelivery attempts Exchanges will be moved to deadLetterUri: " + recoverable.getDeadLetterUri()));
                Endpoint endpoint = this.camelContext.getEndpoint(recoverable.getDeadLetterUri());
                if (endpoint == null) {
                    throw new NoSuchEndpointException(recoverable.getDeadLetterUri());
                }
                this.deadLetterProcessor = new SendProcessor(endpoint, ExchangePattern.InOnly);
                ServiceHelper.startService(this.deadLetterProcessor);
            }
        }
        if (this.getCompletionInterval() > 0L && this.getCompletionTimeout() > 0L) {
            throw new IllegalArgumentException("Only one of completionInterval or completionTimeout can be used, not both.");
        }
        if (this.getCompletionInterval() > 0L) {
            LOG.info((Object)("Using CompletionInterval to run every " + this.getCompletionInterval() + " millis."));
            scheduler = this.camelContext.getExecutorServiceStrategy().newScheduledThreadPool(this, "AggregateTimeoutChecker", 1);
            scheduler.scheduleAtFixedRate(new AggregationIntervalTask(), 1000L, this.getCompletionInterval(), TimeUnit.MILLISECONDS);
        }
        if (this.getCompletionTimeout() > 0L || this.getCompletionTimeoutExpression() != null) {
            LOG.info((Object)("Using CompletionTimeout to trigger after " + this.getCompletionTimeout() + " millis of inactivity."));
            scheduler = this.camelContext.getExecutorServiceStrategy().newScheduledThreadPool(this, "AggregateTimeoutChecker", 1);
            this.timeoutMap = new AggregationTimeoutMap(scheduler, 1000L);
            ServiceHelper.startService(this.timeoutMap);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.recoverService != null) {
            this.camelContext.getExecutorServiceStrategy().shutdownNow(this.recoverService);
        }
        ServiceHelper.stopServices(this.timeoutMap, this.processor, this.deadLetterProcessor);
        if (this.closedCorrelationKeys != null) {
            ServiceHelper.stopService(this.closedCorrelationKeys);
            this.closedCorrelationKeys.clear();
        }
        this.batchConsumerCorrelationKeys.clear();
        this.redeliveryState.clear();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopService(this.aggregationRepository);
        this.inProgressCompleteExchanges.clear();
        super.doShutdown();
    }

    private final class RecoverTask
    implements Runnable {
        private final RecoverableAggregationRepository recoverable;

        private RecoverTask(RecoverableAggregationRepository recoverable) {
            this.recoverable = recoverable;
        }

        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recover check cannot start due CamelContext(" + AggregateProcessor.this.camelContext.getName() + ") has not been started yet"));
                }
                return;
            }
            LOG.trace((Object)"Starting recover check");
            Set<String> exchangeIds = this.recoverable.scan(AggregateProcessor.this.camelContext);
            for (String exchangeId : exchangeIds) {
                Exchange exchange;
                if (!AggregateProcessor.this.isRunAllowed()) {
                    LOG.info((Object)"We are shutting down so stop recovering");
                    return;
                }
                boolean inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
                if (inProgress) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Aggregated exchange with id: " + exchangeId + " is already in progress."));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading aggregated exchange with id: " + exchangeId + " to be recovered."));
                }
                if ((exchange = this.recoverable.recover(AggregateProcessor.this.camelContext, exchangeId)) == null) continue;
                String key = exchange.getProperty("CamelAggregatedCorrelationKey", String.class);
                exchange.getIn().setHeader("CamelRedelivered", Boolean.TRUE);
                RedeliveryData data = (RedeliveryData)AggregateProcessor.this.redeliveryState.get(exchange.getExchangeId());
                if (data != null && this.recoverable.getMaximumRedeliveries() > 0 && data.redeliveryCounter >= this.recoverable.getMaximumRedeliveries()) {
                    LOG.warn((Object)("The recovered exchange is exhausted after " + this.recoverable.getMaximumRedeliveries() + " attempts, will now be moved to dead letter channel: " + this.recoverable.getDeadLetterUri()));
                    try {
                        exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                        exchange.getIn().setHeader("CamelRedeliveryExhausted", Boolean.TRUE);
                        AggregateProcessor.this.deadLetterProcessor.process(exchange);
                    }
                    catch (Throwable e) {
                        exchange.setException(e);
                    }
                    if (exchange.getException() != null) {
                        AggregateProcessor.this.getExceptionHandler().handleException("Failed to move recovered Exchange to dead letter channel: " + this.recoverable.getDeadLetterUri(), exchange.getException());
                        continue;
                    }
                    this.recoverable.confirm(AggregateProcessor.this.camelContext, exchangeId);
                    continue;
                }
                if (data == null) {
                    data = new RedeliveryData();
                    AggregateProcessor.this.redeliveryState.put(exchange.getExchangeId(), data);
                }
                ++data.redeliveryCounter;
                exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Delivery attempt: " + data.redeliveryCounter + " to recover aggregated exchange with id: " + exchangeId + ""));
                }
                AggregateProcessor.this.onSubmitCompletion(key, exchange);
            }
            LOG.trace((Object)"Recover check complete");
        }
    }

    private final class AggregationIntervalTask
    implements Runnable {
        private AggregationIntervalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Completion interval task cannot start due CamelContext(" + AggregateProcessor.this.camelContext.getName() + ") has not been started yet"));
                }
                return;
            }
            LOG.trace((Object)"Starting completion interval task");
            Set<String> keys = AggregateProcessor.this.aggregationRepository.getKeys();
            if (keys != null && !keys.isEmpty()) {
                AggregateProcessor.this.lock.lock();
                try {
                    for (String key : keys) {
                        Exchange exchange = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
                        if (exchange == null) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Completion interval triggered for correlation key: " + key));
                        }
                        exchange.setProperty("CamelAggregatedCompletedBy", "interval");
                        AggregateProcessor.this.onCompletion(key, exchange, false);
                    }
                    Object var6_5 = null;
                    AggregateProcessor.this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    AggregateProcessor.this.lock.unlock();
                    throw throwable;
                }
            }
            LOG.trace((Object)"Completion interval task complete");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AggregationTimeoutMap
    extends DefaultTimeoutMap<String, String> {
        private AggregationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
            super(executor, requestMapPollTimeMillis, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purge() {
            AggregateProcessor.this.lock.lock();
            try {
                super.purge();
                Object var2_1 = null;
                AggregateProcessor.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AggregateProcessor.this.lock.unlock();
                throw throwable;
            }
        }

        @Override
        public boolean onEviction(String key, String exchangeId) {
            boolean inProgress;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Completion timeout triggered for correlation key: " + key));
            }
            if (inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Aggregated exchange with id: " + exchangeId + " is already in progress."));
                }
                return true;
            }
            Exchange answer = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
            if (answer != null) {
                answer.setProperty("CamelAggregatedCompletedBy", "timeout");
                AggregateProcessor.this.onCompletion(key, answer, true);
            }
            return true;
        }
    }

    private final class AggregateOnCompletion
    implements Synchronization {
        private final String exchangeId;

        private AggregateOnCompletion(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        public void onFailure(Exchange exchange) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Aggregated exchange onFailure: " + exchange));
            }
            AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(Exchange exchange) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Aggregated exchange onComplete: " + exchange));
            }
            try {
                AggregateProcessor.this.aggregationRepository.confirm(exchange.getContext(), this.exchangeId);
                AggregateProcessor.this.redeliveryState.remove(this.exchangeId);
                Object var3_2 = null;
                AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
                throw throwable;
            }
        }

        public String toString() {
            return "AggregateOnCompletion";
        }
    }

    private class RedeliveryData {
        int redeliveryCounter;
        long redeliveryDelay;

        private RedeliveryData() {
        }
    }
}

