/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.exceptionpolicy.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ErrorHandlerSupport
extends ServiceSupport
implements ErrorHandler {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private final Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies = new LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition>();
    private ExceptionPolicyStrategy exceptionPolicy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public void addExceptionPolicy(OnExceptionDefinition exceptionType) {
        Processor processor = exceptionType.getErrorHandler();
        this.addChildService(processor);
        List<Class> list = exceptionType.getExceptionClasses();
        for (Class clazz : list) {
            ExceptionPolicyKey key = new ExceptionPolicyKey(clazz, exceptionType.getOnWhen());
            this.exceptionPolicies.put(key, exceptionType);
        }
    }

    protected boolean customProcessorForException(Exchange exchange, Throwable exception) throws Exception {
        Processor processor;
        OnExceptionDefinition policy = this.getExceptionPolicy(exchange, exception);
        if (policy != null && (processor = policy.getErrorHandler()) != null) {
            processor.process(exchange);
            return true;
        }
        return false;
    }

    protected OnExceptionDefinition getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        return this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies, exchange, exception);
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    public static ExceptionPolicyStrategy createDefaultExceptionPolicyStrategy() {
        return new DefaultExceptionPolicyStrategy();
    }

    public abstract boolean supportTransacted();
}

