/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.karaf.test.quickstarts;

import org.junit.BeforeClass;
import org.junit.Test;

public class RulesInterviewContainerQuickstartTest extends AbstractQuickstartTest {
    private static String bundleName = "org.jboss.integration.fuse.quickstarts.switchyard.rules.interview.container";
    private static String featureName = "fuse-bxms-switchyard-quickstart-rules-interview-container";

    @BeforeClass
    public static void before() throws Exception {
        startTestContainer(featureName, bundleName);
    }

    @Test
    public void testVerifyPass() throws Exception {
        RulesInterviewQuickstartTest.doTestVerify("rules-interview-container", getSoapClientPort(), true);
    }

    @Test
    public void testVerifyFail() throws Exception {
        RulesInterviewQuickstartTest.doTestVerify("rules-interview-container", getSoapClientPort(), false);
    }

}
