/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertXToC;

public class ConvertUtf82Uc
extends ConvertXToC {
    public ConvertUtf82Uc(boolean bIgnoreErr) {
        super("4110".toCharArray(), bIgnoreErr);
    }

    protected int ConvertArrImpl(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int i = nInBeginIndex;
        int j = nOutBeginIndex;
        boolean bAbort = false;
        block5: while (i < nInEndIndex && j < nOutEndIndex) {
            int nCurPosSave = i;
            if (abIn[i] >= 0) {
                acOut[j++] = (char)abIn[i++];
                continue;
            }
            switch (abIn[i] & 0xF0) {
                case 192: 
                case 208: {
                    if (i + 2 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128) break;
                    acOut[j++] = (char)((abIn[i] & 0x1F) << 6 | abIn[i + 1] & 0x3F);
                    i += 2;
                    continue block5;
                }
                case 224: {
                    if (i + 3 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128 || (abIn[i + 2] & 0xC0) != 128) break;
                    acOut[j++] = (char)(((abIn[i] & 0xF) << 6 | abIn[i + 1] & 0x3F) << 6 | abIn[i + 2] & 0x3F);
                    i += 3;
                    continue block5;
                }
                case 240: {
                    if ((abIn[i] & 8) != 0) break;
                    if (i + 4 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128 || (abIn[i + 2] & 0xC0) != 128 || (abIn[i + 3] & 0xC0) != 128) break;
                    int nCurChar = (((abIn[i] & 7) << 6 | abIn[i + 1] & 0x3F) << 6 | abIn[i + 2] & 0x3F) << 6 | abIn[i + 3] & 0x3F;
                    i += 4;
                    if (nCurChar < 65536) {
                        acOut[j++] = (char)nCurChar;
                        continue block5;
                    }
                    if (nCurChar < 0x110000) {
                        if (j + 2 > nOutEndIndex) {
                            bAbort = true;
                            i -= 4;
                            break;
                        }
                        acOut[j++] = (char)((nCurChar -= 65536) >> 10 & 0x3FF | 0xD800);
                        acOut[j++] = (char)(nCurChar & 0x3FF | 0xDC00);
                        continue block5;
                    }
                    acOut[j++] = 35;
                    if (this.m_bIgnoreErr) continue block5;
                    ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2Utf8Arr", 2048, abIn, nInBeginIndex, nInEndIndex, nCurPosSave, acOut, nOutBeginIndex, j);
                    throw new ConvertArrException(oCnvErrInfo);
                }
            }
            if (bAbort) break;
            acOut[j++] = 35;
            ++i;
            if (this.m_bIgnoreErr) continue;
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2Utf8Arr", 2048, abIn, nInBeginIndex, nInEndIndex, nCurPosSave, acOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        if (i < nInEndIndex) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUtf82UcArr", 32, abIn, nInBeginIndex, nInEndIndex, i, acOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return j - nOutBeginIndex;
    }

    public int outLength(byte[] abIn, int nInBeginIndex, int nInEndIndex) {
        int i = nInBeginIndex;
        int j = 0;
        block5: while (i < nInEndIndex) {
            if (abIn[i] >= 0) {
                ++i;
                ++j;
                continue;
            }
            switch (abIn[i] & 0xF0) {
                case 192: 
                case 208: {
                    if (i + 2 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128) break;
                    i += 2;
                    ++j;
                    continue block5;
                }
                case 224: {
                    if (i + 3 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128 || (abIn[i + 2] & 0xC0) != 128) break;
                    i += 3;
                    ++j;
                    continue block5;
                }
                case 240: {
                    if ((abIn[i] & 8) != 0) break;
                    if (i + 4 > nInEndIndex) {
                        i = nInEndIndex - 1;
                        break;
                    }
                    if ((abIn[i + 1] & 0xC0) != 128 || (abIn[i + 2] & 0xC0) != 128 || (abIn[i + 3] & 0xC0) != 128) break;
                    int nCurChar = (((abIn[i] & 7) << 6 | abIn[i + 1] & 0x3F) << 6 | abIn[i + 2] & 0x3F) << 6 | abIn[i + 3] & 0x3F;
                    i += 4;
                    if (nCurChar < 65536) {
                        ++j;
                        continue block5;
                    }
                    if (nCurChar >= 0x110000) break;
                    j += 2;
                    continue block5;
                }
            }
            ++i;
            ++j;
        }
        return j;
    }

    protected boolean isShortcut() {
        return true;
    }
}

