/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MessageBuilder;
import com.sap.tc.logging.MessageDelimiterBuilder;
import com.sap.tc.logging.MsgType;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.Version;
import com.sap.tc.logging.interfaces.IMessageBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFormatter
extends Formatter {
    private static Location classLoc = Location.getLocation(ListFormatter.class.getName(), "tc~logging~java", "BC-JAS-ADM-LOG-API");
    private static final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy MM dd HH:mm:ss:SSS");
    static final String PATTERN = "yyyy MM dd HH:mm:ss:SSS";
    static int size = "yyyy MM dd HH:mm:ss:SSS".length();
    static final char DEL1 = ' ';
    static final char DEL2 = ':';
    static final char ZERO = '0';
    static final String EMPTY_STRING = "";
    private static final String DEAFULT_COMPATIBILE_VERSION = "2.0";
    private static final int INITIAL_CAPACITY = 512;
    private static final String DATE_STRING_PATTERN = "EEE MMM dd HH:mm:ss z yyyy";
    private static final int F_MIN = -1;
    private static final int F_VERSION = 0;
    private static final String F_NAME_VERSION = "LR_VERSION";
    private static final int F_DATE_TIME = 1;
    public static final String F_NAME_DATE_TIME = "LR_DATE";
    private static final int F_TIME_ZONE = 2;
    public static final String F_NAME_TIME_ZONE = "LR_TIME_ZONE";
    private static final int F_SEVERITY = 3;
    public static final String F_NAME_SEVERITY = "LR_SEVERITY";
    private static final int F_SOURCE_NAME = 4;
    public static final String F_NAME_SOURCE = "LR_SOURCE";
    private static final int F_MSG_CODE = 5;
    private static final String F_NAME_MSG_CODE = "LR_MSG_CODE";
    private static final int F_CSN_COMPONENT = 6;
    private static final String F_NAME_CSN_COMPONENT = "LR_MSG_CSN_COMPONENT";
    private static final int F_DC_NAME = 7;
    private static final String F_NAME_DC_NAME = "LR_MSG_DC_NAME";
    private static final int F_GUID = 8;
    private static final String F_NAME_GUID = "LR_ID";
    private static final int F_CORRELATION_ID = 9;
    private static final String F_NAME_CORRELATION_ID = "LR_CORRELATION_ID";
    private static final int F_APPLICATION_NAME = 10;
    public static final String F_NAME_APPLICATION = "LR_APPLICATION";
    private static final int F_LOCATION_NAME = 11;
    public static final String F_NAME_LOCATION = "LR_LOCATION";
    private static final int F_USER = 12;
    public static final String F_NAME_USER = "LR_USER";
    private static final int F_SESSION = 13;
    public static final String F_NAME_SESSION = "LR_SESSION";
    private static final int F_TRANSACTION = 14;
    public static final String F_NAME_TRANSACTION = "LR_TRANSACTION";
    private static final int F_DSR_ROOT_CONTEXT_ID = 15;
    public static final String F_NAME_DSR_ROOT_CONTEXT_ID = "LR_DSR_ROOT_CONTEXT_ID";
    private static final int F_DSR_TRANSACTION = 16;
    public static final String F_NAME_DSR_TRANSACTION = "LR_DSR_TRANSACTION";
    private static final int F_DSR_CONNECTION = 17;
    public static final String F_NAME_DSR_CONNECTION = "LR_DSR_CONNECTION";
    private static final int F_DSR_COUNTER = 18;
    public static final String F_NAME_DSR_COUNTER = "LR_DSR_CONNECTION";
    private static final int F_THREAD_NAME = 19;
    public static final String F_NAME_THREAD_NAME = "LR_THREAD_NAME";
    private static final int F_MSG_TYPE = 20;
    private static final String F_NAME_MSG_TYPE = "LR_MSG_TYPE";
    private static final int F_RES_BUNDLE = 21;
    private static final String F_NAME_RES_BOUNDLE = "LR_RESOURCE_BUNDLE";
    private static final int F_MSG_CLEAR = 22;
    public static final String F_NAME_MSG_CLEAR = "LR_MESSAGE";
    private static final int F_MSG_ARGS_CNT = 23;
    private static final String F_NAME_ARGS_CNT = "LR_MESSAGE ARGS COUNT";
    private static final int F_MSG_ARGS = 24;
    private static final String F_NAME_ARGS = "LR_ARGUMENTS";
    public static final String F_NAME_DSR_COMPONENT = null;
    public static final String F_NAME_DSR_USER = null;
    private static final String F_NAME_GROUP_ID = "LR_GROUP_ID";
    private static final String F_NAME_GROUP_LEVEL = "LR_GROUP_LEVEL";
    private static final String F_NAME_GROUP_INDENT = "LR_GROUP_IDENT";
    private static final String F_NAME_RELATIVES_CNT = "LR_RELATIVES_COUNT";
    private static final String F_NAME_RELATIVES = "LR_RELATIVES";
    private static final int F_MIN_15 = -1;
    private static final int F_VERSION_15 = 0;
    private static final int F_GUID_15 = 1;
    private static final int F_DATE_TIME_15 = 2;
    private static final int F_SOURCE_NAME_15 = 3;
    private static final int F_APPLICATION_NAME_15 = 4;
    private static final int F_LOCATION_NAME_15 = 5;
    private static final int F_USER_15 = 6;
    private static final int F_SESSION_15 = 7;
    private static final int F_TRANSACTION_15 = 8;
    private static final int F_DSR_COMPONENT_15 = 9;
    private static final int F_DSR_USER_15 = 10;
    private static final int F_DSR_TRANSACTION_15 = 11;
    private static final int F_THREAD_NAME_15 = 12;
    private static final int F_GROUP_ID_15 = 13;
    private static final int F_GROUP_LEVEL_15 = 14;
    private static final int F_GROUP_INDENT_15 = 15;
    private static final int F_SEVERITY_15 = 16;
    private static final int F_RELATIVES_CNT_15 = 17;
    private static final int F_RELATIVES_15 = 18;
    private static final int F_MSG_TYPE_15 = 19;
    private static final int F_MSG_CODE_15 = 20;
    private static final int F_RES_BUNDLE_15 = 21;
    private static final int F_MSG_CLEAR_15 = 22;
    private static final int F_MSG_ARGS_CNT_15 = 23;
    private static final int F_MSG_ARGS_15 = 24;
    private static final int F_MIN_No_FIELD_VALUES_15 = 10;
    private static final int F_MIN_No_DELIMITERS_20 = 24;
    private static final int F_MIN_No_DELIMITERS_15 = 23;
    private static final char DELIMITER_CHAR = '#';
    private static final char BACKSPACE = '\b';
    private static final char ESCAPE_CHAR = '\\';
    public static final String DELIMITER_STR = String.valueOf('#');
    private static final String ESCAPE_STR = String.valueOf('\\');
    private static final String ESCAPED_DELIMITER = ESCAPE_STR.concat(DELIMITER_STR);
    private static Map<String, Integer> columns = new HashMap<String, Integer>();

    public static Map<String, Integer> getFields() {
        switch (Version.getVersionIndex(Version.getVersionOfFirstRecord())) {
            case 15: {
                columns.put(F_NAME_VERSION, new Integer(0));
                columns.put(F_NAME_GUID, new Integer(1));
                columns.put(F_NAME_DATE_TIME, new Integer(2));
                columns.put(F_NAME_SOURCE, new Integer(3));
                columns.put(F_NAME_APPLICATION, new Integer(4));
                columns.put(F_NAME_LOCATION, new Integer(5));
                columns.put(F_NAME_USER, new Integer(6));
                columns.put(F_NAME_SESSION, new Integer(7));
                columns.put(F_NAME_TRANSACTION, new Integer(8));
                columns.put(F_NAME_DSR_COMPONENT, new Integer(9));
                columns.put(F_NAME_DSR_USER, new Integer(10));
                columns.put(F_NAME_DSR_TRANSACTION, new Integer(11));
                columns.put(F_NAME_THREAD_NAME, new Integer(12));
                columns.put(F_NAME_GROUP_ID, new Integer(13));
                columns.put(F_NAME_GROUP_LEVEL, new Integer(14));
                columns.put(F_NAME_GROUP_INDENT, new Integer(15));
                columns.put(F_NAME_SEVERITY, new Integer(16));
                columns.put(F_NAME_RELATIVES_CNT, new Integer(17));
                columns.put(F_NAME_RELATIVES, new Integer(18));
                columns.put(F_NAME_MSG_TYPE, new Integer(19));
                columns.put(F_NAME_MSG_CODE, new Integer(20));
                columns.put(F_NAME_RES_BOUNDLE, new Integer(21));
                columns.put(F_NAME_MSG_CLEAR, new Integer(22));
                columns.put(F_NAME_ARGS_CNT, new Integer(23));
                columns.put(F_NAME_ARGS, new Integer(24));
                break;
            }
            case 20: {
                columns.put(F_NAME_VERSION, new Integer(0));
                columns.put(F_NAME_DATE_TIME, new Integer(1));
                columns.put(F_NAME_TIME_ZONE, new Integer(2));
                columns.put(F_NAME_SEVERITY, new Integer(3));
                columns.put(F_NAME_SOURCE, new Integer(4));
                columns.put(F_NAME_MSG_CODE, new Integer(5));
                columns.put(F_NAME_CSN_COMPONENT, new Integer(6));
                columns.put(F_NAME_DC_NAME, new Integer(7));
                columns.put(F_NAME_GUID, new Integer(8));
                columns.put(F_NAME_CORRELATION_ID, new Integer(9));
                columns.put(F_NAME_APPLICATION, new Integer(10));
                columns.put(F_NAME_LOCATION, new Integer(11));
                columns.put(F_NAME_USER, new Integer(12));
                columns.put(F_NAME_SESSION, new Integer(13));
                columns.put(F_NAME_TRANSACTION, new Integer(14));
                columns.put(F_NAME_DSR_ROOT_CONTEXT_ID, new Integer(15));
                columns.put(F_NAME_DSR_TRANSACTION, new Integer(16));
                columns.put("LR_DSR_CONNECTION", new Integer(17));
                columns.put("LR_DSR_CONNECTION", new Integer(18));
                columns.put(F_NAME_THREAD_NAME, new Integer(19));
                columns.put(F_NAME_MSG_TYPE, new Integer(20));
                columns.put(F_NAME_RES_BOUNDLE, new Integer(21));
                columns.put(F_NAME_MSG_CLEAR, new Integer(22));
                columns.put(F_NAME_ARGS_CNT, new Integer(23));
                columns.put(F_NAME_ARGS, new Integer(24));
            }
        }
        return Collections.unmodifiableMap(columns);
    }

    @Override
    public IMessageBuilder getMessageBuilder() {
        MessageDelimiterBuilder msgDelimiter = null;
        switch (Version.getVersionIndex(Version.getVersionOfFirstRecord())) {
            case 20: {
                msgDelimiter = new MessageDelimiterBuilder(35, 24);
                msgDelimiter.addDynamicCounter(23, false);
                break;
            }
            case 15: {
                msgDelimiter = new MessageDelimiterBuilder(35, 23);
                msgDelimiter.addDynamicCounter(17, true);
                msgDelimiter.addDynamicCounter(22, false);
            }
            case 16: {
                break;
            }
        }
        return new MessageBuilder(this, msgDelimiter);
    }

    public static boolean compareField(int fieldIndex, int operater, String valueA, String valueB) {
        switch (fieldIndex) {
            case 0: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                return valueA.equalsIgnoreCase(valueB);
            }
            case 1: {
                try {
                    Date d1 = new Date(Long.parseLong(valueA));
                    Date d2 = new Date(Long.parseLong(valueB));
                    return HelperLib.compareTwoDates(operater, d1, d2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public String format(LogRecord rec) {
        String msgClear = rec.getMsgClear();
        StringBuilder res = new StringBuilder(512 + msgClear.length());
        res.append('#');
        res.append(this.getWorkingVersion());
        res.append('\b');
        res.append('#');
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(rec.getTime());
        res.append(this.formatDate(c));
        res.append('#');
        res.append(this.formatTimeZone(c));
        res.append('#');
        res.append(Severity.toString(rec.getSeverity()));
        res.append('#');
        this.escapeAndConcat(rec.getSourceName(), res);
        res.append('#');
        res.append(EOL);
        this.escapeAndConcat(rec.getMsgCode(), res);
        res.append('#');
        res.append(rec.getCsnComponent());
        res.append('#');
        res.append(rec.getDCName());
        res.append('#');
        res.append(rec.getId());
        res.append('#');
        if (rec.getCorrelatorID() != -1L) {
            res.append(rec.getCorrelatorID());
        }
        res.append('#');
        this.escapeAndConcat(rec.getApplication(), res);
        res.append('#');
        this.escapeAndConcat(rec.getLocationName(), res);
        res.append('#');
        this.escapeAndConcat(rec.getUser(), res);
        res.append('#');
        this.escapeAndConcat(rec.getSession(), res);
        res.append('#');
        this.escapeAndConcat(rec.getTransaction(), res);
        res.append('#');
        this.escapeAndConcat(rec.getDSRRootContextID(), res);
        res.append('#');
        this.escapeAndConcat(rec.getDSRTransactionID(), res);
        res.append('#');
        this.escapeAndConcat(rec.getDSRConnection(), res);
        res.append('#');
        if (rec.getDSRCounter() != -1) {
            res.append(rec.getDSRCounter());
        }
        res.append('#');
        this.escapeAndConcat(rec.getThreadName(), res);
        res.append('#');
        res.append(MsgType.toString(0));
        res.append('#');
        res.append(rec.getResourceBundleName());
        res.append('#');
        res.append(EOL);
        if (rec.getNonExceptionArgsCount() < rec.getArgObjs().size()) {
            msgClear = LogController.replaceException(rec, rec.getMsgClear());
            ArrayList<Object> reducedArgumentList = new ArrayList<Object>(rec.getArgObjs());
            reducedArgumentList.remove(rec.getArgsInt().length - 1);
            this.escapeAndConcat(LogController.replaceArguments(msgClear, reducedArgumentList.toArray()), res);
        } else {
            this.escapeAndConcat(LogController.replaceArguments(msgClear, rec.getArgsInt()), res);
        }
        res.append('#');
        res.append(EOL);
        res.append(EOL);
        return res.toString();
    }

    private String formatDate(Calendar c) {
        StringBuilder sb = new StringBuilder(size);
        sb.append(c.get(1));
        sb.append(' ');
        int i = c.get(2) + 1;
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(' ');
        i = c.get(5);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(' ');
        i = c.get(11);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(':');
        i = c.get(12);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(':');
        i = c.get(13);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        sb.append(':');
        i = c.get(14);
        if (i < 10) {
            sb.append('0');
        }
        if (i < 100) {
            sb.append('0');
        }
        sb.append(i);
        return sb.toString();
    }

    private String formatTimeZone(Calendar c) {
        int num;
        StringBuilder sb = new StringBuilder(5);
        int value = (c.get(15) + c.get(16)) / 60000;
        if (value >= 0) {
            sb.append('+');
        }
        sb.append((num = value / 60 * 100 + value % 60) < 1000 ? "0" + num : Integer.valueOf(num));
        return sb.toString();
    }

    @Override
    public LogRecord parseMsg(String completeMsgData) throws ParseException {
        StringTokenizer strTok = new StringTokenizer(completeMsgData, DELIMITER_STR, true);
        String nextTok = strTok.nextToken();
        if (nextTok.equals("1.2")) {
            return this.parseMsg12(strTok);
        }
        if (nextTok.equals(DELIMITER_STR)) {
            String ver = strTok.nextToken();
            if (ver.equals("1.5")) {
                if (strTok.countTokens() < 10) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", "ASJ.log_api.000048", "One or more message fields are missing! Expected number of fieds is {0} and message have {1}", new String[]{"23", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsgLatest(strTok);
            }
            if (ver.equals("1.4")) {
                if (strTok.countTokens() < 29) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", "ASJ.log_api.000049", "One or more message fields are missing! Expected number of fieds is {0} and message have {1}", new String[]{"29", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsg14(strTok);
            }
            if (ver.equals("1.3")) {
                if (strTok.countTokens() < 25) {
                    APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", "ASJ.log_api.000050", "One or more message fields are missing! Expected number of fieds is {0} and message have {1}", new String[]{"29", EMPTY_STRING + strTok.countTokens()});
                }
                return this.parseMsg13(strTok);
            }
        }
        APILogger.logIntByAPI(400, classLoc, "[parseMsg(String completeMsgData)]", "ASJ.log_api.000042", "One or more messages cannot be parsed!", null);
        return null;
    }

    @Override
    public LogRecord parseMsg(byte[] msgChunk) throws ParseException {
        switch (Version.getVersionIndex(Version.getVersionOfFirstRecord())) {
            case 15: {
                try {
                    return this.parseMsg15(msgChunk);
                }
                catch (Exception ex) {
                    break;
                }
            }
            case 20: {
                try {
                    return this.parseMsg20(msgChunk);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public LogRecord parseMsg(IMessageBuilder message) throws ParseException {
        switch (Version.getVersionIndex(Version.getVersionOfFirstRecord())) {
            case 15: {
                try {
                    return this.parseMsg15(message);
                }
                catch (Exception ex) {
                    break;
                }
            }
            case 20: {
                try {
                    return this.parseMsg20(message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public LogRecord parseMsg15(byte[] msgChunk) throws ParseException {
        if (msgChunk == null || msgChunk.length == 0) {
            return null;
        }
        int delimiterIndex = -1;
        int relativesCnt = 0;
        int relativesIndex = 0;
        int argsCnt = 0;
        int argsIndex = 0;
        int severity = 0;
        int msgType = 0;
        Date time = null;
        String recordId = null;
        String source = null;
        String loc = null;
        String application = null;
        String user = null;
        String session = null;
        String transaction = null;
        String dsrComponent = null;
        String dsrUser = null;
        String dsrTransaction = null;
        String thr = null;
        String msgCode = null;
        String msgAlias = null;
        String resourceBundleName = null;
        String msg = null;
        Object[] args = null;
        String[] relativesAsStrings = null;
        boolean isField = false;
        int length = 0;
        int fieldStartPos = 0;
        int fieldEndPos = 0;
        try {
            for (int i = 0; i < msgChunk.length; ++i) {
                if (msgChunk[i] == 35) {
                    if (i > 1 && msgChunk[i - 1] == 92) {
                        ++length;
                        continue;
                    }
                    if (fieldStartPos < 1) {
                        fieldStartPos = i + 1;
                        ++delimiterIndex;
                        continue;
                    }
                    fieldEndPos = --i;
                    isField = true;
                } else {
                    ++length;
                }
                if (!isField) continue;
                String nextToken = new String(msgChunk, fieldStartPos, length);
                switch (delimiterIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        recordId = nextToken;
                        break;
                    }
                    case 2: {
                        time = new Date(Long.parseLong(nextToken));
                        break;
                    }
                    case 3: {
                        source = this.revertEscape(nextToken);
                        break;
                    }
                    case 4: {
                        application = this.revertEscape(nextToken);
                        break;
                    }
                    case 5: {
                        loc = this.revertEscape(nextToken);
                        break;
                    }
                    case 6: {
                        user = this.revertEscape(nextToken);
                        break;
                    }
                    case 7: {
                        session = this.revertEscape(nextToken);
                        break;
                    }
                    case 8: {
                        transaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 9: {
                        dsrComponent = this.revertEscape(nextToken);
                        break;
                    }
                    case 10: {
                        dsrUser = this.revertEscape(nextToken);
                        break;
                    }
                    case 11: {
                        dsrTransaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 12: {
                        thr = this.revertEscape(nextToken);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 16: {
                        severity = Severity.parse(nextToken);
                        break;
                    }
                    case 17: {
                        if (nextToken.length() != 0) {
                            relativesCnt = Integer.parseInt(nextToken);
                            break;
                        }
                        ++delimiterIndex;
                        break;
                    }
                    case 18: {
                        if (relativesCnt <= 0) break;
                        if (relativesAsStrings == null) {
                            relativesAsStrings = new String[relativesCnt];
                        }
                        relativesAsStrings[relativesIndex] = new String(msgChunk, fieldStartPos, fieldEndPos - fieldStartPos + 1);
                        if (++relativesIndex >= relativesCnt) break;
                        --delimiterIndex;
                        break;
                    }
                    case 19: {
                        msgType = MsgType.parse(nextToken);
                        break;
                    }
                    case 20: {
                        int startPos = 0;
                        startPos = nextToken.indexOf("[");
                        if (startPos > 1) {
                            msgAlias = nextToken.substring(0, startPos);
                            msgCode = nextToken.substring(startPos + 1, nextToken.length() - 1);
                            break;
                        }
                        msgCode = nextToken;
                        break;
                    }
                    case 21: {
                        resourceBundleName = nextToken;
                        break;
                    }
                    case 22: {
                        msg = this.revertEscape(nextToken);
                        break;
                    }
                    case 23: {
                        if (msgType == 0 || nextToken.equals(EOL)) {
                            --delimiterIndex;
                            break;
                        }
                        if (nextToken.length() != 0) {
                            argsCnt = Integer.parseInt(nextToken);
                            args = new String[argsCnt];
                            break;
                        }
                        ++delimiterIndex;
                        break;
                    }
                    case 24: {
                        args[argsIndex] = this.revertEscape(nextToken);
                        if (argsIndex < argsCnt - 1) {
                            --delimiterIndex;
                        }
                        ++argsIndex;
                        break;
                    }
                    default: {
                        APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000043", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex, recordId});
                        i = msgChunk.length;
                    }
                }
                length = 0;
                fieldStartPos = 0;
                isField = false;
            }
            if (recordId != null) {
                return new LogRecord(recordId, "-1", msgChunk.length, time, null, source, severity, loc, relativesAsStrings, thr, msgType, msgCode, msgAlias, resourceBundleName, msg, args, application, user, session, transaction, dsrTransaction, dsrUser, dsrComponent, -1, this.getMessageAccessor(), null, null);
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000044", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex, recordId});
            APILogger.catchingIntByAPI(ex);
            throw new ParseException("Field " + delimiterIndex + " cannot be parsed! Record ID : " + recordId, delimiterIndex);
        }
        return null;
    }

    public LogRecord parseMsg15(IMessageBuilder message) throws ParseException {
        if (message == null || message.size() <= 0) {
            return null;
        }
        int currentIndex = 0;
        String recordId = null;
        try {
            currentIndex = 1;
            recordId = message.getFieldString(1);
            currentIndex = 2;
            Date time = new Date(Long.parseLong(message.getFieldString(2)));
            currentIndex = 3;
            String source = this.revertEscape(message.getFieldString(3));
            currentIndex = 4;
            String application = this.revertEscape(message.getFieldString(4));
            currentIndex = 5;
            String loc = this.revertEscape(message.getFieldString(5));
            currentIndex = 6;
            String user = this.revertEscape(message.getFieldString(6));
            currentIndex = 7;
            String session = this.revertEscape(message.getFieldString(7));
            currentIndex = 8;
            String transaction = this.revertEscape(message.getFieldString(8));
            currentIndex = 9;
            String dsrComponent = this.revertEscape(message.getFieldString(9));
            currentIndex = 10;
            String dsrUser = this.revertEscape(message.getFieldString(10));
            currentIndex = 11;
            String dsrTransaction = this.revertEscape(message.getFieldString(11));
            currentIndex = 12;
            String thr = this.revertEscape(message.getFieldString(12));
            currentIndex = 13;
            currentIndex = 14;
            currentIndex = 15;
            currentIndex = 16;
            int severity = Severity.parse(message.getFieldString(16));
            currentIndex = 17;
            int relativesCnt = message.getFieldInt(17);
            currentIndex = 18;
            String[] relativesAsStrings = null;
            if (relativesCnt > 0) {
                relativesAsStrings = new String[relativesCnt];
                int i = 0;
                for (i = 0; i < relativesCnt; ++i) {
                    relativesAsStrings[i] = message.getFieldString(18 + i);
                }
                relativesCnt = relativesCnt <= 1 ? 0 : --relativesCnt;
            } else {
                relativesCnt = -1;
            }
            currentIndex = 19;
            int msgType = MsgType.parse(message.getFieldString(19 + relativesCnt));
            currentIndex = 20;
            int startPos = 0;
            String msgCode = message.getFieldString(20 + relativesCnt);
            String msgAlias = null;
            startPos = msgCode.indexOf("[");
            if (startPos > 1) {
                msgAlias = msgCode.substring(0, startPos);
                msgCode = msgCode.substring(startPos + 1, msgCode.length() - 1);
            }
            currentIndex = 21;
            String resourceBundleName = message.getFieldString(21 + relativesCnt);
            currentIndex = 22;
            String msg = this.revertEscape(message.getFieldString(22 + relativesCnt));
            currentIndex = 23;
            int argsCnt = 0;
            argsCnt = msgType == 0 ? 0 : message.getFieldInt(23 + relativesCnt);
            currentIndex = 24;
            Object[] args = null;
            if (argsCnt > 0) {
                args = new String[argsCnt];
                for (int i = 0; i < argsCnt; ++i) {
                    args[i] = this.revertEscape(message.getFieldString(24 + relativesCnt + i));
                }
            }
            if (recordId != null) {
                return new LogRecord(recordId, "-1", message.size(), time, null, source, severity, loc, relativesAsStrings, thr, msgType, msgCode, msgAlias, resourceBundleName, msg, args, application, user, session, transaction, dsrTransaction, dsrUser, dsrComponent, -1, this.getMessageAccessor(), null, null);
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000045", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + currentIndex, recordId});
            APILogger.catchingIntByAPI(ex);
            throw new ParseException("Field " + currentIndex + " cannot be parsed! Record ID : " + recordId, currentIndex);
        }
        return null;
    }

    public LogRecord parseMsg20(byte[] msgChunk) throws ParseException {
        if (msgChunk == null || msgChunk.length == 0) {
            return null;
        }
        int delimiterIndex = -1;
        int argsCnt = 0;
        int argsIndex = 0;
        int severity = 0;
        int msgType = 0;
        Date time = null;
        String timeZone = null;
        String recordId = null;
        String corrID = null;
        String source = null;
        String loc = null;
        String application = null;
        String user = null;
        String session = null;
        String transaction = null;
        String dsrRootContextId = null;
        String dsrTransaction = null;
        String dsrConnection = null;
        int dsrCounter = 0;
        String thr = null;
        String msgCode = null;
        String msgAlias = null;
        String resourceBundleName = null;
        String msg = null;
        Object[] args = null;
        String[] relativesAsStrings = null;
        String csnComponent = null;
        String dcName = null;
        boolean isField = false;
        int length = 0;
        int fieldStartPos = 0;
        try {
            for (int i = 0; i < msgChunk.length; ++i) {
                if (msgChunk[i] == 35) {
                    if (i > 1 && msgChunk[i - 1] == 92) {
                        ++length;
                        continue;
                    }
                    if (fieldStartPos < 1) {
                        fieldStartPos = i + 1;
                        ++delimiterIndex;
                        continue;
                    }
                    --i;
                    isField = true;
                } else {
                    ++length;
                }
                if (!isField) continue;
                String nextToken = new String(msgChunk, fieldStartPos, length);
                switch (delimiterIndex) {
                    case 0: {
                        break;
                    }
                    case 8: {
                        recordId = nextToken;
                        break;
                    }
                    case 9: {
                        corrID = nextToken;
                        break;
                    }
                    case 1: {
                        time = dateTimeFormatter.parse(nextToken);
                        break;
                    }
                    case 2: {
                        timeZone = nextToken;
                        break;
                    }
                    case 10: {
                        application = this.revertEscape(nextToken);
                        break;
                    }
                    case 11: {
                        loc = this.revertEscape(nextToken);
                        break;
                    }
                    case 12: {
                        user = this.revertEscape(nextToken);
                        break;
                    }
                    case 13: {
                        session = this.revertEscape(nextToken);
                        break;
                    }
                    case 14: {
                        transaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 15: {
                        dsrRootContextId = this.revertEscape(nextToken);
                        break;
                    }
                    case 16: {
                        dsrTransaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 17: {
                        dsrConnection = this.revertEscape(nextToken);
                        break;
                    }
                    case 18: {
                        dsrCounter = Integer.parseInt(nextToken);
                        break;
                    }
                    case 19: {
                        thr = this.revertEscape(nextToken);
                        break;
                    }
                    case 3: {
                        severity = Severity.parse(nextToken);
                        break;
                    }
                    case 5: {
                        msgCode = nextToken;
                        break;
                    }
                    case 4: {
                        source = nextToken;
                        break;
                    }
                    case 6: {
                        csnComponent = nextToken;
                        break;
                    }
                    case 7: {
                        dcName = nextToken;
                        break;
                    }
                    case 21: {
                        resourceBundleName = nextToken;
                        break;
                    }
                    case 22: {
                        msg = this.revertEscape(nextToken);
                        break;
                    }
                    case 23: {
                        if (msgType == 0 || nextToken.equals(EOL)) {
                            --delimiterIndex;
                            break;
                        }
                        if (nextToken.length() != 0) {
                            argsCnt = Integer.parseInt(nextToken);
                            args = new String[argsCnt];
                            break;
                        }
                        ++delimiterIndex;
                        break;
                    }
                    case 24: {
                        args[argsIndex] = this.revertEscape(nextToken);
                        if (argsIndex < argsCnt - 1) {
                            --delimiterIndex;
                        }
                        ++argsIndex;
                        break;
                    }
                    default: {
                        APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000046", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex, recordId});
                        i = msgChunk.length;
                    }
                }
                length = 0;
                fieldStartPos = 0;
                isField = false;
            }
            if (recordId != null) {
                return new LogRecord(recordId, corrID, msgChunk.length, time, timeZone, source, severity, loc, relativesAsStrings, thr, msgType, msgCode, msgAlias, resourceBundleName, msg, args, application, user, session, transaction, dsrTransaction, dsrRootContextId, dsrConnection, dsrCounter, this.getMessageAccessor(), csnComponent, dcName);
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000047", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex, recordId});
            APILogger.catchingIntByAPI(ex);
            throw new ParseException("Field " + delimiterIndex + " cannot be parsed! Record ID : " + recordId, delimiterIndex);
        }
        return null;
    }

    public LogRecord parseMsg20(IMessageBuilder message) throws ParseException {
        if (message == null || message.size() <= 0) {
            return null;
        }
        int currentIndex = 0;
        String recordID = null;
        try {
            currentIndex = 1;
            Date time = dateTimeFormatter.parse(message.getFieldString(1));
            currentIndex = 2;
            String timeZone = message.getFieldString(2);
            currentIndex = 3;
            int severity = Severity.parse(message.getFieldString(3));
            currentIndex = 4;
            String source = this.revertEscape(message.getFieldString(4));
            currentIndex = 5;
            String msgCode = message.getFieldString(5).trim();
            currentIndex = 6;
            String csnComponent = message.getFieldString(6);
            currentIndex = 7;
            String dcName = message.getFieldString(7);
            currentIndex = 8;
            recordID = message.getFieldString(8);
            currentIndex = 9;
            String correlationID = message.getFieldString(9);
            currentIndex = 10;
            String application = this.revertEscape(message.getFieldString(10));
            currentIndex = 11;
            String loc = this.revertEscape(message.getFieldString(11));
            currentIndex = 12;
            String user = this.revertEscape(message.getFieldString(12));
            currentIndex = 13;
            String session = this.revertEscape(message.getFieldString(13));
            currentIndex = 14;
            String transaction = this.revertEscape(message.getFieldString(14));
            currentIndex = 15;
            String dsrRootContextID = this.revertEscape(message.getFieldString(15));
            currentIndex = 16;
            String dsrTransaction = this.revertEscape(message.getFieldString(16));
            currentIndex = 17;
            String dsrConnection = this.revertEscape(message.getFieldString(17));
            currentIndex = 18;
            int dsrCounter = message.getFieldInt(18);
            currentIndex = 19;
            String thr = this.revertEscape(message.getFieldString(19));
            currentIndex = 20;
            int msgType = MsgType.parse(message.getFieldString(20));
            currentIndex = 21;
            String resourceBundleName = message.getFieldString(21);
            currentIndex = 22;
            String msg = this.revertEscape(this.removeFirstEOL(message.getFieldString(22)));
            currentIndex = 23;
            int argsCnt = 0;
            argsCnt = msgType == 0 ? 0 : message.getFieldInt(23);
            currentIndex = 24;
            Object[] args = null;
            if (argsCnt > 0) {
                args = new String[argsCnt];
                for (int i = 0; i < argsCnt; ++i) {
                    args[i] = this.revertEscape(message.getFieldString(24 + i));
                }
            }
            if (recordID != null) {
                return new LogRecord(recordID, correlationID, message.size(), time, timeZone, source, severity, loc, null, thr, msgType, msgCode, null, resourceBundleName, msg, args, application, user, session, transaction, dsrTransaction, dsrRootContextID, dsrConnection, dsrCounter, this.getMessageAccessor(), csnComponent, dcName);
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000055", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + currentIndex, recordID});
            APILogger.catchingIntByAPI(ex);
            throw new ParseException("Field " + currentIndex + " cannot be parsed! Record ID : " + recordID, currentIndex);
        }
        return null;
    }

    protected void escapeAndConcat(CharSequence s, StringBuilder sb) {
        if (s == null) {
            return;
        }
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': {
                    sb.append(ESCAPED_DELIMITER);
                    continue block5;
                }
                case '\b': {
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private String getWorkingVersion() {
        return DEAFULT_COMPATIBILE_VERSION;
    }

    private LogRecord parseMsgLatest(StringTokenizer _strTok) {
        int delimiterIndex = 0;
        int severity = 0;
        int msgType = 0;
        Date time = null;
        String timeZone = null;
        String msgId = null;
        String corrID = null;
        String source = null;
        String loc = null;
        String application = null;
        String user = null;
        String session = null;
        String transaction = null;
        String dsrRootContextId = null;
        String dsrTransaction = null;
        String dsrConnection = null;
        int dsrCounter = 0;
        String thr = null;
        String msgCode = null;
        String msgAlias = null;
        String resourceBundleName = null;
        String msg = null;
        Object[] args = null;
        String[] relativesAsStrings = null;
        String csnComponent = null;
        String dcName = null;
        LFStringTokenizer stringTokenizer = new LFStringTokenizer(_strTok);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String nextToken = stringTokenizer.getNextTokenResolved();
                if (nextToken.equals(DELIMITER_STR)) {
                    ++delimiterIndex;
                    continue;
                }
                switch (delimiterIndex) {
                    case 0: {
                        break;
                    }
                    case 8: {
                        msgId = nextToken;
                        break;
                    }
                    case 9: {
                        corrID = nextToken;
                        break;
                    }
                    case 1: {
                        time = new Date(Long.parseLong(nextToken));
                        break;
                    }
                    case 2: {
                        timeZone = nextToken;
                        break;
                    }
                    case 10: {
                        application = this.revertEscape(nextToken);
                        break;
                    }
                    case 11: {
                        loc = this.revertEscape(nextToken);
                        break;
                    }
                    case 12: {
                        user = this.revertEscape(nextToken);
                        break;
                    }
                    case 13: {
                        session = this.revertEscape(nextToken);
                        break;
                    }
                    case 14: {
                        transaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 15: {
                        dsrRootContextId = this.revertEscape(nextToken);
                        break;
                    }
                    case 16: {
                        dsrTransaction = this.revertEscape(nextToken);
                        break;
                    }
                    case 17: {
                        dsrConnection = this.revertEscape(nextToken);
                        break;
                    }
                    case 18: {
                        dsrCounter = Integer.parseInt(nextToken);
                        break;
                    }
                    case 19: {
                        thr = this.revertEscape(nextToken);
                        break;
                    }
                    case 3: {
                        severity = Severity.parse(nextToken);
                        break;
                    }
                    case 6: {
                        csnComponent = nextToken;
                        break;
                    }
                    case 7: {
                        dcName = nextToken;
                        break;
                    }
                    case 20: {
                        msgType = MsgType.parse(nextToken);
                        break;
                    }
                    case 5: {
                        int startPos = 0;
                        startPos = nextToken.indexOf("[");
                        if (startPos > 1) {
                            msgAlias = nextToken.substring(0, startPos);
                            msgCode = nextToken.substring(startPos + 1, nextToken.length() - 1);
                            break;
                        }
                        msgCode = nextToken;
                        break;
                    }
                    case 21: {
                        resourceBundleName = nextToken;
                        break;
                    }
                    case 22: {
                        msg = this.revertEscape(nextToken);
                        break;
                    }
                    case 23: 
                    case 24: {
                        if (msgType == 0 || nextToken.equals(EOL)) break;
                        args = this.populateRelativesAndMessageArgs(stringTokenizer, nextToken);
                        if (!stringTokenizer.isNextDelimiterConsumed()) break;
                        ++delimiterIndex;
                        break;
                    }
                    default: {
                        APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000056", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex});
                    }
                }
                if (!stringTokenizer.isNextDelimiterConsumed()) continue;
                ++delimiterIndex;
            }
            return new LogRecord(msgId, corrID, 0, time, timeZone, source, severity, loc, relativesAsStrings, thr, msgType, msgCode, msgAlias, resourceBundleName, msg, args, application, user, session, transaction, dsrTransaction, dsrRootContextId, dsrConnection, dsrCounter, this.getMessageAccessor(), csnComponent, dcName);
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[parseMsgLatest(StringTokenizer _strTok)]", "ASJ.log_api.000057", "Field {0} cannot be parsed! Message ID : {1}", new String[]{EMPTY_STRING + delimiterIndex});
            APILogger.catchingIntByAPI(ex);
            return null;
        }
    }

    private String[] populateRelativesAndMessageArgs(LFStringTokenizer strTok, String nextTok) {
        int numRel = Integer.parseInt(nextTok);
        String[] destination = new String[numRel];
        if (!strTok.isNextDelimiterConsumed()) {
            strTok.getNextTokenResolved();
        }
        for (int i = 0; i < numRel; ++i) {
            String temp = strTok.getNextTokenResolved();
            if (DELIMITER_STR.equals(temp)) {
                destination[i] = EMPTY_STRING;
                continue;
            }
            destination[i] = this.revertEscape(temp);
            if (strTok.isNextDelimiterConsumed() || i == numRel - 1) continue;
            strTok.getNextTokenResolved();
        }
        return destination;
    }

    @Override
    public boolean isCompleteMessage(String msg) {
        if (this.getWorkingVersion().equals("1.2")) {
            return true;
        }
        if (msg == null) {
            return false;
        }
        while (!msg.endsWith(DELIMITER_STR)) {
            if (msg.endsWith(EOL)) {
                msg = msg.substring(0, msg.length() - EOL.length());
                continue;
            }
            return false;
        }
        try {
            if (msg.substring(0, msg.length() - 1).endsWith(ESCAPE_STR)) {
                int i = 0;
                while (msg.substring(0, msg.length() - i - 1).endsWith(ESCAPE_STR)) {
                    ++i;
                }
                if (i % 2 != 0) {
                    return false;
                }
                return this.isEnoughDelimiter(msg);
            }
            return this.isEnoughDelimiter(msg);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isParsable() {
        return true;
    }

    @Override
    public boolean isStartMessage(String msg) {
        if (this.getWorkingVersion().equals("1.2")) {
            return true;
        }
        if (msg == null) {
            return false;
        }
        String validStart = DELIMITER_STR;
        if (!msg.startsWith(validStart)) {
            return false;
        }
        if (msg.length() == 1) {
            return false;
        }
        LFStringTokenizer strTok = new LFStringTokenizer(new StringTokenizer(msg, DELIMITER_STR, true));
        if (strTok.countTokens() < 26) {
            return false;
        }
        int j = 0;
        while (strTok.hasMoreTokens()) {
            strTok.getNextTokenResolved();
            ++j;
        }
        return j >= 26;
    }

    private boolean isEnoughDelimiter(String msg) {
        LFStringTokenizer strTok = new LFStringTokenizer(new StringTokenizer(msg, DELIMITER_STR, true));
        if (strTok.countTokens() < 27) {
            return false;
        }
        strTok.getNextTokenResolved();
        String versionRead = strTok.getNextTokenResolved();
        int numArgs = 0;
        int baseNumDelim = 0;
        if (versionRead.length() > 3) {
            versionRead = versionRead.substring(0, 3);
        }
        if (versionRead.equals("1.3")) {
            baseNumDelim = 15;
        } else if (versionRead.equals("1.4")) {
            baseNumDelim = 19;
        } else if (versionRead.equals("1.5")) {
            baseNumDelim = 22;
        } else if (versionRead.equals(DEAFULT_COMPATIBILE_VERSION)) {
            baseNumDelim = 23;
        }
        int numDelim = 0;
        while (strTok.hasMoreTokens()) {
            String nextTok = strTok.getNextTokenResolved();
            if (nextTok.equals(DELIMITER_STR)) {
                if (!(++numDelim == 10 && versionRead.equals("1.3") || numDelim == 14 && versionRead.equals("1.4")) && (numDelim != 17 || !versionRead.equals("1.5"))) continue;
                nextTok = strTok.getNextTokenResolved();
                if (nextTok.equals(DELIMITER_STR)) {
                    ++numDelim;
                    continue;
                }
                int numRel = Integer.parseInt(nextTok);
                for (int i = 0; i < numRel && strTok.hasMoreTokens(); ++i) {
                    if (!strTok.isNextDelimiterConsumed()) {
                        strTok.getNextTokenResolved();
                    }
                    strTok.getNextTokenResolved();
                }
                continue;
            }
            if (numDelim == baseNumDelim) {
                numArgs = Integer.parseInt(nextTok);
            }
            if (!strTok.isNextDelimiterConsumed()) continue;
            ++numDelim;
        }
        if (numArgs > 0) {
            return numDelim == baseNumDelim + numArgs + 1;
        }
        return numDelim == baseNumDelim;
    }

    protected String revertEscape(String s) {
        StringBuffer buf = new StringBuffer(s);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            switch (buf.charAt(i)) {
                case '\\': {
                    buf.deleteCharAt(i);
                    --len;
                }
            }
        }
        return buf.toString();
    }

    @Deprecated
    private LogRecord parseMsg14(StringTokenizer _strTok) throws ParseException {
        return null;
    }

    @Deprecated
    private LogRecord parseMsg13(StringTokenizer _strTok) throws ParseException {
        return null;
    }

    @Deprecated
    private LogRecord parseMsg12(StringTokenizer _strTok) throws ParseException {
        return null;
    }

    private String removeFirstEOL(String s) {
        String eol = System.getProperty("line.separator");
        if (s.startsWith(eol)) {
            return s.substring(eol.length());
        }
        return s;
    }

    private class LFStringTokenizer {
        StringTokenizer theTokenizer;
        boolean nextDelimConsumed = false;

        LFStringTokenizer(StringTokenizer strTok) {
            this.theTokenizer = strTok;
        }

        String getNextTokenResolved() {
            if (!this.theTokenizer.hasMoreTokens()) {
                return null;
            }
            this.nextDelimConsumed = false;
            String nextTok = this.theTokenizer.nextToken();
            while (nextTok.endsWith(ESCAPE_STR)) {
                int i = 0;
                while (nextTok.substring(0, nextTok.length() - i).endsWith(ESCAPE_STR)) {
                    ++i;
                }
                if (i % 2 == 0) break;
                nextTok = nextTok.substring(0, nextTok.length() - 1);
                if (this.theTokenizer.hasMoreTokens()) {
                    nextTok = nextTok.concat(this.theTokenizer.nextToken());
                }
                if (!this.theTokenizer.hasMoreTokens()) continue;
                String tmpStr = this.theTokenizer.nextToken();
                if (tmpStr.equals(DELIMITER_STR)) {
                    this.nextDelimConsumed = true;
                    break;
                }
                nextTok = nextTok.concat(tmpStr);
            }
            return nextTok;
        }

        boolean hasMoreTokens() {
            return this.theTokenizer.hasMoreTokens();
        }

        int countTokens() {
            return this.theTokenizer.countTokens();
        }

        boolean isNextDelimiterConsumed() {
            return this.nextDelimConsumed;
        }
    }
}

