/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.rt.DefaultIDocRecordMetaData;
import com.sap.conn.idoc.rt.DefaultIDocSegmentMetaDataList;
import com.sap.conn.idoc.rt.util.Utils;
import java.io.Serializable;

public class DefaultIDocSegmentMetaData
implements IDocSegmentMetaData,
Serializable {
    static final long serialVersionUID = 1000L;
    protected String m_iDocType = null;
    protected String m_iDocTypeExtension = null;
    protected String m_systemRelease = null;
    protected String m_applicationRelease = null;
    protected String m_type = null;
    protected String m_definition = null;
    protected int m_hierarchyLevel = 0;
    protected String m_description = null;
    protected boolean m_mandatoryFlag = false;
    protected long m_minOccurrence = 0L;
    protected long m_maxOccurrence = 0L;
    protected boolean m_qualifiedFlag = false;
    protected DefaultIDocSegmentMetaData m_parent = null;
    protected DefaultIDocRecordMetaData m_recordMetaData = null;
    protected DefaultIDocSegmentMetaDataList m_childs = new DefaultIDocSegmentMetaDataList(5);
    protected transient String m_key = null;
    private boolean isLocked = false;

    protected DefaultIDocSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, DefaultIDocRecordMetaData recordMetaData) {
        this.m_iDocType = iDocType != null ? iDocType : "";
        this.m_iDocTypeExtension = iDocTypeExtension != null ? iDocTypeExtension : "";
        this.m_systemRelease = systemRelease != null ? Utils.removeAllDotsFromString(systemRelease) : "";
        this.m_applicationRelease = applicationRelease != null ? Utils.removeAllDotsFromString(applicationRelease) : "";
        this.m_type = type != null ? type : "";
        this.m_definition = definition != null ? definition : "";
        this.m_hierarchyLevel = hierarchyLevel;
        this.m_description = description != null ? description : "";
        this.m_mandatoryFlag = true;
        this.m_minOccurrence = 1L;
        this.m_maxOccurrence = 1L;
        this.m_qualifiedFlag = false;
        this.m_recordMetaData = recordMetaData;
    }

    protected DefaultIDocSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, boolean mandatoryFlag, long minOccurrence, long maxOccurrence, boolean qualifiedFlag, DefaultIDocRecordMetaData recordMetaData) {
        this.m_iDocType = iDocType != null ? iDocType : "";
        this.m_iDocTypeExtension = iDocTypeExtension != null ? iDocTypeExtension : "";
        this.m_systemRelease = systemRelease != null ? Utils.removeAllDotsFromString(systemRelease) : "";
        this.m_applicationRelease = applicationRelease != null ? Utils.removeAllDotsFromString(applicationRelease) : "";
        this.m_type = type != null ? type : "";
        this.m_definition = definition != null ? definition : "";
        this.m_hierarchyLevel = hierarchyLevel;
        this.m_description = description != null ? description : "";
        this.m_mandatoryFlag = mandatoryFlag;
        this.m_minOccurrence = minOccurrence;
        this.m_maxOccurrence = maxOccurrence;
        this.m_qualifiedFlag = qualifiedFlag;
        this.m_recordMetaData = recordMetaData;
        if (recordMetaData != null) {
            recordMetaData.setName(definition);
        }
    }

    protected DefaultIDocSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, int hierarchyLevel, String description) {
        this(iDocType, iDocTypeExtension, systemRelease, applicationRelease, type, type, hierarchyLevel, description, new DefaultIDocRecordMetaData(type));
    }

    public void addChild(IDocSegmentMetaData child) {
        if (this.isLocked()) {
            throw new IllegalStateException("This segment meta data object is locked");
        }
        if (!(child instanceof DefaultIDocSegmentMetaData)) {
            throw new IllegalArgumentException((child == null ? "null" : child.getClass().getName()) + " was passed to addChild");
        }
        this.m_childs.add(child);
        ((DefaultIDocSegmentMetaData)child).m_parent = this;
    }

    protected static final String calculateTypeFromDefinition(String definition, boolean enableVersionDeletion) {
        int length;
        if (definition == null) {
            return null;
        }
        StringBuilder type = null;
        if (enableVersionDeletion && (length = definition.length()) > 3) {
            boolean versionDetected = true;
            for (int i = length - 1; versionDetected && i > length - 4; --i) {
                if (Character.isDigit(definition.charAt(i))) continue;
                versionDetected = false;
            }
            if (versionDetected) {
                length = definition.charAt(length - 4) == '_' && length < 11 ? (length -= 4) : (length -= 3);
                type = new StringBuilder(definition.substring(0, length));
            }
        }
        if (type == null) {
            type = new StringBuilder(definition);
        }
        if (type.length() > 1 && type.charAt(0) != '/' && type.charAt(1) == '2') {
            type.setCharAt(1, '1');
        }
        return type.toString();
    }

    public static String createKey(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        StringBuilder key = new StringBuilder(100);
        key.append(iDocType);
        key.append('|');
        if (iDocTypeExtension != null) {
            key.append(iDocTypeExtension);
        }
        key.append('|');
        if (systemRelease != null) {
            key.append(Utils.removeAllDotsFromString(systemRelease));
        }
        key.append('|');
        if (applicationRelease != null) {
            key.append(Utils.removeAllDotsFromString(applicationRelease));
        }
        key.append('|');
        key.append(definition);
        return key.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IDocSegmentMetaData)) {
            return false;
        }
        IDocSegmentMetaData segmentMetaData = (IDocSegmentMetaData)object;
        if (this.m_iDocType != null ? !this.m_iDocType.equals(segmentMetaData.getIDocType()) : segmentMetaData.getIDocType() != null) {
            return false;
        }
        if (this.m_iDocTypeExtension != null ? !this.m_iDocTypeExtension.equals(segmentMetaData.getIDocTypeExtension()) : segmentMetaData.getIDocTypeExtension() != null) {
            return false;
        }
        if (this.m_systemRelease != null ? !this.m_systemRelease.equals(segmentMetaData.getSystemRelease()) : segmentMetaData.getSystemRelease() != null) {
            return false;
        }
        if (this.m_applicationRelease != null ? !this.m_applicationRelease.equals(segmentMetaData.getApplicationRelease()) : segmentMetaData.getApplicationRelease() != null) {
            return false;
        }
        if (this.m_type != null ? !this.m_type.equals(segmentMetaData.getType()) : segmentMetaData.getType() != null) {
            return false;
        }
        if (this.m_definition != null ? !this.m_definition.equals(segmentMetaData.getDefinition()) : segmentMetaData.getDefinition() != null) {
            return false;
        }
        if (this.m_hierarchyLevel != segmentMetaData.getHierarchyLevel()) {
            return false;
        }
        if (this.m_description != null ? !this.m_description.equals(segmentMetaData.getDescription()) : segmentMetaData.getDescription() != null) {
            return false;
        }
        if (this.m_mandatoryFlag != segmentMetaData.isMandatory()) {
            return false;
        }
        if (this.m_minOccurrence != segmentMetaData.getMinOccurrence()) {
            return false;
        }
        if (this.m_maxOccurrence != segmentMetaData.getMaxOccurrence()) {
            return false;
        }
        if (this.m_qualifiedFlag != segmentMetaData.isQualified()) {
            return false;
        }
        if (this.m_recordMetaData != null ? !this.m_recordMetaData.equals(segmentMetaData.getRecordMetaData()) : segmentMetaData.getRecordMetaData() != null) {
            return false;
        }
        if (this.m_childs.size() != segmentMetaData.getNumChildren()) {
            return false;
        }
        IDocSegmentMetaData myRootSegmentMetaData = this;
        while (myRootSegmentMetaData.isChild()) {
            myRootSegmentMetaData = myRootSegmentMetaData.getParent();
            if (segmentMetaData.isChild()) {
                segmentMetaData = segmentMetaData.getParent();
                continue;
            }
            return false;
        }
        if (segmentMetaData.isChild()) {
            return false;
        }
        return myRootSegmentMetaData.equalsIgnoreParent(segmentMetaData);
    }

    public boolean equalsIgnoreParent(IDocSegmentMetaData segmentMetaData) {
        if (segmentMetaData == this) {
            return true;
        }
        if (segmentMetaData == null) {
            return false;
        }
        if (this.m_iDocType != null ? !this.m_iDocType.equals(segmentMetaData.getIDocType()) : segmentMetaData.getIDocType() != null) {
            return false;
        }
        if (this.m_iDocTypeExtension != null ? !this.m_iDocTypeExtension.equals(segmentMetaData.getIDocTypeExtension()) : segmentMetaData.getIDocTypeExtension() != null) {
            return false;
        }
        if (this.m_systemRelease != null ? !this.m_systemRelease.equals(segmentMetaData.getSystemRelease()) : segmentMetaData.getSystemRelease() != null) {
            return false;
        }
        if (this.m_applicationRelease != null ? !this.m_applicationRelease.equals(segmentMetaData.getApplicationRelease()) : segmentMetaData.getApplicationRelease() != null) {
            return false;
        }
        if (this.m_type != null ? !this.m_type.equals(segmentMetaData.getType()) : segmentMetaData.getType() != null) {
            return false;
        }
        if (this.m_definition != null ? !this.m_definition.equals(segmentMetaData.getDefinition()) : segmentMetaData.getDefinition() != null) {
            return false;
        }
        if (this.m_hierarchyLevel != segmentMetaData.getHierarchyLevel()) {
            return false;
        }
        if (this.m_description != null ? !this.m_description.equals(segmentMetaData.getDescription()) : segmentMetaData.getDescription() != null) {
            return false;
        }
        if (this.m_mandatoryFlag != segmentMetaData.isMandatory()) {
            return false;
        }
        if (this.m_minOccurrence != segmentMetaData.getMinOccurrence()) {
            return false;
        }
        if (this.m_maxOccurrence != segmentMetaData.getMaxOccurrence()) {
            return false;
        }
        if (this.m_qualifiedFlag != segmentMetaData.isQualified()) {
            return false;
        }
        if (this.m_recordMetaData != null ? !this.m_recordMetaData.equals(segmentMetaData.getRecordMetaData()) : segmentMetaData.getRecordMetaData() != null) {
            return false;
        }
        if (this.m_childs.size() != segmentMetaData.getNumChildren()) {
            return false;
        }
        for (int i = 0; i < this.m_childs.size(); ++i) {
            if (this.m_childs.get(i).equalsIgnoreParent(segmentMetaData.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public String getApplicationRelease() {
        return this.m_applicationRelease;
    }

    public IDocSegmentMetaData getChild(int index) {
        return this.m_childs.get(index);
    }

    public IDocSegmentMetaData getChildByDefinition(String definition) {
        if (definition != null) {
            IDocSegmentMetaData child = null;
            int numChilds = this.m_childs.size();
            for (int i = 0; i < numChilds; ++i) {
                child = this.m_childs.get(i);
                if (!definition.equals(child.getDefinition())) continue;
                return child;
            }
        }
        return null;
    }

    public IDocSegmentMetaData getChildByType(String type) {
        if (type != null) {
            IDocSegmentMetaData child = null;
            int numChilds = this.m_childs.size();
            for (int i = 0; i < numChilds; ++i) {
                child = this.m_childs.get(i);
                if (!type.equals(child.getType())) continue;
                return child;
            }
        }
        return null;
    }

    public IDocSegmentMetaData getChildMatchingDefinition(String definition) {
        String type;
        IDocSegmentMetaData child = null;
        if (definition != null && this.m_childs != null && (child = this.getChildByDefinition(definition)) == null && (child = this.getChildByType(type = DefaultIDocSegmentMetaData.calculateTypeFromDefinition(definition, true))) == null && type.length() < definition.length()) {
            type = DefaultIDocSegmentMetaData.calculateTypeFromDefinition(definition, false);
            child = this.getChildByType(type);
        }
        return child;
    }

    public IDocSegmentMetaData[] getChildren() {
        return this.m_childs.toArray();
    }

    public String[] getChildTypes() {
        int numChildren = this.m_childs.size();
        String[] childTypes = new String[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            childTypes[i] = this.m_childs.get(i).getType();
        }
        return childTypes;
    }

    public String getDefinition() {
        return this.m_definition;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getHierarchyLevel() {
        return this.m_hierarchyLevel;
    }

    public String getIDocType() {
        return this.m_iDocType;
    }

    public String getIDocTypeExtension() {
        return this.m_iDocTypeExtension;
    }

    public String getKey() {
        if (this.m_key == null) {
            this.m_key = DefaultIDocSegmentMetaData.createKey(this.m_iDocType, this.m_iDocTypeExtension, this.m_systemRelease, this.m_applicationRelease, this.m_definition);
        }
        return this.m_key;
    }

    public long getMaxOccurrence() {
        return this.m_maxOccurrence;
    }

    public long getMinOccurrence() {
        return this.m_minOccurrence;
    }

    public String getName() {
        if (this.m_recordMetaData == null) {
            return this.m_definition;
        }
        return this.m_recordMetaData.getName();
    }

    public int getNumChildren() {
        return this.m_childs.size();
    }

    public IDocSegmentMetaData getParent() {
        return this.m_parent;
    }

    public IDocRecordMetaData getRecordMetaData() {
        return this.m_recordMetaData;
    }

    public String getSystemRelease() {
        return this.m_systemRelease;
    }

    public String getType() {
        return this.m_type;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public int indexOfChild(IDocSegmentMetaData segmentMetaData) {
        return this.m_childs.indexOf(segmentMetaData);
    }

    public boolean isChild() {
        return this.m_parent != null;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isMandatory() {
        return this.m_mandatoryFlag;
    }

    public boolean isParent() {
        return this.m_childs.size() > 0;
    }

    public boolean isQualified() {
        return this.m_qualifiedFlag;
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public void lock() {
        if (!this.isLocked) {
            this.getRecordMetaData().lock();
            for (int i = 0; i < this.m_childs.size(); ++i) {
                this.m_childs.get(i).lock();
            }
            this.isLocked = true;
        }
    }
}

