/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.jco.rt.JCoIDocDocument;
import com.sap.conn.idoc.jco.rt.JCoIDocSegment;
import com.sap.conn.idoc.jco.rt.JCoStaticRepositories;
import com.sap.conn.idoc.jco.rt.JCoStaticRepository;
import com.sap.conn.idoc.jco.rt.RawTable;
import com.sap.conn.idoc.rt.DefaultIDocDocument;
import com.sap.conn.idoc.rt.DefaultIDocDocumentList;
import com.sap.conn.idoc.rt.DefaultIDocSegment;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;

public class JCoIDocDocumentList
extends DefaultIDocDocumentList {
    static final long serialVersionUID = 1000L;

    protected JCoIDocDocumentList(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        super(repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    protected JCoIDocDocumentList(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        super(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    protected static JCoFunction createJCoFunction(IDocDocumentList docList, char iDocVersion, int options, JCoAttributes attributes, String queueName) {
        JCoFunction function = null;
        String systemRelease = null;
        String codepage = null;
        boolean isUnicode = false;
        boolean isNonAbapPartner = true;
        if (attributes != null) {
            systemRelease = attributes.getPartnerRelease();
            codepage = attributes.getPartnerCodepage();
            isUnicode = JCoStaticRepositories.isPartnerSystemUnicode(attributes);
            char partnerType = attributes.getPartnerType();
            boolean bl = isNonAbapPartner = partnerType != '2' && partnerType != '3';
        }
        if (iDocVersion != '0' && iDocVersion != '2' && iDocVersion != '3' && iDocVersion != 'Q' && iDocVersion != 'I' && iDocVersion != '8') {
            iDocVersion = (char)48;
        }
        boolean useInQueue = false;
        if (queueName != null && queueName.length() > 0 && (iDocVersion == 'Q' || iDocVersion == 'I' || iDocVersion == '8')) {
            if (systemRelease != null && systemRelease.length() > 0 && systemRelease.compareTo("64") >= 0 || isNonAbapPartner) {
                useInQueue = true;
            } else {
                throw new IDocRuntimeException("Queueing of IDocs at application layer requires an SAP AS ABAP backend system of at least release 6.40 (SAP_BASIS)." + (attributes != null ? " The release of system " + attributes.getSystemID() + " is only " + systemRelease : ""));
            }
        }
        JCoStaticRepository jcoStaticRepository = JCoStaticRepositories.getJCoStaticRepository(systemRelease);
        RawTable controlTable = null;
        RawTable dataTable = null;
        if (iDocVersion != '2' && (systemRelease == null || systemRelease.length() == 0 || systemRelease.compareTo("4") >= 0 || isNonAbapPartner)) {
            if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                function = jcoStaticRepository.getFunction(useInQueue ? "IDOC_INBOUND_IN_QUEUE" : "IDOC_INBOUND_ASYNCHRONOUS");
            } else {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, new StringBuilder(100).append("[IDocRFC] Faking binary meta data for client. Will do conversion for codepage " + codepage + " in IDocLibrary").toString());
                }
                function = jcoStaticRepository.getFunction(useInQueue ? "IDOC_INBOUND_IN_QUEUE_WITH_BINARY_DATA" : "IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA");
            }
            controlTable = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
            if (useInQueue) {
                dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_QUEUE");
                function.getImportParameterList().setValue(0, queueName);
            } else {
                dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_REC_40");
            }
        } else {
            if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                function = jcoStaticRepository.getFunction("INBOUND_IDOC_PROCESS");
            } else {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, new StringBuilder(100).append("[IDocRFC] Faking binary meta data for client. Will do conversion for codepage " + codepage + " in IDocLibrary").toString());
                }
                function = jcoStaticRepository.getFunction("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA");
            }
            controlTable = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL");
            dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA");
        }
        int numSegments = 0;
        IDocDocument[] documents = docList.toArray();
        for (int i = 0; i < documents.length; ++i) {
            numSegments += documents[i].getNumSegments() - 1;
        }
        controlTable.ensureBufferCapacity(documents.length);
        dataTable.ensureBufferCapacity(numSegments);
        String iDocNumber = null;
        for (int i = 0; i < documents.length; ++i) {
            if (!documents[i].getRootSegment().isParent()) continue;
            iDocNumber = JCoIDocDocument.createJCoIDocNumber(documents[i]);
            if (documents[i] instanceof JCoIDocDocument) {
                JCoIDocDocument.appendRowToJCoControlTable(controlTable, (JCoIDocDocument)documents[i], iDocNumber);
            } else {
                JCoIDocDocument.copyControlDataToJCoControlTable((JCoTable)controlTable, documents[i], iDocNumber);
            }
            JCoIDocDocument.appendRowsToJCoDataTable(dataTable, useInQueue, documents[i], iDocNumber, codepage);
        }
        return function;
    }

    protected DefaultIDocDocument createDefaultIDocDocument(String controlStructName) {
        return new JCoIDocDocument(this.m_controlStructName);
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new JCoIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }
}

